/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.sql.core;

import com.google.cloud.sql.IpType;
import com.google.cloud.sql.core.InstanceMetadata;
import com.google.cloud.sql.core.SslData;
import java.time.Instant;
import java.util.Map;
import javax.net.ssl.SSLContext;

class ConnectionInfo {
    private final InstanceMetadata instanceMetadata;
    private final SSLContext sslContext;
    private final SslData sslData;
    private final Instant expiration;

    ConnectionInfo(InstanceMetadata instanceMetadata, SslData sslData, Instant expiration) {
        this.instanceMetadata = instanceMetadata;
        this.sslData = sslData;
        this.sslContext = sslData.getSslContext();
        this.expiration = expiration;
    }

    public Instant getExpiration() {
        return this.expiration;
    }

    SSLContext getSslContext() {
        return this.sslContext;
    }

    Map<IpType, String> getIpAddrs() {
        return this.instanceMetadata.getIpAddrs();
    }

    SslData getSslData() {
        return this.sslData;
    }
}

