/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.sql.core;

import com.google.cloud.sql.ConnectorConfig;
import com.google.cloud.sql.CredentialFactory;
import com.google.cloud.sql.core.ConnectionConfig;
import com.google.cloud.sql.core.ConnectionInfoRepositoryFactory;
import com.google.cloud.sql.core.DefaultConnectionInfoCache;
import com.google.cloud.sql.core.DefaultConnectionInfoRepository;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.security.KeyPair;
import java.util.concurrent.ConcurrentHashMap;
import javax.net.ssl.SSLSocket;
import jnr.unixsocket.UnixSocketAddress;
import jnr.unixsocket.UnixSocketChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Connector {
    private static final Logger logger = LoggerFactory.getLogger(Connector.class);
    private final DefaultConnectionInfoRepository adminApi;
    private final CredentialFactory instanceCredentialFactory;
    private final ListeningScheduledExecutorService executor;
    private final ListenableFuture<KeyPair> localKeyPair;
    private final long minRefreshDelayMs;
    private final ConcurrentHashMap<ConnectionConfig, DefaultConnectionInfoCache> instances = new ConcurrentHashMap();
    private final long refreshTimeoutMs;
    private final int serverProxyPort;
    private final ConnectorConfig config;

    Connector(ConnectorConfig config, ConnectionInfoRepositoryFactory connectionInfoRepositoryFactory, CredentialFactory instanceCredentialFactory, ListeningScheduledExecutorService executor, ListenableFuture<KeyPair> localKeyPair, long minRefreshDelayMs, long refreshTimeoutMs, int serverProxyPort) {
        this.config = config;
        this.adminApi = connectionInfoRepositoryFactory.create(instanceCredentialFactory.create(), config);
        this.instanceCredentialFactory = instanceCredentialFactory;
        this.executor = executor;
        this.localKeyPair = localKeyPair;
        this.minRefreshDelayMs = minRefreshDelayMs;
        this.refreshTimeoutMs = refreshTimeoutMs;
        this.serverProxyPort = serverProxyPort;
    }

    public ConnectorConfig getConfig() {
        return this.config;
    }

    private String getUnixSocketArg(ConnectionConfig config) {
        String unixSocketPath = config.getUnixSocketPath();
        if (unixSocketPath != null) {
            return unixSocketPath;
        }
        if (System.getenv("CLOUD_SQL_FORCE_UNIX_SOCKET") != null) {
            logger.debug(String.format("\"CLOUD_SQL_FORCE_UNIX_SOCKET\" env var has been deprecated. Please use '%s=\"/cloudsql/INSTANCE_CONNECTION_NAME\"' property in your JDBC url instead.", "unixSocketPath"));
            return "/cloudsql/" + config.getCloudSqlInstance();
        }
        return null;
    }

    Socket connect(ConnectionConfig config) throws IOException {
        String unixSocket = this.getUnixSocketArg(config);
        String unixPathSuffix = config.getUnixSocketPathSuffix();
        if (unixSocket != null) {
            if (unixPathSuffix != null && !unixSocket.endsWith(unixPathSuffix)) {
                unixSocket = unixSocket + unixPathSuffix;
            }
            logger.debug(String.format("Connecting to Cloud SQL instance [%s] via unix socket at %s.", config.getCloudSqlInstance(), unixSocket));
            UnixSocketAddress socketAddress = new UnixSocketAddress(new File(unixSocket));
            return UnixSocketChannel.open((UnixSocketAddress)socketAddress).socket();
        }
        DefaultConnectionInfoCache instance = this.getConnection(config);
        try {
            SSLSocket socket = instance.createSslSocket(this.refreshTimeoutMs);
            socket.setKeepAlive(true);
            socket.setTcpNoDelay(true);
            String instanceIp = instance.getConnectionMetadata(this.refreshTimeoutMs).getPreferredIpAddress();
            socket.connect(new InetSocketAddress(instanceIp, this.serverProxyPort));
            socket.startHandshake();
            return socket;
        }
        catch (IOException e) {
            instance.forceRefresh();
            throw e;
        }
    }

    DefaultConnectionInfoCache getConnection(ConnectionConfig config) {
        return this.instances.computeIfAbsent(config, k -> this.createConnectionInfo(config));
    }

    private DefaultConnectionInfoCache createConnectionInfo(ConnectionConfig config) {
        return new DefaultConnectionInfoCache(config, this.adminApi, this.instanceCredentialFactory, this.executor, this.localKeyPair, this.minRefreshDelayMs);
    }

    public void close() {
        this.instances.forEach((key, c) -> c.close());
        this.instances.clear();
    }
}

