/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.sql.core;

import com.google.cloud.sql.AuthType;
import com.google.cloud.sql.CredentialFactory;
import com.google.cloud.sql.IpType;
import com.google.cloud.sql.core.AccessTokenSupplier;
import com.google.cloud.sql.core.AsyncRateLimiter;
import com.google.cloud.sql.core.CloudSqlInstanceName;
import com.google.cloud.sql.core.ConnectionConfig;
import com.google.cloud.sql.core.ConnectionInfo;
import com.google.cloud.sql.core.ConnectionInfoRepository;
import com.google.cloud.sql.core.ConnectionMetadata;
import com.google.cloud.sql.core.DefaultAccessTokenSupplier;
import com.google.cloud.sql.core.Refresher;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import java.io.IOException;
import java.security.KeyPair;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.net.ssl.SSLSocket;

class DefaultConnectionInfoCache {
    private final AccessTokenSupplier accessTokenSupplier;
    private final CloudSqlInstanceName instanceName;
    private final Refresher refresher;
    private final ConnectionConfig config;

    DefaultConnectionInfoCache(ConnectionConfig config, ConnectionInfoRepository connectionInfoRepository, CredentialFactory tokenSourceFactory, ListeningScheduledExecutorService executor, ListenableFuture<KeyPair> keyPair, long minRefreshDelayMs) {
        this.instanceName = new CloudSqlInstanceName(config.getCloudSqlInstance());
        this.config = config;
        this.accessTokenSupplier = config.getAuthType() == AuthType.IAM ? new DefaultAccessTokenSupplier(tokenSourceFactory) : Optional::empty;
        this.refresher = new Refresher(config.getCloudSqlInstance(), executor, () -> connectionInfoRepository.getConnectionInfo(this.instanceName, this.accessTokenSupplier, config.getAuthType(), executor, keyPair), new AsyncRateLimiter(minRefreshDelayMs));
    }

    private ConnectionInfo getConnectionInfo(long timeoutMs) {
        return this.refresher.getConnectionInfo(timeoutMs);
    }

    SSLSocket createSslSocket(long timeoutMs) throws IOException {
        return (SSLSocket)this.getConnectionInfo(timeoutMs).getSslContext().getSocketFactory().createSocket();
    }

    ConnectionMetadata getConnectionMetadata(long timeoutMs) {
        ConnectionInfo info = this.getConnectionInfo(timeoutMs);
        String preferredIp = null;
        for (IpType ipType : this.config.getIpTypes()) {
            preferredIp = info.getIpAddrs().get((Object)ipType);
            if (preferredIp == null) continue;
            break;
        }
        if (preferredIp == null) {
            throw new IllegalArgumentException(String.format("[%s] Cloud SQL instance  does not have any IP addresses matching preferences (%s)", this.instanceName.getConnectionName(), this.config.getIpTypes().stream().map(Enum::toString).collect(Collectors.joining(","))));
        }
        return new ConnectionMetadata(preferredIp, info.getSslData().getKeyManagerFactory(), info.getSslData().getTrustManagerFactory());
    }

    void forceRefresh() {
        this.refresher.forceRefresh();
    }

    ListenableFuture<ConnectionInfo> getNext() {
        return this.refresher.getNext();
    }

    ListenableFuture<ConnectionInfo> getCurrent() {
        return this.refresher.getCurrent();
    }

    public CloudSqlInstanceName getInstanceName() {
        return this.instanceName;
    }

    void close() {
        this.refresher.close();
    }
}

