/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.sql.core;

import com.google.api.client.http.HttpRequestInitializer;
import com.google.auth.Credentials;
import com.google.auth.http.HttpCredentialsAdapter;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.cloud.sql.CredentialFactory;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

class FileCredentialFactory
implements CredentialFactory {
    private final String path;

    FileCredentialFactory(String path) {
        this.path = path;
    }

    @Override
    public HttpRequestInitializer create() {
        return new HttpCredentialsAdapter((Credentials)this.getCredentials());
    }

    @Override
    public GoogleCredentials getCredentials() {
        try {
            return GoogleCredentials.fromStream((InputStream)new FileInputStream(this.path));
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to load GoogleCredentials from file " + this.path, e);
        }
    }
}

