/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.sql.core;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.LongSupplier;

class AsyncRateLimiter {
    private long nextOperationTimestamp;
    private final long delayBetweenAttempts;
    private final LongSupplier currentTimestampMs;

    AsyncRateLimiter(long delayBetweenAttempts) {
        this(delayBetweenAttempts, System::currentTimeMillis);
    }

    AsyncRateLimiter(long delayBetweenAttempts, LongSupplier currentTimestampMs) {
        this.delayBetweenAttempts = delayBetweenAttempts;
        this.currentTimestampMs = currentTimestampMs;
    }

    private synchronized long nextDelayMs(long nowTimestampMs) {
        if (this.nextOperationTimestamp <= nowTimestampMs) {
            this.nextOperationTimestamp = nowTimestampMs + this.delayBetweenAttempts;
            return 0L;
        }
        return this.nextOperationTimestamp - nowTimestampMs;
    }

    public ListenableFuture<?> acquireAsync(ScheduledExecutorService executor) {
        long limit = this.nextDelayMs(this.currentTimestampMs.getAsLong());
        if (limit > 0L) {
            return Futures.scheduleAsync(() -> this.acquireAsync(executor), (long)limit, (TimeUnit)TimeUnit.MILLISECONDS, (ScheduledExecutorService)executor);
        }
        return Futures.immediateFuture(null);
    }
}

