/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.sql.core;

import java.time.Duration;
import java.util.concurrent.Callable;
import java.util.concurrent.ThreadLocalRandom;

class RetryingCallable<T>
implements Callable<T> {
    private final Callable<T> callable;
    private final int retryCount;
    private final Duration sleepDuration;

    public RetryingCallable(Callable<T> callable, int retryCount, Duration sleepDuration) {
        if (retryCount <= 0) {
            throw new IllegalArgumentException("retryCount must be > 0");
        }
        if (sleepDuration.isNegative() || sleepDuration.isZero()) {
            throw new IllegalArgumentException("sleepDuration must be positive");
        }
        if (callable == null) {
            throw new IllegalArgumentException("call must not be null");
        }
        this.callable = callable;
        this.retryCount = retryCount;
        this.sleepDuration = sleepDuration;
    }

    @Override
    public T call() throws Exception {
        for (int retriesLeft = this.retryCount - 1; retriesLeft >= 0; --retriesLeft) {
            try {
                return this.callable.call();
            }
            catch (Exception e) {
                if (retriesLeft == 0) {
                    throw e;
                }
                long sleep = ThreadLocalRandom.current().nextLong(this.sleepDuration.toMillis(), this.sleepDuration.toMillis() * 2L);
                try {
                    Thread.sleep(sleep);
                    continue;
                }
                catch (InterruptedException ie) {
                    throw e;
                }
            }
        }
        throw new RuntimeException("call was never called.");
    }
}

