/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.sql.nativeimage;

import com.google.api.gax.nativeimage.NativeImageUtils;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeClassInitialization;
import org.graalvm.nativeimage.hosted.RuntimeReflection;

final class CloudSqlFeature
implements Feature {
    private static final String CLOUD_SQL_SOCKET_CLASS = "com.google.cloud.sql.core.CoreSocketFactory";
    private static final String POSTGRES_SOCKET_CLASS = "com.google.cloud.sql.postgres.SocketFactory";
    private static final String MYSQL_SOCKET_CLASS = "com.google.cloud.sql.mysql.SocketFactory";

    CloudSqlFeature() {
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        Class bouncyCastleAlpnSslUtils;
        if (access.findClassByName(CLOUD_SQL_SOCKET_CLASS) == null) {
            return;
        }
        NativeImageUtils.registerClassForReflection((Feature.FeatureAccess)access, (String)CLOUD_SQL_SOCKET_CLASS);
        if (access.findClassByName("com.zaxxer.hikari.HikariConfig") != null) {
            NativeImageUtils.registerClassForReflection((Feature.FeatureAccess)access, (String)"com.zaxxer.hikari.HikariConfig");
            RuntimeReflection.register((Class[])new Class[]{access.findClassByName("[Lcom.zaxxer.hikari.util.ConcurrentBag$IConcurrentBagEntry;")});
            RuntimeReflection.register((Class[])new Class[]{access.findClassByName("[Ljava.sql.Statement;")});
        }
        if (access.findClassByName(POSTGRES_SOCKET_CLASS) != null) {
            NativeImageUtils.registerClassForReflection((Feature.FeatureAccess)access, (String)POSTGRES_SOCKET_CLASS);
            NativeImageUtils.registerClassForReflection((Feature.FeatureAccess)access, (String)"org.postgresql.PGProperty");
        }
        if (access.findClassByName(MYSQL_SOCKET_CLASS) != null) {
            Class mySqlNonTransientException;
            Class mySqlNonTransientConnectionException;
            NativeImageUtils.registerClassForReflection((Feature.FeatureAccess)access, (String)MYSQL_SOCKET_CLASS);
            NativeImageUtils.registerClassForReflection((Feature.FeatureAccess)access, (String)"com.mysql.jdbc.StandardSocketFactory");
            NativeImageUtils.registerConstructorsForReflection((Feature.FeatureAccess)access, (String)"com.mysql.cj.conf.url.SingleConnectionUrl");
            NativeImageUtils.registerConstructorsForReflection((Feature.FeatureAccess)access, (String)"com.mysql.jdbc.log.StandardLogger");
            NativeImageUtils.registerConstructorsForReflection((Feature.FeatureAccess)access, (String)"com.mysql.cj.log.StandardLogger");
            Class cjExceptionClass = access.findClassByName("com.mysql.cj.exceptions.CJException");
            if (cjExceptionClass != null) {
                access.registerSubtypeReachabilityHandler((duringAccess, exceptionClass) -> NativeImageUtils.registerClassForReflection((Feature.FeatureAccess)duringAccess, (String)exceptionClass.getName()), cjExceptionClass);
            }
            if ((mySqlNonTransientConnectionException = access.findClassByName("com.mysql.jdbc.exceptions.jdbc4.MySQLNonTransientConnectionException")) != null) {
                NativeImageUtils.registerConstructorsForReflection((Feature.FeatureAccess)access, (String)mySqlNonTransientConnectionException.getName());
            }
            if ((mySqlNonTransientException = access.findClassByName("com.mysql.jdbc.exceptions.MySQLNonTransientException")) != null) {
                NativeImageUtils.registerConstructorsForReflection((Feature.FeatureAccess)access, (String)mySqlNonTransientException.getName());
            }
            RuntimeClassInitialization.initializeAtRunTime((String[])new String[]{"com.mysql.cj.jdbc"});
        }
        if ((bouncyCastleAlpnSslUtils = access.findClassByName("io.netty.handler.ssl.BouncyCastleAlpnSslUtils")) != null) {
            RuntimeClassInitialization.initializeAtRunTime((Class[])new Class[]{bouncyCastleAlpnSslUtils});
        }
    }
}

