/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.sql.core;

import com.google.cloud.sql.core.CloudSqlInstanceName;
import java.net.Socket;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedTrustManager;

class InstanceCheckingTrustManger
extends X509ExtendedTrustManager {
    private final X509ExtendedTrustManager tm;
    private final CloudSqlInstanceName instanceName;

    public InstanceCheckingTrustManger(CloudSqlInstanceName instanceName, X509ExtendedTrustManager tm) {
        this.instanceName = instanceName;
        this.tm = tm;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        this.tm.checkClientTrusted(chain, authType, socket);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
        this.tm.checkClientTrusted(chain, authType, engine);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.tm.checkClientTrusted(chain, authType);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        this.tm.checkServerTrusted(chain, authType, socket);
        this.checkCertificateChain(chain);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
        this.tm.checkServerTrusted(chain, authType, engine);
        this.checkCertificateChain(chain);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.tm.checkServerTrusted(chain, authType);
        this.checkCertificateChain(chain);
    }

    private void checkCertificateChain(X509Certificate[] chain) throws CertificateException {
        if (chain.length == 0) {
            throw new CertificateException("No server certificates in chain");
        }
        if (chain[0].getSubjectX500Principal() == null) {
            throw new CertificateException("Subject is missing");
        }
        String cn = null;
        try {
            String subject = chain[0].getSubjectX500Principal().getName();
            LdapName subjectName = new LdapName(subject);
            for (Rdn rdn : subjectName.getRdns()) {
                if (!"CN".equals(rdn.getType())) continue;
                cn = (String)rdn.getValue();
            }
        }
        catch (InvalidNameException e) {
            throw new CertificateException("Exception parsing the server certificate subject field", e);
        }
        if (cn == null) {
            throw new CertificateException("Server certificate subject does not contain a value for CN");
        }
        String instName = this.instanceName.getProjectId() + ":" + this.instanceName.getInstanceId();
        if (!instName.equals(cn)) {
            throw new CertificateException("Server certificate CN does not match instance name. Server certificate CN=" + cn + " Expected instance name: " + instName);
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.tm.getAcceptedIssuers();
    }
}

