/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.sql.core;

import com.google.cloud.sql.core.ConnectionInfo;
import com.google.cloud.sql.core.RefreshStrategy;
import com.google.cloud.sql.core.TerminalException;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import java.time.Instant;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LazyRefreshStrategy
implements RefreshStrategy {
    private final Logger logger = LoggerFactory.getLogger(LazyRefreshStrategy.class);
    private final String name;
    private final Supplier<ConnectionInfo> refreshOperation;
    private final Object connectionInfoGuard = new Object();
    @GuardedBy(value="connectionInfoGuard")
    private ConnectionInfo connectionInfo;
    @GuardedBy(value="connectionInfoGuard")
    private boolean closed;

    public LazyRefreshStrategy(String name, Supplier<ConnectionInfo> refreshOperation) {
        this.name = name;
        this.refreshOperation = refreshOperation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConnectionInfo getConnectionInfo(long timeoutMs) {
        Object object = this.connectionInfoGuard;
        synchronized (object) {
            if (this.closed) {
                throw new IllegalStateException(String.format("[%s] Lazy Refresh: Named connection closed.", this.name));
            }
            if (this.connectionInfo == null) {
                this.logger.debug(String.format("[%s] Lazy Refresh Operation: No client certificate. Starting next refresh operation immediately.", this.name));
                this.fetchConnectionInfo();
            }
            if (Instant.now().isAfter(this.connectionInfo.getExpiration())) {
                this.logger.debug(String.format("[%s] Lazy Refresh Operation: Client certificate has expired. Starting next refresh operation immediately.", this.name));
                this.fetchConnectionInfo();
            }
            return this.connectionInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetchConnectionInfo() {
        Object object = this.connectionInfoGuard;
        synchronized (object) {
            this.logger.debug(String.format("[%s] Lazy Refresh Operation: Starting refresh operation.", this.name));
            try {
                this.connectionInfo = this.refreshOperation.get();
                this.logger.debug(String.format("[%s] Lazy Refresh Operation: Completed refresh with new certificate expiration at %s.", this.name, this.connectionInfo.getExpiration().toString()));
            }
            catch (TerminalException e) {
                this.logger.debug(String.format("[%s] Lazy Refresh Operation: Failed! No retry.", this.name), (Throwable)e);
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("[%s] Refresh Operation: Failed!", this.name), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forceRefresh() {
        Object object = this.connectionInfoGuard;
        synchronized (object) {
            if (this.closed) {
                throw new IllegalStateException(String.format("[%s] Lazy Refresh: Named connection closed.", this.name));
            }
            this.connectionInfo = null;
            this.logger.debug(String.format("[%s] Lazy Refresh Operation: Forced refresh.", this.name));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshIfExpired() {
        Object object = this.connectionInfoGuard;
        synchronized (object) {
            if (this.closed) {
                throw new IllegalStateException(String.format("[%s] Lazy Refresh: Named connection closed.", this.name));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.connectionInfoGuard;
        synchronized (object) {
            this.closed = true;
            this.logger.debug(String.format("[%s] Lazy Refresh Operation: Connector closed.", this.name));
        }
    }
}

