/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.sql.core;

import com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.services.sqladmin.SQLAdmin;
import com.google.auth.Credentials;
import com.google.auth.http.HttpCredentialsAdapter;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.cloud.sql.CredentialFactory;
import com.google.cloud.sql.core.CloudSqlInstance;
import com.google.cloud.sql.core.SslData;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.logging.Logger;
import javax.net.ssl.SSLSocket;
import jnr.unixsocket.UnixSocketAddress;
import jnr.unixsocket.UnixSocketChannel;

public final class CoreSocketFactory {
    public static final String CLOUD_SQL_INSTANCE_PROPERTY = "cloudSqlInstance";
    private static final String UNIX_SOCKET_PROPERTY = "unixSocketPath";
    @Deprecated
    public static final String USER_TOKEN_PROPERTY_NAME = "_CLOUD_SQL_USER_TOKEN";
    private static final Logger logger = Logger.getLogger(CoreSocketFactory.class.getName());
    private static final String DEFAULT_IP_TYPES = "PUBLIC,PRIVATE";
    private static final String API_ROOT_URL_PROPERTY = "_CLOUD_SQL_API_ROOT_URL";
    private static final String API_SERVICE_PATH_PROPERTY = "_CLOUD_SQL_API_SERVICE_PATH";
    private static final int DEFAULT_SERVER_PROXY_PORT = 3307;
    private static final int RSA_KEY_SIZE = 2048;
    private static CoreSocketFactory coreSocketFactory;
    private final ListenableFuture<KeyPair> localKeyPair;
    private final ConcurrentHashMap<String, CloudSqlInstance> instances = new ConcurrentHashMap();
    private final ListeningScheduledExecutorService executor;
    private final SQLAdmin adminApi;
    private final int serverProxyPort;
    private static List<String> userAgents;
    private static String version;

    @VisibleForTesting
    CoreSocketFactory(ListenableFuture<KeyPair> localKeyPair, SQLAdmin adminApi, int serverProxyPort, ListeningScheduledExecutorService executor) {
        this.adminApi = adminApi;
        this.serverProxyPort = serverProxyPort;
        this.executor = executor;
        this.localKeyPair = localKeyPair;
    }

    public static synchronized CoreSocketFactory getInstance() {
        if (coreSocketFactory == null) {
            CredentialFactory credentialFactory;
            logger.info("First Cloud SQL connection, generating RSA key pair.");
            if (System.getProperty("cloudSql.socketFactory.credentialFactory") != null) {
                try {
                    credentialFactory = (CredentialFactory)Class.forName(System.getProperty("cloudSql.socketFactory.credentialFactory")).newInstance();
                }
                catch (Exception err) {
                    throw new RuntimeException(err);
                }
            } else {
                credentialFactory = new ApplicationDefaultCredentialFactory();
            }
            HttpRequestInitializer credential = credentialFactory.create();
            SQLAdmin adminApi = CoreSocketFactory.createAdminApiClient(credential);
            ListeningScheduledExecutorService executor = CoreSocketFactory.getDefaultExecutor();
            coreSocketFactory = new CoreSocketFactory((ListenableFuture<KeyPair>)executor.submit(CoreSocketFactory::generateRsaKeyPair), adminApi, 3307, executor);
        }
        return coreSocketFactory;
    }

    private CloudSqlInstance getCloudSqlInstance(String instanceName) {
        return this.instances.computeIfAbsent(instanceName, k -> new CloudSqlInstance((String)k, this.adminApi, this.executor, this.localKeyPair));
    }

    static int getDefaultServerProxyPort() {
        return 3307;
    }

    @VisibleForTesting
    static ListeningScheduledExecutorService getDefaultExecutor() {
        ScheduledThreadPoolExecutor executor = (ScheduledThreadPoolExecutor)Executors.newScheduledThreadPool(2);
        executor.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        return MoreExecutors.listeningDecorator((ScheduledExecutorService)MoreExecutors.getExitingScheduledExecutorService((ScheduledThreadPoolExecutor)executor));
    }

    private static String getUnixSocketArg(Properties props) {
        String unixSocketPath = props.getProperty(UNIX_SOCKET_PROPERTY);
        if (unixSocketPath != null) {
            return unixSocketPath;
        }
        if (System.getenv("CLOUD_SQL_FORCE_UNIX_SOCKET") != null) {
            logger.warning(String.format("\"CLOUD_SQL_FORCE_UNIX_SOCKET\" env var has been deprecated. Please use '%s=\"/cloudsql/INSTANCE_CONNECTION_NAME\"' property in your JDBC url instead.", UNIX_SOCKET_PROPERTY));
            return "/cloudsql/" + props.getProperty(CLOUD_SQL_INSTANCE_PROPERTY);
        }
        return null;
    }

    public static Socket connect(Properties props) throws IOException {
        return CoreSocketFactory.connect(props, null);
    }

    public static Socket connect(Properties props, String unixPathSuffix) throws IOException {
        String csqlInstanceName = props.getProperty(CLOUD_SQL_INSTANCE_PROPERTY);
        Preconditions.checkArgument((csqlInstanceName != null ? 1 : 0) != 0, (Object)"cloudSqlInstance property not set. Please specify this property in the JDBC URL or the connection Properties with value in form \"project:region:instance\"");
        String unixSocket = CoreSocketFactory.getUnixSocketArg(props);
        if (unixSocket != null) {
            if (unixPathSuffix != null && !unixSocket.endsWith(unixPathSuffix)) {
                unixSocket = unixSocket + unixPathSuffix;
            }
            logger.info(String.format("Connecting to Cloud SQL instance [%s] via unix socket at %s.", csqlInstanceName, unixSocket));
            UnixSocketAddress socketAddress = new UnixSocketAddress(new File(unixSocket));
            return UnixSocketChannel.open((UnixSocketAddress)socketAddress).socket();
        }
        List<String> ipTypes = CoreSocketFactory.listIpTypes(props.getProperty("ipTypes", DEFAULT_IP_TYPES));
        logger.info(String.format("Connecting to Cloud SQL instance [%s] via SSL socket.", csqlInstanceName));
        return CoreSocketFactory.getInstance().createSslSocket(csqlInstanceName, ipTypes);
    }

    public static SslData getSslData(String csqlInstanceName) {
        return CoreSocketFactory.getInstance().getCloudSqlInstance(csqlInstanceName).getSslData();
    }

    public static String getHostIp(String csqlInstanceName) {
        return CoreSocketFactory.getInstance().getHostIp(csqlInstanceName, CoreSocketFactory.listIpTypes(DEFAULT_IP_TYPES));
    }

    private String getHostIp(String instanceName, List<String> ipTypes) {
        CloudSqlInstance instance = this.getCloudSqlInstance(instanceName);
        return instance.getPreferredIp(ipTypes);
    }

    @VisibleForTesting
    Socket createSslSocket(String instanceName, List<String> ipTypes) throws IOException {
        CloudSqlInstance instance = this.getCloudSqlInstance(instanceName);
        try {
            SSLSocket socket = instance.createSslSocket();
            socket.setKeepAlive(true);
            socket.setTcpNoDelay(true);
            String instanceIp = instance.getPreferredIp(ipTypes);
            socket.connect(new InetSocketAddress(instanceIp, this.serverProxyPort));
            socket.startHandshake();
            return socket;
        }
        catch (Exception ex) {
            instance.forceRefresh();
            throw ex;
        }
    }

    private static void logTestPropertyWarning(String property) {
        logger.warning(String.format("%s is a test property and may be changed or removed in a future version without notice.", property));
    }

    private static List<String> listIpTypes(String cloudSqlIpTypes) {
        String[] rawTypes = cloudSqlIpTypes.split(",");
        ArrayList<String> result = new ArrayList<String>(rawTypes.length);
        for (int i = 0; i < rawTypes.length; ++i) {
            if (rawTypes[i].trim().equalsIgnoreCase("PUBLIC")) {
                result.add(i, "PRIMARY");
                continue;
            }
            result.add(i, rawTypes[i].trim().toUpperCase());
        }
        return result;
    }

    private static SQLAdmin createAdminApiClient(HttpRequestInitializer requestInitializer) {
        NetHttpTransport httpTransport;
        try {
            httpTransport = GoogleNetHttpTransport.newTrustedTransport();
        }
        catch (IOException | GeneralSecurityException err) {
            throw new RuntimeException("Unable to initialize HTTP transport", err);
        }
        String rootUrl = System.getProperty(API_ROOT_URL_PROPERTY);
        String servicePath = System.getProperty(API_SERVICE_PATH_PROPERTY);
        JacksonFactory jsonFactory = JacksonFactory.getDefaultInstance();
        SQLAdmin.Builder adminApiBuilder = new SQLAdmin.Builder((HttpTransport)httpTransport, (JsonFactory)jsonFactory, requestInitializer).setApplicationName(CoreSocketFactory.getUserAgents());
        if (rootUrl != null) {
            CoreSocketFactory.logTestPropertyWarning(API_ROOT_URL_PROPERTY);
            adminApiBuilder.setRootUrl(rootUrl);
        }
        if (servicePath != null) {
            CoreSocketFactory.logTestPropertyWarning(API_SERVICE_PATH_PROPERTY);
            adminApiBuilder.setServicePath(servicePath);
        }
        return adminApiBuilder.build();
    }

    private static KeyPair generateRsaKeyPair() {
        KeyPairGenerator generator;
        try {
            generator = KeyPairGenerator.getInstance("RSA");
        }
        catch (NoSuchAlgorithmException err) {
            throw new RuntimeException("Unable to initialize Cloud SQL socket factory because no RSA implementation is available.");
        }
        generator.initialize(2048);
        return generator.generateKeyPair();
    }

    private static String getVersion() {
        try {
            Properties packageInfo = new Properties();
            packageInfo.load(CoreSocketFactory.class.getClassLoader().getResourceAsStream("com.google.cloud.sql/project.properties"));
            return packageInfo.getProperty("version", "unknown");
        }
        catch (IOException e) {
            return "unknown";
        }
    }

    public static void addArtifactId(String artifactId) {
        String userAgent = artifactId + "/" + version;
        if (!userAgents.contains(userAgent)) {
            userAgents.add(userAgent);
        }
    }

    private static String getUserAgents() {
        return String.join((CharSequence)" ", userAgents) + " " + CoreSocketFactory.getApplicationName();
    }

    public static String getApplicationName() {
        if (coreSocketFactory != null) {
            return CoreSocketFactory.coreSocketFactory.adminApi.getApplicationName();
        }
        return System.getProperty(USER_TOKEN_PROPERTY_NAME, "");
    }

    public static void setApplicationName(String applicationName) {
        if (coreSocketFactory != null) {
            throw new IllegalStateException("Unable to set ApplicationName - SQLAdmin client already initialized.");
        }
        System.setProperty(USER_TOKEN_PROPERTY_NAME, applicationName);
    }

    static {
        userAgents = new ArrayList<String>();
        version = CoreSocketFactory.getVersion();
    }

    private static class ApplicationDefaultCredentialFactory
    implements CredentialFactory {
        private ApplicationDefaultCredentialFactory() {
        }

        @Override
        public HttpRequestInitializer create() {
            GoogleCredentials credentials;
            try {
                credentials = GoogleCredentials.getApplicationDefault();
            }
            catch (IOException err) {
                throw new RuntimeException("Unable to obtain credentials to communicate with the Cloud SQL API", err);
            }
            if (credentials.createScopedRequired()) {
                credentials = credentials.createScoped(Collections.singletonList("https://www.googleapis.com/auth/sqlservice.admin"));
            }
            return new HttpCredentialsAdapter((Credentials)credentials);
        }
    }
}

