/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.sql.core;

import com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import com.google.api.client.googleapis.services.CommonGoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.gson.GsonFactory;
import com.google.api.services.sqladmin.SQLAdmin;
import com.google.cloud.sql.ConnectorConfig;
import com.google.cloud.sql.core.ConnectionInfoRepositoryFactory;
import com.google.cloud.sql.core.DefaultConnectionInfoRepository;
import java.io.IOException;
import java.security.GeneralSecurityException;

public class DefaultConnectionInfoRepositoryFactory
implements ConnectionInfoRepositoryFactory {
    private final String userAgents;

    public DefaultConnectionInfoRepositoryFactory(String userAgents) {
        this.userAgents = userAgents;
    }

    @Override
    public DefaultConnectionInfoRepository create(HttpRequestInitializer requestInitializer, ConnectorConfig config) {
        SQLAdmin adminApiBuilder = this.getApiBuilder(requestInitializer, config);
        return new DefaultConnectionInfoRepository(adminApiBuilder);
    }

    private SQLAdmin getApiBuilder(HttpRequestInitializer requestInitializer, ConnectorConfig config) {
        NetHttpTransport httpTransport;
        try {
            httpTransport = GoogleNetHttpTransport.newTrustedTransport();
        }
        catch (IOException | GeneralSecurityException err) {
            throw new RuntimeException("Unable to initialize HTTP transport", err);
        }
        GsonFactory jsonFactory = GsonFactory.getDefaultInstance();
        SQLAdmin.Builder adminApiBuilder = new SQLAdmin.Builder((HttpTransport)httpTransport, (JsonFactory)jsonFactory, requestInitializer).setApplicationName(this.userAgents);
        if (config.getAdminRootUrl() != null) {
            adminApiBuilder.setRootUrl(config.getAdminRootUrl());
        }
        if (config.getAdminServicePath() != null) {
            adminApiBuilder.setServicePath(config.getAdminServicePath());
        }
        if (config.getAdminQuotaProject() != null) {
            CommonGoogleClientRequestInitializer clientRequestInitializer = CommonGoogleClientRequestInitializer.newBuilder().setUserProject(config.getAdminQuotaProject()).build();
            adminApiBuilder.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)clientRequestInitializer);
        }
        if (config.getUniverseDomain() != null) {
            adminApiBuilder.setUniverseDomain(config.getUniverseDomain());
        }
        return adminApiBuilder.build();
    }
}

