/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.sql.core;

import com.google.cloud.sql.core.CloudSqlInstanceName;
import com.google.cloud.sql.core.ConscryptWorkaroundDelegatingTrustManger;
import com.google.cloud.sql.core.InstanceCheckingTrustManger;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import javax.net.ssl.ManagerFactoryParameters;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.TrustManagerFactorySpi;
import javax.net.ssl.X509ExtendedTrustManager;

class InstanceCheckingTrustManagerFactorySpi
extends TrustManagerFactorySpi {
    private final TrustManagerFactory delegate;
    private final CloudSqlInstanceName instanceName;

    InstanceCheckingTrustManagerFactorySpi(CloudSqlInstanceName instanceName, TrustManagerFactory delegate) {
        this.instanceName = instanceName;
        this.delegate = delegate;
    }

    @Override
    protected void engineInit(KeyStore ks) throws KeyStoreException {
        this.delegate.init(ks);
    }

    @Override
    protected void engineInit(ManagerFactoryParameters spec) throws InvalidAlgorithmParameterException {
        this.delegate.init(spec);
    }

    @Override
    protected TrustManager[] engineGetTrustManagers() {
        TrustManager[] tms = this.delegate.getTrustManagers();
        TrustManager[] delegates = new TrustManager[tms.length];
        for (int i = 0; i < tms.length; ++i) {
            if (tms[i] instanceof X509ExtendedTrustManager) {
                X509ExtendedTrustManager tm = (X509ExtendedTrustManager)tms[i];
                if (ConscryptWorkaroundDelegatingTrustManger.isWorkaroundNeeded()) {
                    tm = new ConscryptWorkaroundDelegatingTrustManger(tm);
                }
                delegates[i] = new InstanceCheckingTrustManger(this.instanceName, tm);
                continue;
            }
            delegates[i] = tms[i];
        }
        return delegates;
    }
}

