/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.sql.core;

import com.google.cloud.sql.IpType;
import com.google.cloud.sql.core.CloudSqlInstanceName;
import com.google.cloud.sql.core.ConnectionConfig;
import com.google.cloud.sql.core.ConnectionMetadata;
import com.google.cloud.sql.core.InstanceMetadata;
import com.google.cloud.sql.core.SslData;
import java.time.Instant;
import java.util.Map;
import java.util.stream.Collectors;
import javax.net.ssl.SSLContext;

class ConnectionInfo {
    private final InstanceMetadata instanceMetadata;
    private final SSLContext sslContext;
    private final SslData sslData;
    private final Instant expiration;

    ConnectionInfo(InstanceMetadata instanceMetadata, SslData sslData, Instant expiration) {
        this.instanceMetadata = instanceMetadata;
        this.sslData = sslData;
        this.sslContext = sslData.getSslContext();
        this.expiration = expiration;
    }

    public Instant getExpiration() {
        return this.expiration;
    }

    SSLContext getSslContext() {
        return this.sslContext;
    }

    Map<IpType, String> getIpAddrs() {
        return this.instanceMetadata.getIpAddrs();
    }

    SslData getSslData() {
        return this.sslData;
    }

    ConnectionMetadata toConnectionMetadata(ConnectionConfig config, CloudSqlInstanceName instanceName) {
        String preferredIp = null;
        for (IpType ipType : config.getIpTypes()) {
            preferredIp = this.getIpAddrs().get((Object)ipType);
            if (preferredIp == null) continue;
            break;
        }
        if (preferredIp == null) {
            throw new IllegalArgumentException(String.format("[%s] Cloud SQL instance  does not have any IP addresses matching preferences (%s)", instanceName.getConnectionName(), config.getIpTypes().stream().map(Enum::toString).collect(Collectors.joining(","))));
        }
        return new ConnectionMetadata(preferredIp, this.sslData.getKeyManagerFactory(), this.sslData.getTrustManagerFactory(), this.sslData.getSslContext());
    }
}

