/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.sql.core;

import com.google.cloud.sql.core.CloudSqlInstanceName;
import com.google.cloud.sql.core.InstanceCheckingTrustManagerFactorySpi;
import com.google.cloud.sql.core.InstanceMetadata;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import javax.net.ssl.TrustManagerFactory;

class InstanceCheckingTrustManagerFactory
extends TrustManagerFactory {
    static InstanceCheckingTrustManagerFactory newInstance(CloudSqlInstanceName instanceName, InstanceMetadata instanceMetadata) throws NoSuchAlgorithmException, KeyStoreException, CertificateException, IOException {
        TrustManagerFactory delegate = TrustManagerFactory.getInstance("X.509");
        KeyStore trustedKeyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        trustedKeyStore.load(null, null);
        trustedKeyStore.setCertificateEntry("instance", instanceMetadata.getInstanceCaCertificate());
        InstanceCheckingTrustManagerFactory tmf = new InstanceCheckingTrustManagerFactory(instanceName, delegate);
        tmf.init(trustedKeyStore);
        return tmf;
    }

    private InstanceCheckingTrustManagerFactory(CloudSqlInstanceName instanceName, TrustManagerFactory delegate) {
        super(new InstanceCheckingTrustManagerFactorySpi(instanceName, delegate), delegate.getProvider(), delegate.getAlgorithm());
    }
}

