/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.sql.core;

import com.google.common.base.Preconditions;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class CloudSqlInstanceName {
    private static final Pattern CONNECTION_NAME = Pattern.compile("([^:]+(:[^:]+)?):([^:]+):([^:]+)");
    private final String projectId;
    private final String regionId;
    private final String instanceId;
    private final String connectionName;

    CloudSqlInstanceName(String connectionName) {
        this.connectionName = connectionName;
        Matcher matcher = CONNECTION_NAME.matcher(connectionName);
        Preconditions.checkArgument((boolean)matcher.matches(), (Object)String.format("[%s] Cloud SQL connection name is invalid, expected string in the form of \"<PROJECT_ID>:<REGION_ID>:<INSTANCE_ID>\".", connectionName));
        this.projectId = matcher.group(1);
        this.regionId = matcher.group(3);
        this.instanceId = matcher.group(4);
    }

    String getConnectionName() {
        return this.connectionName;
    }

    String getProjectId() {
        return this.projectId;
    }

    String getRegionId() {
        return this.regionId;
    }

    String getInstanceId() {
        return this.instanceId;
    }

    public String toString() {
        return this.connectionName;
    }
}

