/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.sql.core;

import com.google.cloud.sql.ConnectorConfig;
import com.google.cloud.sql.CredentialFactory;
import com.google.cloud.sql.RefreshStrategy;
import com.google.cloud.sql.core.ConnectionConfig;
import com.google.cloud.sql.core.ConnectionInfoCache;
import com.google.cloud.sql.core.ConnectionInfoRepository;
import com.google.cloud.sql.core.ConnectionInfoRepositoryFactory;
import com.google.cloud.sql.core.ConnectionMetadata;
import com.google.cloud.sql.core.LazyRefreshConnectionInfoCache;
import com.google.cloud.sql.core.RefreshAheadConnectionInfoCache;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.security.KeyPair;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import javax.net.ssl.SSLSocket;
import jnr.unixsocket.UnixSocketAddress;
import jnr.unixsocket.UnixSocketChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Connector {
    private static final Logger logger = LoggerFactory.getLogger(Connector.class);
    private final ConnectionInfoRepository adminApi;
    private final CredentialFactory instanceCredentialFactory;
    private final ListeningScheduledExecutorService executor;
    private final ListenableFuture<KeyPair> localKeyPair;
    private final long minRefreshDelayMs;
    private final ConcurrentHashMap<ConnectionConfig, ConnectionInfoCache> instances = new ConcurrentHashMap();
    private final int serverProxyPort;
    private final ConnectorConfig config;

    Connector(ConnectorConfig config, ConnectionInfoRepositoryFactory connectionInfoRepositoryFactory, CredentialFactory instanceCredentialFactory, ListeningScheduledExecutorService executor, ListenableFuture<KeyPair> localKeyPair, long minRefreshDelayMs, long refreshTimeoutMs, int serverProxyPort) {
        this.config = config;
        this.adminApi = connectionInfoRepositoryFactory.create(instanceCredentialFactory.create(), config);
        this.instanceCredentialFactory = instanceCredentialFactory;
        this.executor = executor;
        this.localKeyPair = localKeyPair;
        this.minRefreshDelayMs = minRefreshDelayMs;
        this.serverProxyPort = serverProxyPort;
    }

    public ConnectorConfig getConfig() {
        return this.config;
    }

    private String getUnixSocketArg(ConnectionConfig config) {
        String unixSocketPath = config.getUnixSocketPath();
        if (unixSocketPath != null) {
            return unixSocketPath;
        }
        if (System.getenv("CLOUD_SQL_FORCE_UNIX_SOCKET") != null) {
            logger.debug(String.format("\"CLOUD_SQL_FORCE_UNIX_SOCKET\" env var has been deprecated. Please use '%s=\"/cloudsql/INSTANCE_CONNECTION_NAME\"' property in your JDBC url instead.", "unixSocketPath"));
            return "/cloudsql/" + config.getCloudSqlInstance();
        }
        return null;
    }

    Socket connect(ConnectionConfig config, long timeoutMs) throws IOException {
        String unixSocket = this.getUnixSocketArg(config);
        String unixPathSuffix = config.getUnixSocketPathSuffix();
        if (unixSocket != null) {
            if (unixPathSuffix != null && !unixSocket.endsWith(unixPathSuffix)) {
                unixSocket = unixSocket + unixPathSuffix;
            }
            logger.debug(String.format("Connecting to Cloud SQL instance [%s] via unix socket at %s.", config.getCloudSqlInstance(), unixSocket));
            UnixSocketAddress socketAddress = new UnixSocketAddress(new File(unixSocket));
            return UnixSocketChannel.open((UnixSocketAddress)socketAddress).socket();
        }
        ConnectionInfoCache instance = this.getConnection(config);
        try {
            ConnectionMetadata metadata = instance.getConnectionMetadata(timeoutMs);
            String instanceIp = metadata.getPreferredIpAddress();
            logger.debug(String.format("[%s] Connecting to instance.", instanceIp));
            SSLSocket socket = (SSLSocket)metadata.getSslContext().getSocketFactory().createSocket();
            socket.setKeepAlive(true);
            socket.setTcpNoDelay(true);
            socket.connect(new InetSocketAddress(instanceIp, this.serverProxyPort));
            try {
                socket.startHandshake();
            }
            catch (IOException e) {
                logger.debug("TLS handshake failed!");
                throw e;
            }
            logger.debug(String.format("[%s] Connected to instance successfully.", instanceIp));
            return socket;
        }
        catch (IOException e) {
            logger.debug(String.format("[%s] Socket connection failed! Trigger a refresh.", config.getCloudSqlInstance()));
            instance.forceRefresh();
            throw e;
        }
    }

    ConnectionInfoCache getConnection(ConnectionConfig config) {
        ConnectionInfoCache instance = this.instances.computeIfAbsent(config, k -> this.createConnectionInfo(config));
        instance.refreshIfExpired();
        return instance;
    }

    private ConnectionInfoCache createConnectionInfo(ConnectionConfig config) {
        logger.debug(String.format("[%s] Connection info added to cache.", config.getCloudSqlInstance()));
        if (config.getConnectorConfig().getRefreshStrategy() == RefreshStrategy.LAZY) {
            KeyPair keyPair = null;
            try {
                keyPair = (KeyPair)this.localKeyPair.get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
            return new LazyRefreshConnectionInfoCache(config, this.adminApi, this.instanceCredentialFactory, keyPair);
        }
        return new RefreshAheadConnectionInfoCache(config, this.adminApi, this.instanceCredentialFactory, this.executor, this.localKeyPair, this.minRefreshDelayMs);
    }

    public void close() {
        logger.debug("Close all connections and remove them from cache.");
        this.instances.forEach((key, c) -> c.close());
        this.instances.clear();
    }
}

