/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.sql.core;

import com.google.cloud.sql.core.InstanceCheckingTrustManagerFactorySpi;
import com.google.cloud.sql.core.InstanceMetadata;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import javax.net.ssl.TrustManagerFactory;

class InstanceCheckingTrustManagerFactory
extends TrustManagerFactory {
    static TrustManagerFactory newInstance(InstanceMetadata instanceMetadata) throws NoSuchAlgorithmException, KeyStoreException, CertificateException, IOException {
        TrustManagerFactory delegate = TrustManagerFactory.getInstance("X.509");
        KeyStore trustedKeyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        trustedKeyStore.load(null, null);
        for (Certificate cert : instanceMetadata.getInstanceCaCertificates()) {
            trustedKeyStore.setCertificateEntry("ca" + cert.hashCode(), cert);
        }
        InstanceCheckingTrustManagerFactory tmf = new InstanceCheckingTrustManagerFactory(instanceMetadata, delegate);
        tmf.init(trustedKeyStore);
        return tmf;
    }

    private InstanceCheckingTrustManagerFactory(InstanceMetadata instanceMetadata, TrustManagerFactory delegate) {
        super(new InstanceCheckingTrustManagerFactorySpi(instanceMetadata, delegate), delegate.getProvider(), delegate.getAlgorithm());
    }
}

