/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.sql.core;

import com.google.cloud.sql.core.InstanceMetadata;
import java.net.Socket;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedTrustManager;

class InstanceCheckingTrustManger
extends X509ExtendedTrustManager {
    private final X509ExtendedTrustManager tm;
    private final InstanceMetadata instanceMetadata;

    public InstanceCheckingTrustManger(InstanceMetadata instanceMetadata, X509ExtendedTrustManager tm) {
        this.instanceMetadata = instanceMetadata;
        this.tm = tm;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        this.tm.checkClientTrusted(chain, authType, socket);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
        this.tm.checkClientTrusted(chain, authType, engine);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.tm.checkClientTrusted(chain, authType);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        this.tm.checkServerTrusted(chain, authType, socket);
        this.checkCertificateChain(chain);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
        this.tm.checkServerTrusted(chain, authType, engine);
        this.checkCertificateChain(chain);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.tm.checkServerTrusted(chain, authType);
        this.checkCertificateChain(chain);
    }

    private void checkCertificateChain(X509Certificate[] chain) throws CertificateException {
        if (chain.length == 0) {
            throw new CertificateException("No server certificates in chain");
        }
        if (chain[0].getSubjectX500Principal() == null) {
            throw new CertificateException("Subject is missing");
        }
        if (this.instanceMetadata.isCasManagedCertificate() || this.instanceMetadata.isPscEnabled()) {
            this.checkSan(chain);
        } else {
            this.checkCn(chain);
        }
    }

    private void checkSan(X509Certificate[] chain) throws CertificateException {
        List<String> sans = this.getSans(chain[0]);
        String dns = this.instanceMetadata.getDnsName();
        if (dns == null || dns.isEmpty()) {
            throw new CertificateException("Instance metadata for " + this.instanceMetadata.getInstanceName() + " has an empty dnsName");
        }
        for (String san : sans) {
            if (!san.equalsIgnoreCase(dns)) continue;
            return;
        }
        throw new CertificateException("Server certificate does not contain expected name '" + this.instanceMetadata.getDnsName() + "' for Cloud SQL instance " + this.instanceMetadata.getInstanceName());
    }

    private List<String> getSans(X509Certificate cert) throws CertificateException {
        ArrayList<String> names = new ArrayList<String>();
        Collection<List<?>> sanAsn1Field = cert.getSubjectAlternativeNames();
        if (sanAsn1Field == null) {
            return names;
        }
        for (List<?> item : sanAsn1Field) {
            Integer type = (Integer)item.get(0);
            if (type != 0 && type != 2) continue;
            Object value = item.get(1);
            if (value instanceof byte[]) {
                throw new UnsupportedOperationException("Server certificate SAN field cannot be decoded.");
            }
            if (!(value instanceof String)) continue;
            names.add((String)value);
        }
        return names;
    }

    private void checkCn(X509Certificate[] chain) throws CertificateException {
        String cn = null;
        try {
            String subject = chain[0].getSubjectX500Principal().getName();
            LdapName subjectName = new LdapName(subject);
            for (Rdn rdn : subjectName.getRdns()) {
                if (!"CN".equals(rdn.getType())) continue;
                cn = (String)rdn.getValue();
            }
        }
        catch (InvalidNameException e) {
            throw new CertificateException("Exception parsing the server certificate subject field", e);
        }
        if (cn == null) {
            throw new CertificateException("Server certificate subject does not contain a value for CN");
        }
        String instName = this.instanceMetadata.getInstanceName().getProjectId() + ":" + this.instanceMetadata.getInstanceName().getInstanceId();
        if (!instName.equals(cn)) {
            throw new CertificateException("Server certificate CN does not match instance name. Server certificate CN=" + cn + " Expected instance name: " + instName);
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.tm.getAcceptedIssuers();
    }
}

