/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.sql.core;

import com.google.cloud.sql.core.DnsResolver;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.InitialDirContext;

class JndiDnsResolver
implements DnsResolver {
    private final String jndiPrefix;

    JndiDnsResolver() {
        this.jndiPrefix = "dns:";
    }

    JndiDnsResolver(String dnsServer, int port) {
        this.jndiPrefix = "dns://" + dnsServer + ":" + port + "/";
    }

    @Override
    public Collection<String> resolveTxt(String domainName) throws NameNotFoundException {
        try {
            Attribute attr = new InitialDirContext().getAttributes(this.jndiPrefix + domainName, new String[]{"TXT"}).get("TXT");
            return Collections.list(attr.getAll()).stream().map(v -> (String)v).sorted().collect(Collectors.toList());
        }
        catch (NameNotFoundException e) {
            throw e;
        }
        catch (NamingException e) {
            throw new RuntimeException("Unable to look up domain name " + domainName, e);
        }
    }
}

