/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.sql;

import com.google.auth.oauth2.GoogleCredentials;
import com.google.cloud.sql.RefreshStrategy;
import com.google.common.base.Objects;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class ConnectorConfig {
    private final String targetPrincipal;
    private final List<String> delegates;
    private final String adminRootUrl;
    private final String adminServicePath;
    private final Supplier<GoogleCredentials> googleCredentialsSupplier;
    private final Function<String, String> instanceNameResolver;
    private final GoogleCredentials googleCredentials;
    private final String googleCredentialsPath;
    private final String adminQuotaProject;
    private final String universeDomain;
    private final RefreshStrategy refreshStrategy;

    private ConnectorConfig(String targetPrincipal, List<String> delegates, String adminRootUrl, String adminServicePath, Supplier<GoogleCredentials> googleCredentialsSupplier, GoogleCredentials googleCredentials, String googleCredentialsPath, String adminQuotaProject, String universeDomain, RefreshStrategy refreshStrategy, Function<String, String> instanceNameResolver) {
        this.targetPrincipal = targetPrincipal;
        this.delegates = delegates;
        this.adminRootUrl = adminRootUrl;
        this.adminServicePath = adminServicePath;
        this.googleCredentialsSupplier = googleCredentialsSupplier;
        this.googleCredentials = googleCredentials;
        this.googleCredentialsPath = googleCredentialsPath;
        this.adminQuotaProject = adminQuotaProject;
        this.universeDomain = universeDomain;
        this.refreshStrategy = refreshStrategy;
        this.instanceNameResolver = instanceNameResolver;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ConnectorConfig)) {
            return false;
        }
        ConnectorConfig that = (ConnectorConfig)o;
        return Objects.equal((Object)this.targetPrincipal, (Object)that.targetPrincipal) && Objects.equal(this.delegates, that.delegates) && Objects.equal((Object)this.adminRootUrl, (Object)that.adminRootUrl) && Objects.equal((Object)this.adminServicePath, (Object)that.adminServicePath) && Objects.equal(this.googleCredentialsSupplier, that.googleCredentialsSupplier) && Objects.equal((Object)this.googleCredentials, (Object)that.googleCredentials) && Objects.equal((Object)this.googleCredentialsPath, (Object)that.googleCredentialsPath) && Objects.equal((Object)this.adminQuotaProject, (Object)that.adminQuotaProject) && Objects.equal((Object)this.universeDomain, (Object)that.universeDomain) && Objects.equal((Object)((Object)this.refreshStrategy), (Object)((Object)that.refreshStrategy)) && Objects.equal(this.instanceNameResolver, that.instanceNameResolver);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.targetPrincipal, this.delegates, this.adminRootUrl, this.adminServicePath, this.googleCredentialsSupplier, this.googleCredentials, this.googleCredentialsPath, this.adminQuotaProject, this.universeDomain, this.refreshStrategy, this.instanceNameResolver});
    }

    public String getTargetPrincipal() {
        return this.targetPrincipal;
    }

    public List<String> getDelegates() {
        return this.delegates;
    }

    public String getAdminRootUrl() {
        return this.adminRootUrl;
    }

    public String getAdminServicePath() {
        return this.adminServicePath;
    }

    public Supplier<GoogleCredentials> getGoogleCredentialsSupplier() {
        return this.googleCredentialsSupplier;
    }

    public GoogleCredentials getGoogleCredentials() {
        return this.googleCredentials;
    }

    public String getGoogleCredentialsPath() {
        return this.googleCredentialsPath;
    }

    public String getAdminQuotaProject() {
        return this.adminQuotaProject;
    }

    public String getUniverseDomain() {
        return this.universeDomain;
    }

    public RefreshStrategy getRefreshStrategy() {
        return this.refreshStrategy;
    }

    public Function<String, String> getInstanceNameResolver() {
        return this.instanceNameResolver;
    }

    public static class Builder {
        private String targetPrincipal;
        private List<String> delegates;
        private String adminRootUrl;
        private String adminServicePath;
        private Supplier<GoogleCredentials> googleCredentialsSupplier;
        private GoogleCredentials googleCredentials;
        private String googleCredentialsPath;
        private String adminQuotaProject;
        private String universeDomain;
        private RefreshStrategy refreshStrategy = RefreshStrategy.BACKGROUND;
        private Function<String, String> instanceNameResolver;

        public Builder withTargetPrincipal(String targetPrincipal) {
            this.targetPrincipal = targetPrincipal;
            return this;
        }

        public Builder withGoogleCredentialsSupplier(Supplier<GoogleCredentials> googleCredentialsSupplier) {
            this.googleCredentialsSupplier = googleCredentialsSupplier;
            return this;
        }

        public Builder withGoogleCredentials(GoogleCredentials googleCredentials) {
            this.googleCredentials = googleCredentials;
            return this;
        }

        public Builder withGoogleCredentialsPath(String googleCredentialsPath) {
            this.googleCredentialsPath = googleCredentialsPath;
            return this;
        }

        public Builder withDelegates(List<String> delegates) {
            this.delegates = delegates;
            return this;
        }

        public Builder withAdminRootUrl(String adminRootUrl) {
            this.adminRootUrl = adminRootUrl;
            return this;
        }

        public Builder withAdminServicePath(String adminServicePath) {
            this.adminServicePath = adminServicePath;
            return this;
        }

        public Builder withAdminQuotaProject(String adminQuotaProject) {
            this.adminQuotaProject = adminQuotaProject;
            return this;
        }

        public Builder withUniverseDomain(String universeDomain) {
            this.universeDomain = universeDomain;
            return this;
        }

        public Builder withRefreshStrategy(RefreshStrategy refreshStrategy) {
            this.refreshStrategy = refreshStrategy;
            return this;
        }

        public Builder withInstanceNameResolver(Function<String, String> instanceNameResolver) {
            this.instanceNameResolver = instanceNameResolver;
            return this;
        }

        public ConnectorConfig build() {
            int googleCredsCount = 0;
            if (this.googleCredentials != null) {
                ++googleCredsCount;
            }
            if (this.googleCredentialsPath != null) {
                ++googleCredsCount;
            }
            if (this.googleCredentialsSupplier != null) {
                ++googleCredsCount;
            }
            if (googleCredsCount > 1) {
                throw new IllegalStateException("Invalid configuration, more than one GoogleCredentials field has a value (googleCredentials, googleCredentialsPath, googleCredentialsSupplier)");
            }
            if (this.adminRootUrl != null && this.universeDomain != null) {
                throw new IllegalStateException("Can not set Admin API Endpoint and Universe Domain together, set only Admin API Endpoint (it already contains the universe domain)");
            }
            return new ConnectorConfig(this.targetPrincipal, this.delegates, this.adminRootUrl, this.adminServicePath, this.googleCredentialsSupplier, this.googleCredentials, this.googleCredentialsPath, this.adminQuotaProject, this.universeDomain, this.refreshStrategy, this.instanceNameResolver);
        }
    }
}

