/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.sql.core;

import com.google.common.base.Preconditions;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CloudSqlInstanceName {
    private static final Pattern CONNECTION_NAME = Pattern.compile("([^:]+(:[^:]+)?):([^:]+):([^:]+)");
    private static final Pattern DOMAIN_NAME = Pattern.compile("^(?=.{1,255}$)(?!-)[A-Za-z0-9-]+(\\.[A-Za-z0-9-]+)*\\.[A-Za-z]{2,}$");
    private final String projectId;
    private final String regionId;
    private final String instanceId;
    private final String connectionName;
    private final String domainName;

    public static boolean isValidDomain(String domain) {
        Matcher matcher = DOMAIN_NAME.matcher(domain);
        return matcher.matches();
    }

    public static boolean isValidInstanceName(String connectionName) {
        Matcher matcher = CONNECTION_NAME.matcher(connectionName);
        return matcher.matches();
    }

    CloudSqlInstanceName(String connectionName) {
        this(connectionName, null);
    }

    CloudSqlInstanceName(String connectionName, String domainName) {
        Matcher matcher = CONNECTION_NAME.matcher(connectionName);
        Preconditions.checkArgument((boolean)matcher.matches(), (Object)String.format("[%s] Cloud SQL connection name is invalid, expected string in the form of \"<PROJECT_ID>:<REGION_ID>:<INSTANCE_ID>\".", connectionName));
        this.connectionName = connectionName;
        this.projectId = matcher.group(1);
        this.regionId = matcher.group(3);
        this.instanceId = matcher.group(4);
        if (domainName != null && !domainName.isEmpty()) {
            Matcher domainMatcher = DOMAIN_NAME.matcher(domainName);
            Preconditions.checkArgument((boolean)domainMatcher.matches(), (Object)String.format("[%s] Domain name is invalid, expected a valid domain name", domainName));
            this.domainName = domainName;
        } else {
            this.domainName = null;
        }
    }

    String getConnectionName() {
        return this.connectionName;
    }

    String getProjectId() {
        return this.projectId;
    }

    String getRegionId() {
        return this.regionId;
    }

    String getInstanceId() {
        return this.instanceId;
    }

    String getDomainName() {
        return this.domainName;
    }

    public String toString() {
        return this.connectionName;
    }
}

