/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.sql.core;

import com.google.cloud.sql.AuthType;
import com.google.cloud.sql.ConnectorConfig;
import com.google.cloud.sql.IpType;
import com.google.cloud.sql.RefreshStrategy;
import com.google.common.base.Splitter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Properties;

public class ConnectionConfig {
    public static final String CLOUD_SQL_INSTANCE_PROPERTY = "cloudSqlInstance";
    public static final String CLOUD_SQL_NAMED_CONNECTOR_PROPERTY = "cloudSqlNamedConnector";
    public static final String CLOUD_SQL_DELEGATES_PROPERTY = "cloudSqlDelegates";
    public static final String CLOUD_SQL_TARGET_PRINCIPAL_PROPERTY = "cloudSqlTargetPrincipal";
    public static final String CLOUD_SQL_ADMIN_ROOT_URL_PROPERTY = "cloudSqlAdminRootUrl";
    public static final String CLOUD_SQL_ADMIN_SERVICE_PATH_PROPERTY = "cloudSqlAdminServicePath";
    public static final String CLOUD_SQL_REFRESH_STRATEGY_PROPERTY = "cloudSqlRefreshStrategy";
    public static final String UNIX_SOCKET_PROPERTY = "unixSocketPath";
    public static final String UNIX_SOCKET_PATH_SUFFIX_PROPERTY = "cloudSqlUnixSocketPathSuffix";
    public static final String ENABLE_IAM_AUTH_PROPERTY = "enableIamAuth";
    public static final String IP_TYPES_PROPERTY = "ipTypes";
    public static final String CLOUD_SQL_ADMIN_QUOTA_PROJECT_PROPERTY = "cloudSqlAdminQuotaProject";
    public static final String CLOUD_SQL_UNIVERSE_DOMAIN = "cloudSqlUniverseDomain";
    public static final AuthType DEFAULT_AUTH_TYPE = AuthType.PASSWORD;
    public static final String DEFAULT_IP_TYPES = "PUBLIC,PRIVATE";
    public static final List<IpType> DEFAULT_IP_TYPE_LIST = Arrays.asList(IpType.PUBLIC, IpType.PRIVATE);
    public static final String CLOUD_SQL_GOOGLE_CREDENTIALS_PATH = "cloudSqlGoogleCredentialsPath";
    private final ConnectorConfig connectorConfig;
    private final String cloudSqlInstance;
    private final String namedConnector;
    private final String unixSocketPath;
    private final List<IpType> ipTypes;
    private final AuthType authType;
    private final String unixSocketPathSuffix;
    private final String domainName;

    public static ConnectionConfig fromConnectionProperties(Properties props) {
        return ConnectionConfig.fromConnectionProperties(props, null);
    }

    public static ConnectionConfig fromConnectionProperties(Properties props, String domainName) {
        String csqlInstanceName = props.getProperty(CLOUD_SQL_INSTANCE_PROPERTY);
        String namedConnection = props.getProperty(CLOUD_SQL_NAMED_CONNECTOR_PROPERTY);
        String unixSocketPath = props.getProperty(UNIX_SOCKET_PROPERTY);
        AuthType authType = Boolean.parseBoolean(props.getProperty(ENABLE_IAM_AUTH_PROPERTY)) ? AuthType.IAM : AuthType.PASSWORD;
        String targetPrincipal = props.getProperty(CLOUD_SQL_TARGET_PRINCIPAL_PROPERTY);
        String delegatesStr = props.getProperty(CLOUD_SQL_DELEGATES_PROPERTY);
        List<String> delegates = delegatesStr != null && !delegatesStr.isEmpty() ? Arrays.asList(delegatesStr.split(",")) : Collections.emptyList();
        List<IpType> ipTypes = ConnectionConfig.listIpTypes(props.getProperty(IP_TYPES_PROPERTY, DEFAULT_IP_TYPES));
        String adminRootUrl = props.getProperty(CLOUD_SQL_ADMIN_ROOT_URL_PROPERTY);
        String adminServicePath = props.getProperty(CLOUD_SQL_ADMIN_SERVICE_PATH_PROPERTY);
        String unixSocketPathSuffix = props.getProperty(UNIX_SOCKET_PATH_SUFFIX_PROPERTY);
        String googleCredentialsPath = props.getProperty(CLOUD_SQL_GOOGLE_CREDENTIALS_PATH);
        String adminQuotaProject = props.getProperty(CLOUD_SQL_ADMIN_QUOTA_PROJECT_PROPERTY);
        String universeDomain = props.getProperty(CLOUD_SQL_UNIVERSE_DOMAIN);
        String refreshStrategyStr = props.getProperty(CLOUD_SQL_REFRESH_STRATEGY_PROPERTY);
        RefreshStrategy refreshStrategy = "lazy".equalsIgnoreCase(refreshStrategyStr) ? RefreshStrategy.LAZY : RefreshStrategy.BACKGROUND;
        return new ConnectionConfig(csqlInstanceName, namedConnection, unixSocketPath, ipTypes, authType, unixSocketPathSuffix, domainName, new ConnectorConfig.Builder().withTargetPrincipal(targetPrincipal).withDelegates(delegates).withAdminRootUrl(adminRootUrl).withAdminServicePath(adminServicePath).withGoogleCredentialsPath(googleCredentialsPath).withAdminQuotaProject(adminQuotaProject).withUniverseDomain(universeDomain).withRefreshStrategy(refreshStrategy).build());
    }

    private static List<IpType> listIpTypes(String cloudSqlIpTypes) {
        List rawTypes = Splitter.on((char)',').splitToList((CharSequence)cloudSqlIpTypes);
        ArrayList<IpType> result = new ArrayList<IpType>(rawTypes.size());
        for (String type : rawTypes) {
            if (type.trim().equalsIgnoreCase("PUBLIC")) {
                result.add(IpType.PUBLIC);
                continue;
            }
            if (type.trim().equalsIgnoreCase("PRIMARY")) {
                result.add(IpType.PUBLIC);
                continue;
            }
            if (type.trim().equalsIgnoreCase("PRIVATE")) {
                result.add(IpType.PRIVATE);
                continue;
            }
            if (type.trim().equalsIgnoreCase("PSC")) {
                result.add(IpType.PSC);
                continue;
            }
            throw new IllegalArgumentException("Unsupported IP type: " + type + " found in ipTypes parameter");
        }
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ConnectionConfig)) {
            return false;
        }
        ConnectionConfig config = (ConnectionConfig)o;
        return Objects.equals(this.cloudSqlInstance, config.cloudSqlInstance) && Objects.equals(this.namedConnector, config.namedConnector) && Objects.equals(this.unixSocketPath, config.unixSocketPath) && Objects.equals(this.ipTypes, config.ipTypes) && Objects.equals((Object)this.authType, (Object)config.authType) && Objects.equals(this.domainName, config.domainName) && Objects.equals(this.connectorConfig, config.connectorConfig);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.cloudSqlInstance, this.namedConnector, this.unixSocketPath, this.ipTypes, this.authType, this.domainName, this.connectorConfig});
    }

    private ConnectionConfig(String cloudSqlInstance, String namedConnector, String unixSocketPath, List<IpType> ipTypes, AuthType authType, String unixSocketPathSuffix, String domainName, ConnectorConfig connectorConfig) {
        this.cloudSqlInstance = cloudSqlInstance;
        this.namedConnector = namedConnector;
        this.unixSocketPath = unixSocketPath;
        this.ipTypes = ipTypes;
        this.unixSocketPathSuffix = unixSocketPathSuffix;
        this.connectorConfig = connectorConfig;
        this.authType = authType;
        this.domainName = domainName;
    }

    public ConnectionConfig withConnectorConfig(ConnectorConfig config) {
        return new ConnectionConfig(this.cloudSqlInstance, this.namedConnector, this.unixSocketPath, this.ipTypes, this.authType, this.unixSocketPathSuffix, this.domainName, config);
    }

    public ConnectionConfig withCloudSqlInstance(String newCloudSqlInstance) {
        return new ConnectionConfig(newCloudSqlInstance, this.namedConnector, this.unixSocketPath, this.ipTypes, this.authType, this.unixSocketPathSuffix, this.domainName, this.connectorConfig);
    }

    public ConnectionConfig withDomainName(String domainName) {
        return new ConnectionConfig(this.cloudSqlInstance, this.namedConnector, this.unixSocketPath, this.ipTypes, this.authType, this.unixSocketPathSuffix, domainName, this.connectorConfig);
    }

    public String getNamedConnector() {
        return this.namedConnector;
    }

    public String getCloudSqlInstance() {
        return this.cloudSqlInstance;
    }

    public String getUnixSocketPath() {
        return this.unixSocketPath;
    }

    public List<IpType> getIpTypes() {
        return this.ipTypes;
    }

    public String getUnixSocketPathSuffix() {
        return this.unixSocketPathSuffix;
    }

    public ConnectorConfig getConnectorConfig() {
        return this.connectorConfig;
    }

    public AuthType getAuthType() {
        return this.authType;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public static class Builder {
        private String cloudSqlInstance;
        private String namedConnector;
        private String unixSocketPath;
        private List<IpType> ipTypes = DEFAULT_IP_TYPE_LIST;
        private String unixSocketPathSuffix;
        private ConnectorConfig connectorConfig = new ConnectorConfig.Builder().build();
        private AuthType authType = DEFAULT_AUTH_TYPE;
        private String domainName;

        public Builder withCloudSqlInstance(String cloudSqlInstance) {
            this.cloudSqlInstance = cloudSqlInstance;
            return this;
        }

        public Builder withNamedConnector(String namedConnector) {
            this.namedConnector = namedConnector;
            return this;
        }

        public Builder withConnectorConfig(ConnectorConfig connectorConfig) {
            this.connectorConfig = connectorConfig;
            return this;
        }

        public Builder withUnixSocketPath(String unixSocketPath) {
            this.unixSocketPath = unixSocketPath;
            return this;
        }

        public Builder withAuthType(AuthType authType) {
            this.authType = authType;
            return this;
        }

        public Builder withIpTypes(String ipTypes) {
            this.ipTypes = ConnectionConfig.listIpTypes(ipTypes);
            return this;
        }

        public Builder withIpTypes(List<IpType> ipTypes) {
            this.ipTypes = ipTypes;
            return this;
        }

        public Builder withDomainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public Builder withUnixSocketPathSuffix(String unixSocketPathSuffix) {
            this.unixSocketPathSuffix = unixSocketPathSuffix;
            return this;
        }

        public ConnectionConfig build() {
            return new ConnectionConfig(this.cloudSqlInstance, this.namedConnector, this.unixSocketPath, this.ipTypes, this.authType, this.unixSocketPathSuffix, this.domainName, this.connectorConfig);
        }
    }
}

