/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.sql.core;

import com.google.cloud.sql.ConnectorConfig;
import com.google.cloud.sql.CredentialFactory;
import com.google.cloud.sql.core.ConnectionConfig;
import com.google.cloud.sql.core.ConnectionInfoRepositoryFactory;
import com.google.cloud.sql.core.ConnectionMetadata;
import com.google.cloud.sql.core.Connector;
import com.google.cloud.sql.core.CredentialFactoryProvider;
import com.google.cloud.sql.core.DefaultConnectionInfoRepositoryFactory;
import com.google.cloud.sql.core.DnsInstanceConnectionNameResolver;
import com.google.cloud.sql.core.JndiDnsResolver;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.net.Socket;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InternalConnectorRegistry {
    static final long DEFAULT_CONNECT_TIMEOUT_MS = 45000L;
    private static final Logger logger = LoggerFactory.getLogger(InternalConnectorRegistry.class);
    static final int DEFAULT_SERVER_PROXY_PORT = 3307;
    private static final int RSA_KEY_SIZE = 2048;
    private static final List<String> userAgents = new ArrayList<String>();
    private static final String version = InternalConnectorRegistry.getVersion();
    private static final long MIN_REFRESH_DELAY_MS = 30000L;
    private static InternalConnectorRegistry internalConnectorRegistry;
    private static boolean shutdown;
    private final ListenableFuture<KeyPair> localKeyPair;
    private final ConcurrentHashMap<ConnectorConfig, Connector> unnamedConnectors = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Connector> namedConnectors = new ConcurrentHashMap();
    private final ListeningScheduledExecutorService executor;
    private final CredentialFactoryProvider credentialFactoryProvider;
    private final int serverProxyPort;
    private final long connectTimeoutMs;
    private final ConnectionInfoRepositoryFactory connectionInfoRepositoryFactory;
    static final String USER_TOKEN_PROPERTY_NAME = "_CLOUD_SQL_USER_TOKEN";

    @VisibleForTesting
    InternalConnectorRegistry(ListenableFuture<KeyPair> localKeyPair, ConnectionInfoRepositoryFactory connectionInfoRepositoryFactory, CredentialFactoryProvider credentialFactoryProvider, int serverProxyPort, long connectTimeoutMs, ListeningScheduledExecutorService executor) {
        this.connectionInfoRepositoryFactory = connectionInfoRepositoryFactory;
        this.credentialFactoryProvider = credentialFactoryProvider;
        this.serverProxyPort = serverProxyPort;
        this.executor = executor;
        this.localKeyPair = localKeyPair;
        this.connectTimeoutMs = connectTimeoutMs;
    }

    public static synchronized InternalConnectorRegistry getInstance() {
        if (shutdown) {
            throw new IllegalStateException("ConnectorRegistry was shut down.");
        }
        if (internalConnectorRegistry == null) {
            logger.debug("First Cloud SQL connection, generating RSA key pair.");
            CredentialFactoryProvider credentialFactoryProvider = new CredentialFactoryProvider();
            ListeningScheduledExecutorService executor = InternalConnectorRegistry.getDefaultExecutor();
            internalConnectorRegistry = new InternalConnectorRegistry((ListenableFuture<KeyPair>)executor.submit(InternalConnectorRegistry::generateRsaKeyPair), new DefaultConnectionInfoRepositoryFactory(InternalConnectorRegistry.getUserAgents()), credentialFactoryProvider, 3307, 45000L, executor);
        }
        return internalConnectorRegistry;
    }

    public static synchronized void resetInstance() {
        if (internalConnectorRegistry != null) {
            InternalConnectorRegistry old = internalConnectorRegistry;
            internalConnectorRegistry = null;
            old.shutdown();
            InternalConnectorRegistry.resetUserAgent();
        }
    }

    public static synchronized void shutdownInstance() {
        shutdown = true;
        InternalConnectorRegistry.resetInstance();
    }

    @VisibleForTesting
    static ListeningScheduledExecutorService getDefaultExecutor() {
        ScheduledThreadPoolExecutor executor = (ScheduledThreadPoolExecutor)Executors.newScheduledThreadPool(8);
        executor.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        return MoreExecutors.listeningDecorator((ScheduledExecutorService)MoreExecutors.getExitingScheduledExecutorService((ScheduledThreadPoolExecutor)executor));
    }

    public Socket connect(ConnectionConfig config) throws IOException, InterruptedException {
        if (config.getNamedConnector() != null) {
            Connector connector = this.getNamedConnector(config.getNamedConnector());
            return connector.connect(config.withConnectorConfig(connector.getConfig()), this.connectTimeoutMs);
        }
        Preconditions.checkArgument((config.getCloudSqlInstance() != null || config.getDomainName() != null ? 1 : 0) != 0, (Object)"cloudSqlInstance property or hostname was not set. Please specify either cloudSqlInstance or the database hostname in the JDBC URL or the connection Properties. cloudSqlInstance should contain a value in form \"project:region:instance\"");
        return this.getConnector(config).connect(config, this.connectTimeoutMs);
    }

    public ConnectionMetadata getConnectionMetadata(ConnectionConfig config) {
        if (config.getNamedConnector() != null) {
            Connector connector = this.getNamedConnector(config.getNamedConnector());
            return connector.getConnection(config.withConnectorConfig(connector.getConfig())).getConnectionMetadata(this.connectTimeoutMs);
        }
        return this.getConnector(config).getConnection(config).getConnectionMetadata(this.connectTimeoutMs);
    }

    public void forceRefresh(ConnectionConfig config) {
        if (config.getNamedConnector() != null) {
            Connector connector = this.getNamedConnector(config.getNamedConnector());
            connector.getConnection(config.withConnectorConfig(connector.getConfig())).forceRefresh();
        } else {
            this.getConnector(config).getConnection(config).forceRefresh();
        }
    }

    private static KeyPair generateRsaKeyPair() {
        KeyPairGenerator generator;
        try {
            generator = KeyPairGenerator.getInstance("RSA");
        }
        catch (NoSuchAlgorithmException err) {
            throw new RuntimeException("Unable to initialize Cloud SQL socket factory because no RSA implementation is available.");
        }
        generator.initialize(2048);
        return generator.generateKeyPair();
    }

    private static String getVersion() {
        try {
            Properties packageInfo = new Properties();
            packageInfo.load(InternalConnectorRegistry.class.getClassLoader().getResourceAsStream("com.google.cloud.sql/project.properties"));
            return packageInfo.getProperty("version", "unknown");
        }
        catch (IOException e) {
            return "unknown";
        }
    }

    public static void addArtifactId(String artifactId, boolean addVersion) {
        String userAgent = artifactId;
        if (addVersion) {
            userAgent = userAgent + "/" + version;
        }
        if (!userAgents.contains(userAgent)) {
            userAgents.add(userAgent);
        }
    }

    public static void addArtifactId(String artifactId) {
        InternalConnectorRegistry.addArtifactId(artifactId, true);
    }

    @VisibleForTesting
    static void resetUserAgent() {
        internalConnectorRegistry = null;
        userAgents.clear();
        InternalConnectorRegistry.setApplicationName("");
    }

    static String getUserAgents() {
        String ua = String.join((CharSequence)" ", userAgents);
        String appName = InternalConnectorRegistry.getApplicationName();
        if (!Strings.isNullOrEmpty((String)appName)) {
            ua = ua + " " + appName;
        }
        return ua;
    }

    private static String getApplicationName() {
        return System.getProperty(USER_TOKEN_PROPERTY_NAME, "");
    }

    public static void setApplicationName(String applicationName) {
        if (internalConnectorRegistry != null) {
            throw new IllegalStateException("Unable to set ApplicationName - SQLAdmin client already initialized.");
        }
        System.setProperty(USER_TOKEN_PROPERTY_NAME, applicationName);
    }

    private Connector getConnector(ConnectionConfig config) {
        return this.unnamedConnectors.computeIfAbsent(config.getConnectorConfig(), k -> this.createConnector(config.getConnectorConfig()));
    }

    private Connector createConnector(ConnectorConfig config) {
        String credentialsUniverse;
        CredentialFactory instanceCredentialFactory = this.credentialFactoryProvider.getInstanceCredentialFactory(config);
        String universeDomain = config.getUniverseDomain();
        try {
            credentialsUniverse = instanceCredentialFactory.getCredentials().getUniverseDomain();
        }
        catch (IOException e) {
            throw new IllegalStateException("Fail to fetch the credential universe domain");
        }
        if (credentialsUniverse != null && universeDomain != null && !credentialsUniverse.equals(universeDomain)) {
            throw new IllegalStateException(String.format("The configured universe domain (%s) does not match the credential universe domain (%s)", universeDomain, credentialsUniverse));
        }
        return new Connector(config, this.connectionInfoRepositoryFactory, instanceCredentialFactory, this.executor, this.localKeyPair, 30000L, this.connectTimeoutMs, this.serverProxyPort, new DnsInstanceConnectionNameResolver(new JndiDnsResolver()));
    }

    public void register(String name, ConnectorConfig config) {
        if (this.namedConnectors.containsKey(name)) {
            throw new IllegalArgumentException("Named connection " + name + " exists.");
        }
        this.namedConnectors.put(name, this.createConnector(config));
    }

    public void close(String name) {
        Connector connector = this.namedConnectors.remove(name);
        if (connector == null) {
            throw new IllegalArgumentException("Named connection " + name + " does not exist.");
        }
        connector.close();
    }

    public void shutdown() {
        this.unnamedConnectors.forEach((key, c) -> c.close());
        this.unnamedConnectors.clear();
        this.namedConnectors.forEach((key, c) -> c.close());
        this.namedConnectors.clear();
        this.executor.shutdown();
    }

    private Connector getNamedConnector(String name) {
        Connector connector = this.namedConnectors.get(name);
        if (connector == null) {
            throw new IllegalArgumentException("Named connection " + name + " does not exist.");
        }
        return connector;
    }

    static {
        shutdown = false;
    }
}

