/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.sql.core;

import com.google.cloud.sql.CredentialFactory;
import com.google.cloud.sql.core.AccessTokenSupplier;
import com.google.cloud.sql.core.AsyncRateLimiter;
import com.google.cloud.sql.core.CloudSqlInstanceName;
import com.google.cloud.sql.core.ConnectionConfig;
import com.google.cloud.sql.core.ConnectionInfoCache;
import com.google.cloud.sql.core.ConnectionInfoRepository;
import com.google.cloud.sql.core.ConnectionMetadata;
import com.google.cloud.sql.core.DefaultAccessTokenSupplier;
import com.google.cloud.sql.core.RefreshAheadStrategy;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import java.security.KeyPair;

class RefreshAheadConnectionInfoCache
implements ConnectionInfoCache {
    private final ConnectionConfig config;
    private final CloudSqlInstanceName instanceName;
    private final RefreshAheadStrategy refreshStrategy;

    public RefreshAheadConnectionInfoCache(ConnectionConfig config, ConnectionInfoRepository connectionInfoRepository, CredentialFactory tokenSourceFactory, ListeningScheduledExecutorService executor, ListenableFuture<KeyPair> keyPair, long minRefreshDelayMs) {
        CloudSqlInstanceName instanceName = new CloudSqlInstanceName(config.getCloudSqlInstance(), config.getDomainName());
        this.config = config;
        this.instanceName = instanceName;
        AccessTokenSupplier accessTokenSupplier = DefaultAccessTokenSupplier.newInstance(config.getAuthType(), tokenSourceFactory);
        this.refreshStrategy = new RefreshAheadStrategy(config.getCloudSqlInstance(), executor, () -> connectionInfoRepository.getConnectionInfo(instanceName, accessTokenSupplier, config.getAuthType(), executor, keyPair), new AsyncRateLimiter(minRefreshDelayMs));
    }

    @Override
    public ConnectionMetadata getConnectionMetadata(long timeoutMs) {
        return this.refreshStrategy.getConnectionInfo(timeoutMs).toConnectionMetadata(this.config, this.instanceName);
    }

    @Override
    public void forceRefresh() {
        this.refreshStrategy.forceRefresh();
    }

    @Override
    public void refreshIfExpired() {
        this.refreshStrategy.refreshIfExpired();
    }

    @Override
    public void close() {
        this.refreshStrategy.close();
    }

    public RefreshAheadStrategy getRefreshStrategy() {
        return this.refreshStrategy;
    }

    public CloudSqlInstanceName getInstanceName() {
        return this.instanceName;
    }
}

