/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.sql.nativeimage;

import com.google.api.gax.nativeimage.NativeImageUtils;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeClassInitialization;
import org.graalvm.nativeimage.hosted.RuntimeReflection;

final class CloudSqlFeature
implements Feature {
    private static final String CLOUD_SQL_SOCKET_CLASS = "com.google.cloud.sql.core.CoreSocketFactory";
    private static final String POSTGRES_SOCKET_CLASS = "com.google.cloud.sql.postgres.SocketFactory";
    private static final String MYSQL_SOCKET_CLASS = "com.google.cloud.sql.mysql.SocketFactory";

    CloudSqlFeature() {
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        Class bouncyCastleAlpnSslUtils;
        if (access.findClassByName(CLOUD_SQL_SOCKET_CLASS) == null) {
            return;
        }
        NativeImageUtils.registerClassForReflection((Feature.FeatureAccess)access, (String)CLOUD_SQL_SOCKET_CLASS);
        if (access.findClassByName("com.zaxxer.hikari.HikariConfig") != null) {
            NativeImageUtils.registerClassForReflection((Feature.FeatureAccess)access, (String)"com.zaxxer.hikari.HikariConfig");
            RuntimeReflection.register((Class[])new Class[]{access.findClassByName("[Lcom.zaxxer.hikari.util.ConcurrentBag$IConcurrentBagEntry;")});
            RuntimeReflection.register((Class[])new Class[]{access.findClassByName("[Ljava.sql.Statement;")});
        }
        if (access.findClassByName(POSTGRES_SOCKET_CLASS) != null) {
            NativeImageUtils.registerClassForReflection((Feature.FeatureAccess)access, (String)POSTGRES_SOCKET_CLASS);
            NativeImageUtils.registerClassForReflection((Feature.FeatureAccess)access, (String)"org.postgresql.PGProperty");
        }
        if (access.findClassByName(MYSQL_SOCKET_CLASS) != null) {
            Class mySqlNonTransientException;
            Class mySqlNonTransientConnectionException;
            NativeImageUtils.registerClassForReflection((Feature.FeatureAccess)access, (String)MYSQL_SOCKET_CLASS);
            NativeImageUtils.registerClassForReflection((Feature.FeatureAccess)access, (String)"com.mysql.jdbc.StandardSocketFactory");
            NativeImageUtils.registerConstructorsForReflection((Feature.FeatureAccess)access, (String)"com.mysql.cj.conf.url.SingleConnectionUrl");
            NativeImageUtils.registerConstructorsForReflection((Feature.FeatureAccess)access, (String)"com.mysql.jdbc.log.StandardLogger");
            NativeImageUtils.registerConstructorsForReflection((Feature.FeatureAccess)access, (String)"com.mysql.cj.log.StandardLogger");
            Class cjExceptionClass = access.findClassByName("com.mysql.cj.exceptions.CJException");
            if (cjExceptionClass != null) {
                access.registerSubtypeReachabilityHandler((duringAccess, exceptionClass) -> NativeImageUtils.registerClassForReflection((Feature.FeatureAccess)duringAccess, (String)exceptionClass.getName()), cjExceptionClass);
            }
            if ((mySqlNonTransientConnectionException = access.findClassByName("com.mysql.jdbc.exceptions.jdbc4.MySQLNonTransientConnectionException")) != null) {
                NativeImageUtils.registerConstructorsForReflection((Feature.FeatureAccess)access, (String)mySqlNonTransientConnectionException.getName());
            }
            if ((mySqlNonTransientException = access.findClassByName("com.mysql.jdbc.exceptions.MySQLNonTransientException")) != null) {
                NativeImageUtils.registerConstructorsForReflection((Feature.FeatureAccess)access, (String)mySqlNonTransientException.getName());
            }
            RuntimeClassInitialization.initializeAtRunTime((String[])new String[]{"com.mysql.cj.jdbc"});
        }
        if ((bouncyCastleAlpnSslUtils = access.findClassByName("io.netty.handler.ssl.BouncyCastleAlpnSslUtils")) != null) {
            RuntimeClassInitialization.initializeAtRunTime((Class[])new Class[]{bouncyCastleAlpnSslUtils});
        }
        if (access.findClassByName("jnr.ffi.provider.FFIProvider") != null) {
            String asmEnabledPropertyKey = "jnr.ffi.asm.enabled";
            if (System.getProperty(asmEnabledPropertyKey) == null) {
                System.setProperty(asmEnabledPropertyKey, String.valueOf(false));
            }
            NativeImageUtils.registerForReflectiveInstantiation((Feature.FeatureAccess)access, (String)"jnr.ffi.provider.jffi.Provider");
            RuntimeClassInitialization.initializeAtBuildTime((String[])new String[]{"jnr.ffi.provider.jffi.NativeLibraryLoader"});
            NativeImageUtils.registerClassForReflection((Feature.FeatureAccess)access, (String)"com.kenai.jffi.internal.StubLoader");
            NativeImageUtils.registerClassForReflection((Feature.FeatureAccess)access, (String)"com.kenai.jffi.Version");
            NativeImageUtils.registerClassForReflection((Feature.FeatureAccess)access, (String)"jnr.ffi.provider.jffi.platform.x86_64.linux.TypeAliases");
            CloudSqlFeature.registerPackageForReflection((Feature.FeatureAccess)access, "jnr.constants");
        }
    }

    public static void registerPackageForReflection(Feature.FeatureAccess access, String packageName) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            String path = packageName.replace('.', '/');
            Enumeration<URL> resources = classLoader.getResources(path);
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                URLConnection connection = url.openConnection();
                if (!(connection instanceof JarURLConnection)) continue;
                List<String> classes = CloudSqlFeature.findClassesInJar((JarURLConnection)connection, packageName);
                for (String className : classes) {
                    NativeImageUtils.registerClassHierarchyForReflection((Feature.FeatureAccess)access, (String)className);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load classes under package name.", e);
        }
    }

    private static List<String> findClassesInJar(JarURLConnection urlConnection, String packageName) throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        JarFile jarFile = urlConnection.getJarFile();
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            String javaClassName;
            JarEntry entry = entries.nextElement();
            String entryName = entry.getName();
            if (!entryName.endsWith(".class") || !(javaClassName = entryName.replace(".class", "").replace('/', '.')).startsWith(packageName)) continue;
            result.add(javaClassName);
        }
        return result;
    }
}

