/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.sql.mysql;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import com.google.api.client.googleapis.json.GoogleJsonError;
import com.google.api.client.googleapis.json.GoogleJsonResponseException;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.services.sqladmin.SQLAdmin;
import com.google.api.services.sqladmin.model.DatabaseInstance;
import com.google.api.services.sqladmin.model.IpMapping;
import com.google.api.services.sqladmin.model.SslCert;
import com.google.api.services.sqladmin.model.SslCertsCreateEphemeralRequest;
import com.google.cloud.sql.mysql.CredentialFactory;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.base.Throwables;
import com.google.common.util.concurrent.RateLimiter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import javax.xml.bind.DatatypeConverter;

class SslSocketFactory {
    private static final Logger logger = Logger.getLogger(SslSocketFactory.class.getName());
    static final String ADMIN_API_NOT_ENABLED_REASON = "accessNotConfigured";
    static final String INSTANCE_NOT_AUTHORIZED_REASON = "notAuthorized";
    private static final String CREDENTIAL_FACTORY_PROPERTY = "_CLOUD_SQL_API_CREDENTIAL_FACTORY";
    private static final String API_ROOT_URL_PROPERTY = "_CLOUD_SQL_API_ROOT_URL";
    private static final String API_SERVICE_PATH_PROPERTY = "_CLOUD_SQL_API_SERVICE_PATH";
    private static final int DEFAULT_SERVER_PROXY_PORT = 3307;
    private static final int RSA_KEY_SIZE = 2048;
    private static SslSocketFactory sslSocketFactory;
    private final CertificateFactory certificateFactory;
    private final Clock clock;
    private final KeyPair localKeyPair;
    private final Credential credential;
    private final Map<String, InstanceLookupResult> cache = new HashMap<String, InstanceLookupResult>();
    private final SQLAdmin adminApi;
    private final int serverProxyPort;
    private final RateLimiter forcedRenewRateLimiter = RateLimiter.create((double)0.016666666666666666);

    @VisibleForTesting
    SslSocketFactory(Clock clock, KeyPair localKeyPair, Credential credential, SQLAdmin adminApi, int serverProxyPort) {
        try {
            this.certificateFactory = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException e) {
            throw new RuntimeException("X509 implementation not available", e);
        }
        this.clock = clock;
        this.localKeyPair = localKeyPair;
        this.credential = credential;
        this.adminApi = adminApi;
        this.serverProxyPort = serverProxyPort;
    }

    static synchronized SslSocketFactory getInstance() {
        if (sslSocketFactory == null) {
            CredentialFactory credentialFactory;
            logger.info("First Cloud SQL connection, generating RSA key pair.");
            KeyPair keyPair = SslSocketFactory.generateRsaKeyPair();
            if (System.getProperty(CREDENTIAL_FACTORY_PROPERTY) != null) {
                SslSocketFactory.logTestPropertyWarning(CREDENTIAL_FACTORY_PROPERTY);
                try {
                    credentialFactory = (CredentialFactory)Class.forName(System.getProperty(CREDENTIAL_FACTORY_PROPERTY)).newInstance();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            } else {
                credentialFactory = new ApplicationDefaultCredentialFactory();
            }
            Credential credential = credentialFactory.create();
            SQLAdmin adminApi = SslSocketFactory.createAdminApiClient(credential);
            sslSocketFactory = new SslSocketFactory(new Clock(), keyPair, credential, adminApi, 3307);
        }
        return sslSocketFactory;
    }

    Socket create(String instanceName) throws IOException {
        try {
            return this.createAndConfigureSocket(instanceName, CertificateCaching.USE_CACHE);
        }
        catch (SSLHandshakeException e) {
            logger.warning(String.format("SSL handshake failed for Cloud SQL instance [%s], retrying with new certificate.\n%s", instanceName, Throwables.getStackTraceAsString((Throwable)e)));
            if (!this.forcedRenewRateLimiter.tryAcquire()) {
                logger.warning(String.format("Renewing too often, rate limiting certificate renewal for Cloud SQL instance [%s].", instanceName));
                this.forcedRenewRateLimiter.acquire();
            }
            return this.createAndConfigureSocket(instanceName, CertificateCaching.BYPASS_CACHE);
        }
    }

    private static void logTestPropertyWarning(String property) {
        logger.warning(String.format("%s is a test property and may be changed or removed in a future version without notice.", property));
    }

    private SSLSocket createAndConfigureSocket(String instanceName, CertificateCaching certificateCaching) throws IOException {
        InstanceSslInfo instanceSslInfo = this.getInstanceSslInfo(instanceName, certificateCaching);
        String ipAddress = instanceSslInfo.getInstanceIpAddress();
        logger.info(String.format("Connecting to Cloud SQL instance [%s] on IP [%s].", instanceName, ipAddress));
        SSLSocket sslSocket = (SSLSocket)instanceSslInfo.getSslSocketFactory().createSocket(ipAddress, this.serverProxyPort);
        sslSocket.setKeepAlive(true);
        sslSocket.setTcpNoDelay(true);
        sslSocket.startHandshake();
        return sslSocket;
    }

    @VisibleForTesting
    synchronized InstanceSslInfo getInstanceSslInfo(String instanceConnectionString, CertificateCaching certificateCaching) {
        InstanceSslInfo details;
        InstanceLookupResult lookupResult;
        if (certificateCaching.equals((Object)CertificateCaching.USE_CACHE) && (lookupResult = this.cache.get(instanceConnectionString)) != null) {
            if (!lookupResult.isSuccessful() && this.clock.now() - lookupResult.getLastFailureMillis() < 60000L) {
                logger.warning("Re-throwing cached exception due to attempt to refresh instance information too soon after error.");
                throw (RuntimeException)lookupResult.getException().get();
            }
            if (lookupResult.isSuccessful()) {
                InstanceSslInfo details2 = (InstanceSslInfo)lookupResult.getInstanceSslInfo().get();
                if (details2 != null) {
                    GregorianCalendar calendar = new GregorianCalendar();
                    calendar.setTimeInMillis(this.clock.now());
                    calendar.add(12, 5);
                    try {
                        details2.getEphemeralCertificate().checkValidity(calendar.getTime());
                    }
                    catch (CertificateException e) {
                        logger.info(String.format("Ephemeral certificate for Cloud SQL instance [%s] is about to expire, obtaining new one.", instanceConnectionString));
                        details2 = null;
                    }
                }
                if (details2 != null) {
                    return details2;
                }
            }
        }
        String invalidInstanceError = String.format("Invalid Cloud SQL instance [%s], expected value in form [project:region:name].", instanceConnectionString);
        int beforeNameIndex = instanceConnectionString.lastIndexOf(58);
        if (beforeNameIndex <= 0) {
            throw new IllegalArgumentException(invalidInstanceError);
        }
        int beforeRegionIndex = instanceConnectionString.lastIndexOf(58, beforeNameIndex - 1);
        if (beforeRegionIndex <= 0) {
            throw new IllegalArgumentException(invalidInstanceError);
        }
        String projectId = instanceConnectionString.substring(0, beforeRegionIndex);
        String region = instanceConnectionString.substring(beforeRegionIndex + 1, beforeNameIndex);
        String instanceName = instanceConnectionString.substring(beforeNameIndex + 1);
        try {
            details = this.fetchInstanceSslInfo(instanceConnectionString, projectId, region, instanceName);
            InstanceLookupResult instanceLookupResult = new InstanceLookupResult(details);
            this.cache.put(instanceConnectionString, instanceLookupResult);
        }
        catch (RuntimeException e) {
            InstanceLookupResult instanceLookupResult = new InstanceLookupResult(e);
            this.cache.put(instanceConnectionString, instanceLookupResult);
            throw e;
        }
        return details;
    }

    private InstanceSslInfo fetchInstanceSslInfo(String instanceConnectionString, String projectId, String region, String instanceName) {
        Certificate instanceCaCertificate;
        logger.info(String.format("Obtaining ephemeral certificate for Cloud SQL instance [%s].", instanceConnectionString));
        DatabaseInstance instance = this.obtainInstanceMetadata(this.adminApi, instanceConnectionString, projectId, instanceName);
        if (instance.getIpAddresses().isEmpty()) {
            throw new RuntimeException(String.format("Cloud SQL instance [%s] does not have any external IP addresses", instanceConnectionString));
        }
        if (!instance.getRegion().equals(region)) {
            throw new IllegalArgumentException(String.format("Incorrect region value [%s] for Cloud SQL instance [%s], should be [%s]", region, instanceConnectionString, instance.getRegion()));
        }
        X509Certificate ephemeralCertificate = this.obtainEphemeralCertificate(this.adminApi, instanceConnectionString, projectId, instanceName);
        try {
            instanceCaCertificate = this.certificateFactory.generateCertificate(new ByteArrayInputStream(instance.getServerCaCert().getCert().getBytes(StandardCharsets.UTF_8)));
        }
        catch (CertificateException e) {
            throw new RuntimeException(String.format("Unable to parse certificate for Cloud SQL instance [%s]", instanceConnectionString), e);
        }
        SSLContext sslContext = this.createSslContext(ephemeralCertificate, instanceCaCertificate);
        return new InstanceSslInfo(((IpMapping)instance.getIpAddresses().get(0)).getIpAddress(), ephemeralCertificate, sslContext.getSocketFactory());
    }

    private SSLContext createSslContext(Certificate ephemeralCertificate, Certificate instanceCaCertificate) {
        KeyStore trustKeyStore;
        KeyStore authKeyStore;
        try {
            authKeyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            authKeyStore.load(null, null);
            KeyStore.PrivateKeyEntry pk = new KeyStore.PrivateKeyEntry(this.localKeyPair.getPrivate(), new Certificate[]{ephemeralCertificate});
            authKeyStore.setEntry("ephemeral", pk, new KeyStore.PasswordProtection(new char[0]));
        }
        catch (IOException | GeneralSecurityException e) {
            throw new RuntimeException("There was a problem initializing the auth key store", e);
        }
        try {
            trustKeyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            trustKeyStore.load(null, null);
            trustKeyStore.setCertificateEntry("instance", instanceCaCertificate);
        }
        catch (IOException | GeneralSecurityException e) {
            throw new RuntimeException("There was a problem initializing the trust key store", e);
        }
        try {
            SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            keyManagerFactory.init(authKeyStore, new char[0]);
            TrustManagerFactory tmf = TrustManagerFactory.getInstance("X.509");
            tmf.init(trustKeyStore);
            sslContext.init(keyManagerFactory.getKeyManagers(), tmf.getTrustManagers(), new SecureRandom());
            return sslContext;
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException("There was a problem initializing the SSL context", e);
        }
    }

    private DatabaseInstance obtainInstanceMetadata(SQLAdmin adminApi, String instanceConnectionString, String projectId, String instanceName) {
        DatabaseInstance instance;
        try {
            instance = (DatabaseInstance)adminApi.instances().get(projectId, instanceName).execute();
        }
        catch (GoogleJsonResponseException e) {
            if (e.getDetails() == null || e.getDetails().getErrors().isEmpty()) {
                throw new RuntimeException(String.format("Unable to retrieve information about Cloud SQL instance [%s]", instanceConnectionString), e);
            }
            String reason = ((GoogleJsonError.ErrorInfo)e.getDetails().getErrors().get(0)).getReason();
            if (ADMIN_API_NOT_ENABLED_REASON.equals(reason)) {
                String apiLink = "https://console.cloud.google.com/apis/api/sqladmin/overview?project=" + projectId;
                throw new RuntimeException(String.format("The Google Cloud SQL API is not enabled for project [%s]. Please use the Google Developers Console to enable it: %s", projectId, apiLink));
            }
            if (INSTANCE_NOT_AUTHORIZED_REASON.equals(reason)) {
                String who = "you are";
                if (this.getCredentialServiceAccount(this.credential) != null) {
                    who = "[" + this.getCredentialServiceAccount(this.credential) + "] is";
                }
                throw new RuntimeException(String.format("Cloud SQL Instance [%s] does not exist or %s not authorized to access it. Please check the instance and project names to make sure they are correct.", instanceConnectionString, who));
            }
            throw new RuntimeException(String.format("Unable to retrieve information about Cloud SQL instance [%s]", instanceConnectionString), e);
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Unable to retrieve information about Cloud SQL instance [%s]", instanceConnectionString), e);
        }
        if (!instance.getBackendType().equals("SECOND_GEN")) {
            throw new IllegalArgumentException("This client only supports connections to Second Generation Cloud SQL instances");
        }
        return instance;
    }

    private X509Certificate obtainEphemeralCertificate(SQLAdmin adminApi, String instanceConnectionString, String projectId, String instanceName) {
        SslCert response;
        StringBuilder publicKeyPemBuilder = new StringBuilder();
        publicKeyPemBuilder.append("-----BEGIN RSA PUBLIC KEY-----\n");
        publicKeyPemBuilder.append(DatatypeConverter.printBase64Binary((byte[])this.localKeyPair.getPublic().getEncoded()).replaceAll("(.{64})", "$1\n"));
        publicKeyPemBuilder.append("\n");
        publicKeyPemBuilder.append("-----END RSA PUBLIC KEY-----\n");
        SslCertsCreateEphemeralRequest req = new SslCertsCreateEphemeralRequest();
        req.setPublicKey(publicKeyPemBuilder.toString());
        try {
            response = (SslCert)adminApi.sslCerts().createEphemeral(projectId, instanceName, req).execute();
        }
        catch (GoogleJsonResponseException e) {
            if (e.getDetails() == null || e.getDetails().getErrors().isEmpty()) {
                throw new RuntimeException(String.format("Unable to obtain ephemeral certificate for Cloud SQL instance [%s]", instanceConnectionString), e);
            }
            String reason = ((GoogleJsonError.ErrorInfo)e.getDetails().getErrors().get(0)).getReason();
            if (INSTANCE_NOT_AUTHORIZED_REASON.equals(reason)) {
                String who = "you have";
                if (this.getCredentialServiceAccount(this.credential) != null) {
                    who = "[" + this.getCredentialServiceAccount(this.credential) + "] has";
                }
                throw new RuntimeException(String.format("Unable to obtain ephemeral certificate for Cloud SQL Instance [%s]. Make sure %s Editor or Owner role on the project.", instanceConnectionString, who));
            }
            throw new RuntimeException(String.format("Unable to obtain ephemeral certificate for Cloud SQL instance [%s]", instanceConnectionString), e);
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Unable to obtain ephemeral certificate for Cloud SQL instance [%s]", instanceConnectionString), e);
        }
        try {
            return (X509Certificate)this.certificateFactory.generateCertificate(new ByteArrayInputStream(response.getCert().getBytes(StandardCharsets.UTF_8)));
        }
        catch (CertificateException e) {
            throw new RuntimeException(String.format("Unable to parse ephemeral certificate for Cloud SQL instance [%s]", instanceConnectionString), e);
        }
    }

    @Nullable
    private String getCredentialServiceAccount(Credential credential) {
        return credential instanceof GoogleCredential ? ((GoogleCredential)credential).getServiceAccountId() : null;
    }

    private static SQLAdmin createAdminApiClient(Credential credential) {
        NetHttpTransport httpTransport;
        try {
            httpTransport = GoogleNetHttpTransport.newTrustedTransport();
        }
        catch (IOException | GeneralSecurityException e) {
            throw new RuntimeException("Unable to initialize HTTP transport", e);
        }
        String rootUrl = System.getProperty(API_ROOT_URL_PROPERTY);
        String servicePath = System.getProperty(API_SERVICE_PATH_PROPERTY);
        JacksonFactory jsonFactory = JacksonFactory.getDefaultInstance();
        SQLAdmin.Builder adminApiBuilder = new SQLAdmin.Builder((HttpTransport)httpTransport, (JsonFactory)jsonFactory, (HttpRequestInitializer)credential).setApplicationName("Cloud SQL Java Socket Factory");
        if (rootUrl != null) {
            SslSocketFactory.logTestPropertyWarning(API_ROOT_URL_PROPERTY);
            adminApiBuilder.setRootUrl(rootUrl);
        }
        if (servicePath != null) {
            SslSocketFactory.logTestPropertyWarning(API_SERVICE_PATH_PROPERTY);
            adminApiBuilder.setServicePath(servicePath);
        }
        return adminApiBuilder.build();
    }

    private static KeyPair generateRsaKeyPair() {
        KeyPairGenerator generator;
        try {
            generator = KeyPairGenerator.getInstance("RSA");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Unable to initialize Cloud SQL socket factory because no RSA implementation is available.");
        }
        generator.initialize(2048);
        return generator.generateKeyPair();
    }

    static class Clock {
        Clock() {
        }

        long now() {
            return System.currentTimeMillis();
        }
    }

    @VisibleForTesting
    static enum CertificateCaching {
        USE_CACHE,
        BYPASS_CACHE;

    }

    private static class InstanceSslInfo {
        private final String instanceIpAddress;
        private final X509Certificate ephemeralCertificate;
        private final SSLSocketFactory sslSocketFactory;

        InstanceSslInfo(String instanceIpAddress, X509Certificate ephemeralCertificate, SSLSocketFactory sslSocketFactory) {
            this.instanceIpAddress = instanceIpAddress;
            this.ephemeralCertificate = ephemeralCertificate;
            this.sslSocketFactory = sslSocketFactory;
        }

        public String getInstanceIpAddress() {
            return this.instanceIpAddress;
        }

        public X509Certificate getEphemeralCertificate() {
            return this.ephemeralCertificate;
        }

        public SSLSocketFactory getSslSocketFactory() {
            return this.sslSocketFactory;
        }
    }

    private class InstanceLookupResult {
        private final Optional<RuntimeException> exception;
        private final long lastFailureMillis;
        private final Optional<InstanceSslInfo> instanceSslInfo;

        public InstanceLookupResult(RuntimeException exception) {
            this.exception = Optional.of((Object)exception);
            this.lastFailureMillis = SslSocketFactory.this.clock.now();
            this.instanceSslInfo = Optional.absent();
        }

        public InstanceLookupResult(InstanceSslInfo instanceSslInfo) {
            this.instanceSslInfo = Optional.of((Object)instanceSslInfo);
            this.exception = Optional.absent();
            this.lastFailureMillis = 0L;
        }

        public boolean isSuccessful() {
            return !this.exception.isPresent();
        }

        public Optional<InstanceSslInfo> getInstanceSslInfo() {
            return this.instanceSslInfo;
        }

        public Optional<RuntimeException> getException() {
            return this.exception;
        }

        public long getLastFailureMillis() {
            return this.lastFailureMillis;
        }
    }

    private static class ApplicationDefaultCredentialFactory
    implements CredentialFactory {
        private ApplicationDefaultCredentialFactory() {
        }

        @Override
        public Credential create() {
            GoogleCredential credential;
            try {
                credential = GoogleCredential.getApplicationDefault();
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to obtain credentials to communicate with the Cloud SQL API", e);
            }
            if (credential.createScopedRequired()) {
                credential = credential.createScoped(Collections.singletonList("https://www.googleapis.com/auth/sqlservice.admin"));
            }
            return credential;
        }
    }
}

