/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.sql.mysql;

import com.google.cloud.sql.core.SslSocketFactory;
import com.google.common.base.Preconditions;
import com.mysql.cj.protocol.ServerSession;
import com.mysql.cj.protocol.SocketConnection;
import java.io.File;
import java.io.IOException;
import java.net.Socket;
import java.util.Properties;
import java.util.logging.Logger;
import jnr.unixsocket.UnixSocketAddress;
import jnr.unixsocket.UnixSocketChannel;

public class SocketFactory
implements com.mysql.cj.protocol.SocketFactory {
    private static final Logger logger = Logger.getLogger(SocketFactory.class.getName());
    private static final String CloudSqlPrefix = "/cloudsql/";
    private Socket socket;

    public Socket connect(String host, int portNumber, Properties props, int loginTimeout) throws IOException {
        String instanceName = props.getProperty("cloudSqlInstance");
        Preconditions.checkArgument((instanceName != null ? 1 : 0) != 0, (Object)"cloudSqlInstance property not set. Please specify this property in the JDBC URL or the connection Properties with value in form \"project:region:instance\"");
        String gaeEnv = System.getenv("GAE_ENV");
        String runEnv = System.getProperty("com.google.appengine.runtime.environment");
        Boolean forceUnixSocket = System.getenv("CLOUD_SQL_FORCE_UNIX_SOCKET") != null;
        if (forceUnixSocket.booleanValue() || "standard".equals(gaeEnv) && "Production".equals(runEnv)) {
            logger.info(String.format("Connecting to Cloud SQL instance [%s] via unix socket.", instanceName));
            UnixSocketAddress socketAddress = new UnixSocketAddress(new File(CloudSqlPrefix + instanceName));
            this.socket = UnixSocketChannel.open((UnixSocketAddress)socketAddress).socket();
        } else {
            logger.info(String.format("Connecting to Cloud SQL instance [%s] via ssl socket.", instanceName));
            this.socket = SslSocketFactory.getInstance().create(instanceName);
        }
        return this.socket;
    }

    public void beforeHandshake() {
    }

    public Socket performTlsHandshake(SocketConnection socketConnection, ServerSession serverSession) {
        return this.socket;
    }

    public void afterHandshake() {
    }
}

