/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.sql.mysql;

import com.google.cloud.sql.core.SslSocketFactory;
import com.google.common.base.Preconditions;
import com.mysql.cj.conf.PropertySet;
import com.mysql.cj.protocol.ServerSession;
import com.mysql.cj.protocol.SocketConnection;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.Socket;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import jnr.unixsocket.UnixSocketAddress;
import jnr.unixsocket.UnixSocketChannel;

public class SocketFactory
implements com.mysql.cj.protocol.SocketFactory {
    private static final Logger logger = Logger.getLogger(SocketFactory.class.getName());
    private static final String CloudSqlPrefix = "/cloudsql/";
    private Socket socket;

    public <T extends Closeable> T connect(String host, int portNumber, PropertySet props, int loginTimeout) throws IOException {
        return this.connect(host, portNumber, props.exposeAsProperties(), loginTimeout);
    }

    public <T extends Closeable> T connect(String host, int portNumber, Properties props, int loginTimeout) throws IOException {
        boolean forceUnixSocket;
        String instanceName = props.getProperty("cloudSqlInstance");
        Preconditions.checkArgument((instanceName != null ? 1 : 0) != 0, (Object)"cloudSqlInstance property not set. Please specify this property in the JDBC URL or the connection Properties with value in form \"project:region:instance\"");
        boolean bl = forceUnixSocket = System.getenv("CLOUD_SQL_FORCE_UNIX_SOCKET") != null;
        if (forceUnixSocket || this.runningOnGaeStandard()) {
            logger.info(String.format("Connecting to Cloud SQL instance [%s] via unix socket.", instanceName));
            UnixSocketAddress socketAddress = new UnixSocketAddress(new File(CloudSqlPrefix + instanceName));
            this.socket = UnixSocketChannel.open((UnixSocketAddress)socketAddress).socket();
        } else {
            logger.info(String.format("Connecting to Cloud SQL instance [%s] via ssl socket.", instanceName));
            List ipTypes = SslSocketFactory.listIpTypes((String)props.getProperty("ipTypes", "PUBLIC,PRIVATE"));
            this.socket = SslSocketFactory.getInstance().create(instanceName, ipTypes);
        }
        Socket castSocket = this.socket;
        return (T)castSocket;
    }

    public void beforeHandshake() {
    }

    public Socket performTlsHandshake(SocketConnection socketConnection, ServerSession serverSession) {
        return this.socket;
    }

    public void afterHandshake() {
    }

    private boolean runningOnGaeStandard() {
        String gaeEnv = System.getenv("GAE_ENV");
        String runEnv = System.getProperty("com.google.appengine.runtime.environment");
        String gaeRuntime = System.getenv("GAE_RUNTIME");
        return "standard".equals(gaeEnv) && ("Production".equals(runEnv) || "java11".equals(gaeRuntime));
    }
}

