/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.beanmatchers;

import com.google.code.beanmatchers.AccessorMissingException;
import com.google.code.beanmatchers.JavaBean;
import com.google.code.beanmatchers.TypeBasedValueGenerator;
import java.util.List;
import org.hamcrest.Description;
import org.hamcrest.DiagnosingMatcher;

abstract class AbstractBeanAccessorMatcher<T>
extends DiagnosingMatcher<T> {
    final TypeBasedValueGenerator valueGenerator;

    AbstractBeanAccessorMatcher(TypeBasedValueGenerator valueGenerator) {
        this.valueGenerator = valueGenerator;
    }

    protected boolean beanHasValidGetterAndSetterForProperties(JavaBean bean, List<String> properties, Description mismatchDescription) {
        for (String property : properties) {
            if (!this.beanDoesNotHaveValidGetterAndSetterForProperty(bean, property)) continue;
            mismatchDescription.appendText("bean of type ").appendValue((Object)bean.beanType().getName()).appendText(" had an invalid getter/setter for the property ").appendValue((Object)property);
            return false;
        }
        return true;
    }

    protected boolean beanDoesNotHaveValidGetterAndSetterForProperty(JavaBean bean, String property) {
        try {
            Class<?> propertyType = bean.propertyType(property);
            Object testValue = this.valueGenerator.generate(propertyType);
            bean.setProperty(property, testValue);
            Object result = bean.getProperty(property);
            return !testValue.equals(result);
        }
        catch (AccessorMissingException exception) {
            return true;
        }
    }
}

