/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.beanmatchers;

import com.google.code.beanmatchers.DistinctValues;
import com.google.code.beanmatchers.JavaBean;
import com.google.code.beanmatchers.TypeBasedValueGenerator;
import com.google.code.beanmatchers.ValueGenerators;
import java.util.List;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeDiagnosingMatcher;

abstract class AbstractBeanHashCodeMatcher<T>
extends TypeSafeDiagnosingMatcher<Class<T>> {
    final TypeBasedValueGenerator valueGenerator;

    AbstractBeanHashCodeMatcher(TypeBasedValueGenerator valueGenerator) {
        this.valueGenerator = valueGenerator;
    }

    protected boolean hashCodeIsInfluencedByProperties(JavaBean bean, List<String> properties, Description mismatchDescription) {
        for (String property : properties) {
            if (!this.hashCodeNotInfluencedByProperty(bean, property)) continue;
            mismatchDescription.appendText("bean of type ").appendValue((Object)bean.beanType().getName()).appendText(" had a hashCode not influenced by the property ").appendValue((Object)property);
            return false;
        }
        return true;
    }

    private boolean hashCodeNotInfluencedByProperty(JavaBean bean, String property) {
        Class<?> propertyType = bean.propertyType(property);
        DistinctValues<?> values = ValueGenerators.generateTwoDistinctValues(this.valueGenerator, propertyType);
        bean.setProperty(property, values.getValueOne());
        int initialHashCode = bean.hashCode();
        bean.setProperty(property, values.getValueTwo());
        int influencedHashCode = bean.hashCode();
        return initialHashCode == influencedHashCode;
    }
}

