/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.beanmatchers;

import com.google.code.beanmatchers.AbstractBeanEqualsMatcher;
import com.google.code.beanmatchers.BeanOperations;
import com.google.code.beanmatchers.TypeBasedValueGenerator;
import java.util.Arrays;
import java.util.List;
import org.hamcrest.Description;

public class HasValidBeanEqualsExcludingMatcher<T>
extends AbstractBeanEqualsMatcher<T> {
    private final List<String> excludedProperties;

    HasValidBeanEqualsExcludingMatcher(TypeBasedValueGenerator valueGenerator, String ... excludedProperties) {
        super(valueGenerator);
        this.excludedProperties = Arrays.asList(excludedProperties);
    }

    protected boolean matchesSafely(Class<T> beanType, Description mismatchDescription) {
        List<String> properties = BeanOperations.properties(beanType);
        properties.removeAll(this.excludedProperties);
        return this.isValidBeanEquals(beanType, properties, mismatchDescription);
    }

    public void describeTo(Description description) {
        if (this.excludedProperties.isEmpty()) {
            description.appendText("bean with all properties compared in equals");
        } else {
            description.appendText("bean with all properties excluding ");
            description.appendValue(this.excludedProperties);
            description.appendText(" compared in equals");
        }
    }
}

