/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.beanmatchers;

import com.google.code.beanmatchers.AbstractBeanAccessorMatcher;
import com.google.code.beanmatchers.JavaBean;
import com.google.code.beanmatchers.TypeBasedValueGenerator;
import java.util.Arrays;
import java.util.List;
import org.hamcrest.Description;

public class HasValidGettersAndSettersExcludingMatcher<T>
extends AbstractBeanAccessorMatcher<T> {
    private List<String> excludedProperties;

    HasValidGettersAndSettersExcludingMatcher(TypeBasedValueGenerator valueGenerator, String ... excludedProperties) {
        super(valueGenerator);
        this.excludedProperties = Arrays.asList(excludedProperties);
    }

    protected boolean matches(Object item, Description mismatchDescription) {
        JavaBean bean = new JavaBean(item);
        List<String> properties = bean.properties();
        properties.removeAll(this.excludedProperties);
        return super.beanHasValidGetterAndSetterForProperties(bean, properties, mismatchDescription);
    }

    public void describeTo(Description description) {
        if (this.excludedProperties.isEmpty()) {
            description.appendText("bean with valid setter and getter methods for all properties");
        } else {
            description.appendText("bean with valid setter and getter methods for all properties excluding ");
            description.appendValue(this.excludedProperties);
        }
    }
}

