/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.beanmatchers;

import com.google.code.beanmatchers.BeanMatchersException;
import com.google.code.beanmatchers.BeanOperations;
import java.beans.PropertyDescriptor;
import java.util.List;

class JavaBean {
    private final Object targetBean;
    private final PropertyDescriptor[] descriptors;

    public JavaBean(Object targetBean) {
        this.targetBean = targetBean;
        this.descriptors = BeanOperations.propertyDescriptors(targetBean);
    }

    public JavaBean(Class targetBeanType) {
        this(BeanOperations.instantiateBean(targetBeanType));
    }

    public Class beanType() {
        return this.targetBean.getClass();
    }

    public Class<?> propertyType(String propertyName) {
        return this.descriptorForName(propertyName).getPropertyType();
    }

    public void setProperty(String propertyName, Object value) {
        BeanOperations.invokeSetter(this.targetBean, this.descriptorForName(propertyName), value);
    }

    public Object getProperty(String propertyName) {
        return BeanOperations.invokeGetter(this.targetBean, this.descriptorForName(propertyName));
    }

    private PropertyDescriptor descriptorForName(String propertyName) {
        for (PropertyDescriptor propertyDescriptor : this.descriptors) {
            if (!propertyDescriptor.getName().equals(propertyName)) continue;
            return propertyDescriptor;
        }
        throw new BeanMatchersException("No property named '" + propertyName + "' on bean " + this.targetBean);
    }

    public List<String> properties() {
        return BeanOperations.properties(this.descriptors);
    }

    public String toString() {
        return this.targetBean.toString();
    }

    public int hashCode() {
        return this.targetBean.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof JavaBean) {
            return this.targetBean.equals(((JavaBean)object).targetBean);
        }
        return this.targetBean.equals(object);
    }
}

