/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.beanmatchers;

import com.google.code.beanmatchers.BeanMatchersException;
import com.google.code.beanmatchers.BeanOperations;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public class HasValidBeanConstructorMatcher
extends TypeSafeDiagnosingMatcher<Class> {
    protected boolean matchesSafely(Class item, Description mismatchDescription) {
        try {
            BeanOperations.noArgsConstructor(item);
            return true;
        }
        catch (BeanMatchersException exception) {
            mismatchDescription.appendText("bean of type ").appendValue((Object)item.getName()).appendText(" does not have a no-args constructor");
            return false;
        }
    }

    public void describeTo(Description description) {
        description.appendText("bean class with a valid no-args constructor");
    }
}

