/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.beanmatchers;

import com.google.code.beanmatchers.JavaBean;
import com.google.code.beanmatchers.TypeBasedValueGenerator;
import java.lang.reflect.Array;
import java.util.List;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeDiagnosingMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractBeanToStringMatcher<T>
extends TypeSafeDiagnosingMatcher<Class<T>> {
    final TypeBasedValueGenerator valueGenerator;

    AbstractBeanToStringMatcher(TypeBasedValueGenerator valueGenerator) {
        this.valueGenerator = valueGenerator;
    }

    protected boolean toStringDescribesProperties(Class beanType, List<String> properties, Description mismatchDescription) {
        String toStringResult = new JavaBean(beanType).toString();
        if (!toStringResult.contains(beanType.getSimpleName())) {
            this.describeToStringMismatch(beanType, mismatchDescription).appendText("It did not produce the bean class name: ").appendValue((Object)toStringResult);
            return false;
        }
        for (String property : properties) {
            JavaBean bean = new JavaBean(beanType);
            Object value = this.valueGenerator.generate(bean.propertyType(property));
            bean.setProperty(property, value);
            toStringResult = bean.toString();
            if (!toStringResult.contains(property)) {
                this.describeToStringMismatch(beanType, mismatchDescription).appendText("It did not produce the property name ").appendValue((Object)property).appendText(", actual output ").appendValue((Object)toStringResult);
                return false;
            }
            if (!this.resultDoesNotContainValue(toStringResult, value)) continue;
            this.describeToStringMismatch(beanType, mismatchDescription).appendText("It did not produce the value for property ").appendValue((Object)property).appendText(", actual output ").appendValue((Object)toStringResult);
            return false;
        }
        return true;
    }

    private boolean resultDoesNotContainValue(String toStringResult, Object value) {
        if (value.getClass().isArray()) {
            for (int i = 0; i < Array.getLength(value); ++i) {
                if (!this.resultDoesNotContainValue(toStringResult, Array.get(value, i))) continue;
                return true;
            }
            return false;
        }
        return !toStringResult.contains(value.toString());
    }

    private Description describeToStringMismatch(Class beanType, Description mismatchDescription) {
        return mismatchDescription.appendText("bean of type ").appendValue((Object)beanType.getName()).appendText(" had an invalid toString() method. ");
    }
}

