/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.beanmatchers;

import com.google.code.beanmatchers.ArrayTypeBasedValueGenerator;
import com.google.code.beanmatchers.BooleanGenerator;
import com.google.code.beanmatchers.ByteGenerator;
import com.google.code.beanmatchers.CharacterGenerator;
import com.google.code.beanmatchers.DefaultTypeBasedValueGenerator;
import com.google.code.beanmatchers.DoubleGenerator;
import com.google.code.beanmatchers.EnumBasedValueGenerator;
import com.google.code.beanmatchers.FloatGenerator;
import com.google.code.beanmatchers.HasToStringDescribingPropertiesExcludingMatcher;
import com.google.code.beanmatchers.HasToStringDescribingPropertiesMatcher;
import com.google.code.beanmatchers.HasValidBeanConstructorMatcher;
import com.google.code.beanmatchers.HasValidBeanEqualsExcludingMatcher;
import com.google.code.beanmatchers.HasValidBeanEqualsForMatcher;
import com.google.code.beanmatchers.HasValidBeanHashCodeExcludingMatcher;
import com.google.code.beanmatchers.HasValidBeanHashCodeForMatcher;
import com.google.code.beanmatchers.HasValidGettersAndSettersExcludingMatcher;
import com.google.code.beanmatchers.HasValidGettersAndSettersMatcher;
import com.google.code.beanmatchers.InMemoryValueGeneratorRepository;
import com.google.code.beanmatchers.InstantiatingMatcherDecorator;
import com.google.code.beanmatchers.IntegerGenerator;
import com.google.code.beanmatchers.LongGenerator;
import com.google.code.beanmatchers.MockingTypeBasedValueGenerator;
import com.google.code.beanmatchers.ShortGenerator;
import com.google.code.beanmatchers.StringGenerator;
import com.google.code.beanmatchers.TypeBasedValueGenerator;
import com.google.code.beanmatchers.ValueGenerator;
import com.google.code.beanmatchers.ValueGeneratorRepository;
import java.util.Random;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BeanMatchers {
    private static final ValueGeneratorRepository VALUE_GENERATOR_REPOSTITORY;
    private static final TypeBasedValueGenerator TYPE_BASED_VALUE_GENERATOR;

    private BeanMatchers() {
    }

    @Factory
    public static Matcher<Class> hasValidGettersAndSettersFor(String ... properties) {
        return new InstantiatingMatcherDecorator(BeanMatchers.isABeanWithValidGettersAndSettersFor(properties));
    }

    @Factory
    public static <T> Matcher<T> isABeanWithValidGettersAndSettersFor(String ... properties) {
        return new HasValidGettersAndSettersMatcher(TYPE_BASED_VALUE_GENERATOR, properties);
    }

    @Factory
    public static Matcher<Class> hasValidGettersAndSettersExcluding(String ... properties) {
        return new InstantiatingMatcherDecorator(BeanMatchers.isABeanWithValidGettersAndSettersExcluding(properties));
    }

    @Factory
    public static <T> Matcher<T> isABeanWithValidGettersAndSettersExcluding(String ... properties) {
        return new HasValidGettersAndSettersExcludingMatcher(TYPE_BASED_VALUE_GENERATOR, properties);
    }

    @Factory
    public static Matcher<Class> hasValidGettersAndSetters() {
        return BeanMatchers.hasValidGettersAndSettersExcluding(new String[0]);
    }

    @Factory
    public static <T> Matcher<T> isABeanWithValidGettersAndSetters() {
        return BeanMatchers.isABeanWithValidGettersAndSettersExcluding(new String[0]);
    }

    @Factory
    public static Matcher<Class> hasValidBeanConstructor() {
        return new HasValidBeanConstructorMatcher();
    }

    @Factory
    public static Matcher<Class> hasValidBeanHashCode() {
        return new HasValidBeanHashCodeExcludingMatcher(TYPE_BASED_VALUE_GENERATOR, new String[0]);
    }

    @Factory
    public static Matcher<Class> hasValidBeanHashCodeFor(String ... properties) {
        return new HasValidBeanHashCodeForMatcher(TYPE_BASED_VALUE_GENERATOR, properties);
    }

    @Factory
    public static Matcher<Class> hasValidBeanHashCodeExcluding(String ... properties) {
        return new HasValidBeanHashCodeExcludingMatcher(TYPE_BASED_VALUE_GENERATOR, properties);
    }

    @Factory
    public static Matcher<Class> hasValidBeanEquals() {
        return new HasValidBeanEqualsExcludingMatcher(TYPE_BASED_VALUE_GENERATOR, new String[0]);
    }

    @Factory
    public static Matcher<Class> hasValidBeanEqualsFor(String ... properties) {
        return new HasValidBeanEqualsForMatcher(TYPE_BASED_VALUE_GENERATOR, properties);
    }

    @Factory
    public static Matcher<Class> hasValidBeanEqualsExcluding(String ... properties) {
        return new HasValidBeanEqualsExcludingMatcher(TYPE_BASED_VALUE_GENERATOR, properties);
    }

    @Factory
    public static Matcher<Class> hasValidBeanToString() {
        return new HasToStringDescribingPropertiesExcludingMatcher(TYPE_BASED_VALUE_GENERATOR, new String[0]);
    }

    @Factory
    public static Matcher<Class> hasValidBeanToStringFor(String ... properties) {
        return new HasToStringDescribingPropertiesMatcher(TYPE_BASED_VALUE_GENERATOR, properties);
    }

    @Factory
    public static Matcher<Class> hasValidBeanToStringExcluding(String ... properties) {
        return new HasToStringDescribingPropertiesExcludingMatcher(TYPE_BASED_VALUE_GENERATOR, properties);
    }

    public static <T> void registerValueGenerator(ValueGenerator<T> generator, Class<T> type) {
        VALUE_GENERATOR_REPOSTITORY.registerValueGenerator(generator, type);
    }

    static {
        Random random = new Random();
        VALUE_GENERATOR_REPOSTITORY = new InMemoryValueGeneratorRepository();
        VALUE_GENERATOR_REPOSTITORY.registerValueGenerator(new StringGenerator(), String.class);
        VALUE_GENERATOR_REPOSTITORY.registerValueGenerator(new IntegerGenerator(random), Integer.class, Integer.TYPE);
        VALUE_GENERATOR_REPOSTITORY.registerValueGenerator(new DoubleGenerator(random), Double.class, Double.TYPE);
        VALUE_GENERATOR_REPOSTITORY.registerValueGenerator(new BooleanGenerator(random), Boolean.class, Boolean.TYPE);
        VALUE_GENERATOR_REPOSTITORY.registerValueGenerator(new LongGenerator(random), Long.class, Long.TYPE);
        VALUE_GENERATOR_REPOSTITORY.registerValueGenerator(new FloatGenerator(random), Float.class, Float.TYPE);
        VALUE_GENERATOR_REPOSTITORY.registerValueGenerator(new ByteGenerator(random), Byte.class, Byte.TYPE);
        VALUE_GENERATOR_REPOSTITORY.registerValueGenerator(new CharacterGenerator(random), Character.class, Character.TYPE);
        VALUE_GENERATOR_REPOSTITORY.registerValueGenerator(new ShortGenerator(random), Short.class, Short.TYPE);
        ArrayTypeBasedValueGenerator arrayValueGenerator = new ArrayTypeBasedValueGenerator();
        TYPE_BASED_VALUE_GENERATOR = new DefaultTypeBasedValueGenerator(VALUE_GENERATOR_REPOSTITORY, new MockingTypeBasedValueGenerator(), new EnumBasedValueGenerator(random), arrayValueGenerator);
        arrayValueGenerator.setTypeBaseValueGenerator(TYPE_BASED_VALUE_GENERATOR);
    }
}

