/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.beanmatchers;

import com.google.code.beanmatchers.BeanMatchersException;
import com.google.code.beanmatchers.TypeBasedValueGenerator;
import com.google.code.beanmatchers.ValueGenerator;
import com.google.code.beanmatchers.ValueGeneratorRepository;
import java.lang.reflect.Modifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DefaultTypeBasedValueGenerator
implements TypeBasedValueGenerator {
    private final ValueGeneratorRepository valueGeneratorRepository;
    private final TypeBasedValueGenerator nonFinalTypeBasedValueGenerator;
    private final TypeBasedValueGenerator enumBasedValueGenerator;
    private final TypeBasedValueGenerator arrayValueGenerator;

    public DefaultTypeBasedValueGenerator(ValueGeneratorRepository valueGeneratorRepository, TypeBasedValueGenerator nonFinalTypeBasedValueGenerator, TypeBasedValueGenerator enumBasedValueGenerator, TypeBasedValueGenerator arrayValueGenerator) {
        this.valueGeneratorRepository = valueGeneratorRepository;
        this.nonFinalTypeBasedValueGenerator = nonFinalTypeBasedValueGenerator;
        this.enumBasedValueGenerator = enumBasedValueGenerator;
        this.arrayValueGenerator = arrayValueGenerator;
    }

    @Override
    public <T> T generate(Class<T> type) {
        ValueGenerator<T> generator = this.valueGeneratorRepository.retrieveValueGenerator(type);
        if (generator != null) {
            return generator.generate();
        }
        if (!Modifier.isFinal(type.getModifiers())) {
            return this.nonFinalTypeBasedValueGenerator.generate(type);
        }
        if (type.isEnum()) {
            return this.enumBasedValueGenerator.generate(type);
        }
        if (type.isArray()) {
            return this.arrayValueGenerator.generate(type);
        }
        throw new BeanMatchersException("Could not create a test value of type " + type.getName() + ".\nPlease register a ValueGenerator to create the value:\n" + "    BeanMatchers.registerValueGenerator(new ValueGenerator<" + type.getSimpleName() + ">() {\n" + "        public " + type.getSimpleName() + " generate() {\n" + "            return null;  // Change to generate random instance\n" + "        }\n" + "    }, " + type.getSimpleName() + ".class);");
    }
}

