/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.BugCollection;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.Project;
import edu.umd.cs.findbugs.SortedBugCollection;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import org.dom4j.DocumentException;

public class AddAnnotation {
    private BugCollection bugCollection;
    private Project project;
    private String annotation;

    public AddAnnotation(BugCollection bugCollection, Project project, String annotation) {
        this.bugCollection = bugCollection;
        this.project = project;
        this.annotation = annotation;
    }

    public AddAnnotation(String resultsFile, String annotation) throws IOException, DocumentException {
        this(new SortedBugCollection(), new Project(), annotation);
        this.bugCollection.readXML(resultsFile, this.project);
    }

    public BugCollection getBugCollection() {
        return this.bugCollection;
    }

    public Project getProject() {
        return this.project;
    }

    public void execute() {
        for (BugInstance bugInstance : this.bugCollection) {
            if (bugInstance.annotationTextContainsWord(this.annotation)) continue;
            String annotation = bugInstance.getAnnotationText();
            StringBuilder buf = new StringBuilder();
            if (!annotation.equals("")) {
                buf.append(annotation);
                buf.append('\n');
            }
            buf.append(this.annotation);
            bugInstance.setAnnotationText(buf.toString(), this.bugCollection);
        }
    }

    @SuppressWarnings(value={"DM_EXIT"})
    public static void main(String[] argv) throws Exception {
        if (argv.length != 2) {
            System.err.println("Usage: " + AddAnnotation.class.getName() + " <results file> <annotation>");
            System.exit(1);
        }
        String filename = argv[0];
        String annotation = argv[1];
        AddAnnotation addAnnotation = new AddAnnotation(filename, annotation);
        addAnnotation.execute();
        addAnnotation.getBugCollection().writeXML(filename, addAnnotation.getProject());
    }
}

