/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.AbstractBugReporter;
import edu.umd.cs.findbugs.BugCollection;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Project;
import edu.umd.cs.findbugs.SortedBugCollection;
import edu.umd.cs.findbugs.TextUIBugReporter;
import edu.umd.cs.findbugs.ba.Debug;
import edu.umd.cs.findbugs.ba.MethodUnprofitableException;
import edu.umd.cs.findbugs.ba.MissingClassException;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.userAnnotations.UserAnnotationPlugin;

public class BugCollectionBugReporter
extends TextUIBugReporter
implements Debug {
    private SortedBugCollection bugCollection;
    private Project project;

    public BugCollectionBugReporter(Project project) {
        this.project = project;
        this.bugCollection = new SortedBugCollection(this.getProjectStats());
        this.bugCollection.setTimestamp(System.currentTimeMillis());
    }

    public Project getProject() {
        return this.project;
    }

    public BugCollection getBugCollection() {
        return this.bugCollection;
    }

    public void observeClass(ClassDescriptor classDescriptor) {
    }

    public void logError(String message) {
        this.bugCollection.addError(message);
        super.logError(message);
    }

    public void logError(String message, Throwable e) {
        if (e instanceof MissingClassException) {
            MissingClassException e2 = (MissingClassException)e;
            this.reportMissingClass(e2.getClassNotFoundException());
            return;
        }
        if (e instanceof MethodUnprofitableException) {
            return;
        }
        this.bugCollection.addError(message, e);
        super.logError(message, e);
    }

    public void reportMissingClass(ClassNotFoundException ex) {
        String missing = AbstractBugReporter.getMissingClassName(ex);
        if (!BugCollectionBugReporter.isValidMissingClassMessage(missing)) {
            return;
        }
        this.bugCollection.addMissingClass(missing);
        super.reportMissingClass(ex);
    }

    public void doReportBug(BugInstance bugInstance) {
        if (VERIFY_INTEGRITY) {
            this.checkBugInstance(bugInstance);
        }
        if (this.bugCollection.add(bugInstance)) {
            this.notifyObservers(bugInstance);
        }
    }

    public BugReporter getRealBugReporter() {
        return this;
    }

    public void finish() {
        UserAnnotationPlugin userAnnotationPlugin = this.bugCollection.getUserAnnotationPlugin();
        if (userAnnotationPlugin != null) {
            userAnnotationPlugin.loadUserAnnotations(this.bugCollection);
        }
    }
}

