/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.BugCode;
import edu.umd.cs.findbugs.BugPattern;
import edu.umd.cs.findbugs.DetectorFactory;
import edu.umd.cs.findbugs.FindBugs;
import edu.umd.cs.findbugs.I18N;
import edu.umd.cs.findbugs.Plugin;
import edu.umd.cs.findbugs.PluginException;
import edu.umd.cs.findbugs.PluginLoader;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.util.ClassPathUtil;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DetectorFactoryCollection {
    private HashMap<String, Plugin> pluginByIdMap = new HashMap();
    private ArrayList<DetectorFactory> factoryList = new ArrayList();
    private HashMap<String, DetectorFactory> factoriesByName = new HashMap();
    private HashMap<String, DetectorFactory> factoriesByDetectorClassName = new HashMap();
    private static DetectorFactoryCollection theInstance;
    private static final Object lock;
    private boolean loaded = false;
    private URL[] pluginList;
    private static final Pattern[] findbugsJarNames;
    static final boolean DEBUG_JAWS = false;

    DetectorFactoryCollection() {
    }

    public void setPluginList(URL[] pluginList) {
        if (this.loaded) {
            throw new IllegalStateException();
        }
        this.pluginList = new URL[pluginList.length];
        System.arraycopy(pluginList, 0, this.pluginList, 0, pluginList.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setInstance(DetectorFactoryCollection instance) {
        Object object = lock;
        synchronized (object) {
            if (theInstance != null) {
                throw new IllegalStateException();
            }
            theInstance = instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void resetInstance(DetectorFactoryCollection instance) {
        Object object = lock;
        synchronized (object) {
            theInstance = instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DetectorFactoryCollection instance() {
        Object object = lock;
        synchronized (object) {
            if (theInstance == null) {
                theInstance = new DetectorFactoryCollection();
            }
            theInstance.ensureLoaded();
            return theInstance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DetectorFactoryCollection rawInstance() {
        Object object = lock;
        synchronized (object) {
            if (theInstance == null) {
                theInstance = new DetectorFactoryCollection();
            }
            return theInstance;
        }
    }

    public Iterator<Plugin> pluginIterator() {
        this.ensureLoaded();
        return this.pluginByIdMap.values().iterator();
    }

    public Plugin getPluginById(String pluginId) {
        this.ensureLoaded();
        return this.pluginByIdMap.get(pluginId);
    }

    public Iterator<DetectorFactory> factoryIterator() {
        this.ensureLoaded();
        return this.factoryList.iterator();
    }

    public DetectorFactory getFactory(String name) {
        this.ensureLoaded();
        return this.factoriesByName.get(name);
    }

    public DetectorFactory getFactoryByClassName(String className) {
        this.ensureLoaded();
        return this.factoriesByDetectorClassName.get(className);
    }

    void registerDetector(DetectorFactory factory) {
        if (FindBugs.DEBUG) {
            System.out.println("Registering detector: " + factory.getFullName());
        }
        String detectorName = factory.getShortName();
        this.factoryList.add(factory);
        this.factoriesByName.put(detectorName, factory);
        this.factoriesByDetectorClassName.put(factory.getFullName(), factory);
    }

    private void determinePlugins() {
        if (this.pluginList != null) {
            return;
        }
        String homeDir = DetectorFactoryCollection.getFindBugsHome();
        if (homeDir == null) {
            this.pluginList = new URL[0];
            return;
        }
        File pluginDir = new File(homeDir + File.separator + "plugin");
        File[] contentList = pluginDir.listFiles();
        if (contentList == null) {
            this.pluginList = new URL[0];
            return;
        }
        ArrayList<URL> arr = new ArrayList<URL>();
        for (File aContentList : contentList) {
            if (!aContentList.getName().endsWith(".jar")) continue;
            try {
                arr.add(aContentList.toURL());
                if (!FindBugs.DEBUG) continue;
                System.out.println("Found plugin: " + aContentList.toString());
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
        }
        this.pluginList = arr.toArray(new URL[arr.size()]);
    }

    private static String inferFindBugsHome() {
        for (Pattern jarNamePattern : findbugsJarNames) {
            File findbugsJar;
            File libDir;
            String findbugsJarCodeBase = ClassPathUtil.findCodeBaseInClassPath(jarNamePattern, SystemProperties.getProperty("java.class.path"));
            if (findbugsJarCodeBase == null || !(libDir = (findbugsJar = new File(findbugsJarCodeBase)).getParentFile()).getName().equals("lib")) continue;
            String fbHome = libDir.getParent();
            FindBugs.setHome(fbHome);
            return fbHome;
        }
        return null;
    }

    public static String getFindBugsHome() {
        String homeDir = FindBugs.getHome();
        if (homeDir == null) {
            homeDir = DetectorFactoryCollection.inferFindBugsHome();
        }
        return homeDir;
    }

    public void ensureLoaded() {
        if (this.loaded) {
            return;
        }
        this.loadPlugins();
    }

    void setPlugins(Plugin[] plugins) {
        if (this.loaded) {
            throw new IllegalStateException();
        }
        for (Plugin plugin : plugins) {
            this.pluginByIdMap.put(plugin.getPluginId(), plugin);
        }
        this.loaded = true;
    }

    void loadPlugins() {
        block12: {
            if (this.loaded) {
                throw new IllegalStateException();
            }
            if (SystemProperties.getBoolean("findbugs.jaws")) {
                String plugin;
                URL u = DetectorFactoryCollection.class.getResource("/findbugs.xml");
                String message = "Loading plugin from " + u;
                this.jawsDebugMessage(message);
                String findbugsJarCodeBase = ClassPathUtil.findCodeBaseInClassPath(findbugsJarNames[0], SystemProperties.getProperty("java.class.path"));
                this.jawsDebugMessage("findBugs jar code base = " + findbugsJarCodeBase);
                ArrayList<URL> plugins = new ArrayList<URL>();
                int i = 1;
                while ((plugin = SystemProperties.getProperty("findbugs.jaws.plugin" + i)) != null) {
                    try {
                        URL url = new URL(plugin);
                        URLConnection urlConnection = url.openConnection();
                        String type = urlConnection.getContentType();
                        this.jawsDebugMessage("plugin " + plugin + " has type " + type);
                        plugins.add(url);
                    }
                    catch (Exception e) {
                        this.jawsDebugMessage("Unable to load plugin " + plugin);
                    }
                    ++i;
                }
                this.setPluginList(plugins.toArray(new URL[plugins.size()]));
            }
            this.loaded = true;
            this.determinePlugins();
            PluginLoader corePluginLoader = new PluginLoader();
            try {
                this.loadPlugin(corePluginLoader);
            }
            catch (PluginException e) {
                System.err.println("Warning: could not load FindBugs core plugin: " + e.toString());
                if (!FindBugs.DEBUG) break block12;
                e.printStackTrace();
            }
        }
        for (final URL url : this.pluginList) {
            try {
                if (FindBugs.DEBUG) {
                    System.out.println("Loading plugin: " + url.toString());
                }
                PluginLoader pluginLoader = AccessController.doPrivileged(new PrivilegedExceptionAction<PluginLoader>(){

                    @Override
                    public PluginLoader run() throws PluginException {
                        return new PluginLoader(url, this.getClass().getClassLoader());
                    }
                });
                this.loadPlugin(pluginLoader);
            }
            catch (PluginException e) {
                System.err.println("Warning: could not load plugin " + url + ": " + e.toString());
                if (!FindBugs.DEBUG) continue;
                e.printStackTrace();
            }
            catch (PrivilegedActionException e) {
                System.err.println("Warning: could not load plugin " + url + ": " + e.toString());
                if (!FindBugs.DEBUG) continue;
                e.printStackTrace();
            }
        }
    }

    private void jawsDebugMessage(String message) {
    }

    private void loadPlugin(PluginLoader pluginLoader) throws PluginException {
        Plugin plugin = pluginLoader.getPlugin();
        this.pluginByIdMap.put(plugin.getPluginId(), plugin);
        Iterator<DetectorFactory> j = plugin.detectorFactoryIterator();
        while (j.hasNext()) {
            DetectorFactory factory = j.next();
            this.registerDetector(factory);
        }
        I18N i18n = I18N.instance();
        Iterator<Comparable<BugPattern>> j2 = plugin.bugPatternIterator();
        while (j2.hasNext()) {
            BugPattern bugPattern = j2.next();
            i18n.registerBugPattern(bugPattern);
        }
        j2 = plugin.bugCodeIterator();
        while (j2.hasNext()) {
            BugCode bugCode = (BugCode)j2.next();
            i18n.registerBugCode(bugCode);
        }
    }

    static {
        lock = new Object();
        findbugsJarNames = new Pattern[]{Pattern.compile("findbugs\\.jar$")};
    }
}

