/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.BugCategory;
import edu.umd.cs.findbugs.BugCode;
import edu.umd.cs.findbugs.BugPattern;
import edu.umd.cs.findbugs.DetectorFactoryCollection;
import edu.umd.cs.findbugs.L10N;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class I18N {
    private static final boolean DEBUG = SystemProperties.getBoolean("i18n.debug");
    public static final Comparator<String> designationKeyComparator = new DesignationKeyComparator();
    public static final Locale defaultLocale = Locale.getDefault();
    private final ResourceBundle annotationDescriptionBundle = ResourceBundle.getBundle("edu.umd.cs.findbugs.FindBugsAnnotationDescriptions", defaultLocale);
    private final ResourceBundle englishAnnotationDescriptionBundle = ResourceBundle.getBundle("edu.umd.cs.findbugs.FindBugsAnnotationDescriptions", Locale.ENGLISH);
    private final HashMap<String, BugCategory> categoryDescriptionMap = new HashMap();
    private final ResourceBundle userDesignationBundle = ResourceBundle.getBundle("edu.umd.cs.findbugs.UserDesignations", defaultLocale);
    private final HashMap<String, BugPattern> bugPatternMap = new HashMap();
    private final HashMap<String, BugCode> bugCodeMap = new HashMap();
    private static final I18N theInstance = new I18N();

    private I18N() {
    }

    public static I18N instance() {
        return theInstance;
    }

    public void registerBugPattern(BugPattern bugPattern) {
        this.bugPatternMap.put(bugPattern.getType(), bugPattern);
    }

    @CheckForNull
    public BugPattern lookupBugPattern(String bugType) {
        DetectorFactoryCollection.instance();
        return this.bugPatternMap.get(bugType);
    }

    public Iterator<BugPattern> bugPatternIterator() {
        DetectorFactoryCollection.instance();
        return this.bugPatternMap.values().iterator();
    }

    public Iterator<BugCode> bugCodeIterator() {
        DetectorFactoryCollection.instance();
        return this.bugCodeMap.values().iterator();
    }

    public void registerBugCode(BugCode bugCode) {
        this.bugCodeMap.put(bugCode.getAbbrev(), bugCode);
    }

    @Deprecated
    @NonNull
    public String getMessage(String key) {
        BugPattern bugPattern = this.bugPatternMap.get(key);
        if (bugPattern == null) {
            return L10N.getLocalString("err.missing_pattern", "Error: missing bug pattern for key") + " " + key;
        }
        return bugPattern.getAbbrev() + ": " + bugPattern.getLongDescription();
    }

    @NonNull
    public String getShortMessage(String key) {
        BugPattern bugPattern = this.bugPatternMap.get(key);
        if (bugPattern == null) {
            return L10N.getLocalString("err.missing_pattern", "Error: missing bug pattern for key") + " " + key;
        }
        return bugPattern.getAbbrev() + ": " + bugPattern.getShortDescription();
    }

    @NonNull
    public String getShortMessageWithoutCode(String key) {
        BugPattern bugPattern = this.bugPatternMap.get(key);
        if (bugPattern == null) {
            return L10N.getLocalString("err.missing_pattern", "Error: missing bug pattern for key") + " " + key;
        }
        return bugPattern.getShortDescription();
    }

    @NonNull
    public String getDetailHTML(String key) {
        BugPattern bugPattern = this.bugPatternMap.get(key);
        if (bugPattern == null) {
            return L10N.getLocalString("err.missing_pattern", "Error: missing bug pattern for key") + " " + key;
        }
        return bugPattern.getDetailHTML();
    }

    public String getAnnotationDescription(String key) {
        try {
            return this.annotationDescriptionBundle.getString(key);
        }
        catch (MissingResourceException mre) {
            if (DEBUG) {
                return "TRANSLATE(key=" + key + ") (param={0}}";
            }
            try {
                return this.englishAnnotationDescriptionBundle.getString(key);
            }
            catch (MissingResourceException mre2) {
                return key;
            }
        }
    }

    public BugCode getBugCode(String shortBugType) {
        BugCode bugCode = this.bugCodeMap.get(shortBugType);
        if (bugCode == null) {
            throw new IllegalArgumentException("Error: missing bug code for key" + shortBugType);
        }
        return bugCode;
    }

    @NonNull
    public String getBugTypeDescription(String shortBugType) {
        BugCode bugCode = this.bugCodeMap.get(shortBugType);
        if (bugCode == null) {
            return L10N.getLocalString("err.missing_code", "Error: missing bug code for key") + " " + shortBugType;
        }
        return bugCode.getDescription();
    }

    public boolean registerBugCategory(String category, BugCategory bc) {
        if (this.categoryDescriptionMap.get(category) != null) {
            return false;
        }
        this.categoryDescriptionMap.put(category, bc);
        return true;
    }

    public BugCategory getBugCategory(String category) {
        return this.categoryDescriptionMap.get(category);
    }

    public String getBugCategoryDescription(String category) {
        BugCategory bc = this.categoryDescriptionMap.get(category);
        return bc != null ? bc.getShortDescription() : category;
    }

    public Collection<String> getBugCategories() {
        DetectorFactoryCollection.instance();
        return this.categoryDescriptionMap.keySet();
    }

    public Collection<BugCategory> getBugCategoryObjects() {
        DetectorFactoryCollection.instance();
        return this.categoryDescriptionMap.values();
    }

    public String getUserDesignation(String key) {
        return this.userDesignationBundle.getString(key);
    }

    public List<String> getUserDesignationKeys() {
        LinkedList<String> result = new LinkedList<String>();
        Enumeration<String> e = this.userDesignationBundle.getKeys();
        while (e.hasMoreElements()) {
            String key = e.nextElement();
            result.add(key);
        }
        return result;
    }

    public List<String> getUserDesignationKeys(boolean sort) {
        List<String> result = this.getUserDesignationKeys();
        if (sort) {
            Collections.sort(result, designationKeyComparator);
        }
        return result;
    }

    public String getUserDesignationKey(int index) {
        List<String> keys = this.getUserDesignationKeys(true);
        return keys.get(index);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DesignationKeyComparator
    implements Comparator<String>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private DesignationKeyComparator() {
        }

        @Override
        public int compare(String lKey, String rKey) {
            int lCat = DesignationKeyComparator.categoryOf(lKey);
            int catDiff = lCat - DesignationKeyComparator.categoryOf(rKey);
            if (catDiff != 0 || lCat != 0) {
                return catDiff;
            }
            return lKey.compareTo(rKey);
        }

        private static int categoryOf(String key) {
            if (key == null) {
                return -30;
            }
            if (key.length() <= 0) {
                return -29;
            }
            switch (key.charAt(0)) {
                case 'U': {
                    if (!"UNCLASSIFIED".equals(key)) break;
                    return 20;
                }
                case 'B': {
                    if (!"BAD_ANALYSIS".equals(key)) break;
                    return 15;
                }
                case 'N': {
                    if ("NEEDS_STUDY".equals(key)) {
                        return -22;
                    }
                    if (!"NOT_A_BUG".equals(key)) break;
                    return -15;
                }
                case 'O': {
                    if (!"OBSOLETE_CODE".equals(key)) break;
                    return 30;
                }
                case 'M': {
                    if ("MOSTLY_HARMLESS".equals(key)) {
                        return -10;
                    }
                    if (!"MUST_FIX".equals(key)) break;
                    return 10;
                }
                case 'S': {
                    if (!"SHOULD_FIX".equals(key)) break;
                    return 5;
                }
            }
            return 0;
        }
    }
}

