/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.CheckBcel;
import edu.umd.cs.findbugs.FindBugs2;
import edu.umd.cs.findbugs.ShowHelp;
import edu.umd.cs.findbugs.Version;
import edu.umd.cs.findbugs.gui.FindBugsFrame;
import java.awt.GraphicsEnvironment;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class LaunchAppropriateUI {
    public static final int TEXTUI = 0;
    public static final int GUI1 = 1;
    public static final int GUI2 = 2;
    public static final int SHOW_HELP = 1000;
    public static final int SHOW_VERSION = 1001;
    public static final Map<String, Integer> uiNameToCodeMap = new HashMap<String, Integer>();
    private String[] args;

    public LaunchAppropriateUI(String[] args) {
        this.args = args;
    }

    public void launch() throws Exception {
        if (!CheckBcel.check()) {
            System.exit(1);
        }
        int launchProperty = this.getLaunchProperty();
        if (GraphicsEnvironment.isHeadless() || launchProperty == 0) {
            FindBugs2.main(this.args);
        } else if (launchProperty == 1000) {
            ShowHelp.main(this.args);
        } else if (launchProperty == 1001) {
            Version.main(new String[]{"-release"});
        } else {
            String version = System.getProperty("java.version");
            Class launchClass = null;
            if ("1.5".compareTo(version) <= 0) {
                try {
                    launchClass = Class.forName("edu.umd.cs.findbugs.gui2.Driver", false, LaunchAppropriateUI.class.getClassLoader());
                }
                catch (ClassNotFoundException e) {
                    // empty catch block
                }
            }
            if (launchClass == null || launchProperty == 1) {
                launchClass = FindBugsFrame.class;
            }
            Method mainMethod = launchClass.getMethod("main", this.args.getClass());
            mainMethod.invoke(null, new Object[]{this.args});
        }
    }

    private int getLaunchProperty() {
        String uiName;
        String firstArg;
        if (this.args.length > 0 && (firstArg = this.args[0]).startsWith("-") && uiNameToCodeMap.containsKey(uiName = firstArg.substring(1))) {
            String[] modifiedArgs = new String[this.args.length - 1];
            System.arraycopy(this.args, 1, modifiedArgs, 0, this.args.length - 1);
            this.args = modifiedArgs;
            return uiNameToCodeMap.get(uiName);
        }
        for (String a : this.args) {
            if (!a.equals("-output") && !a.equals("-xml")) continue;
            return 0;
        }
        String s = System.getProperty("findbugs.launchUI", "gui2");
        if (uiNameToCodeMap.containsKey(s)) {
            return uiNameToCodeMap.get(s);
        }
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException nfe) {
            return 2;
        }
    }

    public static void main(String[] args) throws Exception {
        LaunchAppropriateUI launcher = new LaunchAppropriateUI(args);
        launcher.launch();
    }

    static {
        uiNameToCodeMap.put("textui", 0);
        uiNameToCodeMap.put("gui", 2);
        uiNameToCodeMap.put("gui1", 1);
        uiNameToCodeMap.put("gui2", 2);
        uiNameToCodeMap.put("help", 1000);
        uiNameToCodeMap.put("version", 1001);
    }
}

