/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.FieldAnnotation;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.ClassMember;
import edu.umd.cs.findbugs.ba.FieldSummary;
import edu.umd.cs.findbugs.ba.XFactory;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.Global;
import edu.umd.cs.findbugs.classfile.IAnalysisCache;
import edu.umd.cs.findbugs.classfile.MethodDescriptor;
import edu.umd.cs.findbugs.classfile.engine.bcel.AnalysisFactory;
import edu.umd.cs.findbugs.internalAnnotations.SlashedClassName;
import edu.umd.cs.findbugs.util.ClassName;
import edu.umd.cs.findbugs.util.Util;
import edu.umd.cs.findbugs.visitclass.Constants2;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.LVTHelper;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.meta.TypeQualifier;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.CodeException;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantClass;
import org.apache.bcel.classfile.ConstantDouble;
import org.apache.bcel.classfile.ConstantFloat;
import org.apache.bcel.classfile.ConstantInteger;
import org.apache.bcel.classfile.ConstantLong;
import org.apache.bcel.classfile.ConstantString;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.LocalVariable;
import org.apache.bcel.classfile.LocalVariableTable;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.BasicType;
import org.apache.bcel.generic.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpcodeStack
implements Constants2 {
    private static final String JAVA_UTIL_ARRAYS_ARRAY_LIST = "Ljava/util/Arrays$ArrayList;";
    private static final boolean DEBUG;
    private static final boolean DEBUG2;
    private List<Item> stack;
    private List<Item> lvValues;
    private List<Integer> lastUpdate;
    private boolean top;
    private boolean seenTransferOfControl = false;
    private boolean useIterativeAnalysis = AnalysisContext.currentAnalysisContext().getBoolProperty(4);
    boolean needToMerge = true;
    private boolean reachOnlyByBranch = false;
    int convertJumpToOneZeroState = 0;
    int convertJumpToZeroOneState = 0;
    int registerTestedFoundToBeNonnegative = -1;
    int zeroOneComing = -1;
    boolean oneMeansNull;
    boolean encountedTop;
    boolean backwardsBranch;
    BitSet exceptionHandlers = new BitSet();
    private Map<Integer, List<Item>> jumpEntries = new HashMap<Integer, List<Item>>();
    private Map<Integer, List<Item>> jumpStackEntries = new HashMap<Integer, List<Item>>();
    private BitSet jumpEntryLocations = new BitSet();
    private String methodName;
    DismantleBytecode v;

    public String toString() {
        if (this.isTop()) {
            return "TOP";
        }
        return this.stack.toString() + "::" + this.lvValues.toString();
    }

    public OpcodeStack() {
        this.stack = new ArrayList<Item>();
        this.lvValues = new ArrayList<Item>();
        this.lastUpdate = new ArrayList<Integer>();
    }

    public static String getExceptionSig(DismantleBytecode dbc, CodeException e) {
        if (e.getCatchType() == 0) {
            return "Ljava/lang/Throwable;";
        }
        Constant c = dbc.getConstantPool().getConstant(e.getCatchType());
        if (c instanceof ConstantClass) {
            return "L" + ((ConstantClass)c).getBytes(dbc.getConstantPool()) + ";";
        }
        return "Ljava/lang/Throwable;";
    }

    public void mergeJumps(DismantleBytecode dbc) {
        if (!this.needToMerge) {
            return;
        }
        this.needToMerge = false;
        if (dbc.getPC() == this.zeroOneComing) {
            this.pop();
            this.top = false;
            Item item = new Item("I");
            if (this.oneMeansNull) {
                item.setSpecialKind(18);
            } else {
                item.setSpecialKind(17);
            }
            item.setPC(dbc.getPC() - 8);
            item.setCouldBeZero(true);
            this.push(item);
            this.zeroOneComing = -1;
            if (DEBUG) {
                System.out.println("Updated to " + this);
            }
            return;
        }
        boolean stackUpdated = false;
        if (!(this.isTop() || this.convertJumpToOneZeroState != 3 && this.convertJumpToZeroOneState != 3)) {
            this.pop();
            Item topItem = new Item("I");
            topItem.setCouldBeZero(true);
            this.push(topItem);
            this.convertJumpToZeroOneState = 0;
            this.convertJumpToOneZeroState = 0;
            stackUpdated = true;
        }
        List<Item> jumpEntry = null;
        if (this.jumpEntryLocations.get(dbc.getPC())) {
            jumpEntry = this.jumpEntries.get(dbc.getPC());
        }
        if (jumpEntry != null) {
            this.setReachOnlyByBranch(false);
            List<Item> jumpStackEntry = this.jumpStackEntries.get(dbc.getPC());
            if (DEBUG2) {
                System.out.println("XXXXXXX " + this.isReachOnlyByBranch());
                System.out.println("merging lvValues at jump target " + dbc.getPC() + " -> " + jumpEntry);
                System.out.println(" current lvValues " + this.lvValues);
                System.out.println(" merging stack entry " + jumpStackEntry);
                System.out.println(" current stack values " + this.stack);
            }
            if (this.isTop()) {
                this.lvValues = new ArrayList<Item>(jumpEntry);
                if (jumpStackEntry != null) {
                    this.stack = new ArrayList<Item>(jumpStackEntry);
                } else {
                    this.stack.clear();
                }
                this.setTop(false);
                return;
            }
            if (this.isReachOnlyByBranch()) {
                this.setTop(false);
                this.lvValues = new ArrayList<Item>(jumpEntry);
                if (!stackUpdated) {
                    if (jumpStackEntry != null) {
                        this.stack = new ArrayList<Item>(jumpStackEntry);
                    } else {
                        this.stack.clear();
                    }
                }
            } else {
                this.setTop(false);
                this.mergeLists(this.lvValues, jumpEntry, false);
                if (!stackUpdated && jumpStackEntry != null) {
                    this.mergeLists(this.stack, jumpStackEntry, false);
                }
            }
            if (DEBUG) {
                System.out.println(" merged lvValues " + this.lvValues);
            }
        } else if (this.isReachOnlyByBranch() && !stackUpdated) {
            this.stack.clear();
            for (CodeException e : dbc.getCode().getExceptionTable()) {
                if (e.getHandlerPC() != dbc.getPC()) continue;
                this.push(new Item(OpcodeStack.getExceptionSig(dbc, e)));
                this.setReachOnlyByBranch(false);
                this.setTop(false);
                return;
            }
            this.setTop(true);
        }
    }

    private void setLastUpdate(int reg, int pc) {
        while (this.lastUpdate.size() <= reg) {
            this.lastUpdate.add(0);
        }
        this.lastUpdate.set(reg, pc);
    }

    public int getLastUpdate(int reg) {
        if (this.lastUpdate.size() <= reg) {
            return 0;
        }
        return this.lastUpdate.get(reg);
    }

    public int getNumLastUpdates() {
        return this.lastUpdate.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void sawOpcode(DismantleBytecode dbc, int seen) {
        if (dbc.isRegisterStore()) {
            this.setLastUpdate(dbc.getRegisterOperand(), dbc.getPC());
        }
        this.precomputation(dbc);
        this.needToMerge = true;
        try {
            int nextPC;
            if (this.isTop()) {
                this.encountedTop = true;
                return;
            }
            if (seen == 167 && (nextPC = dbc.getPC() + 3) <= dbc.getMaxPC()) {
                int prevOpcode1 = dbc.getPrevOpcode(1);
                int prevOpcode2 = dbc.getPrevOpcode(2);
                int nextOpcode = dbc.getCodeByte(dbc.getPC() + 3);
                if (!(prevOpcode1 != 3 && prevOpcode1 != 4 || prevOpcode2 != 198 && prevOpcode2 != 199 || nextOpcode != 3 && nextOpcode != 4 || prevOpcode1 == nextOpcode)) {
                    boolean bl = this.oneMeansNull = prevOpcode1 == 3;
                    if (prevOpcode2 != 198) {
                        this.oneMeansNull = !this.oneMeansNull;
                    }
                    this.zeroOneComing = nextPC + 1;
                    this.convertJumpToZeroOneState = 0;
                    this.convertJumpToOneZeroState = 0;
                }
            }
            switch (seen) {
                case 4: {
                    this.convertJumpToOneZeroState = 1;
                    break;
                }
                case 167: {
                    if (this.convertJumpToOneZeroState == 1 && dbc.getBranchOffset() == 4) {
                        this.convertJumpToOneZeroState = 2;
                        break;
                    }
                    this.convertJumpToOneZeroState = 0;
                    break;
                }
                case 3: {
                    if (this.convertJumpToOneZeroState == 2) {
                        this.convertJumpToOneZeroState = 3;
                        break;
                    }
                    this.convertJumpToOneZeroState = 0;
                    break;
                }
                default: {
                    this.convertJumpToOneZeroState = 0;
                }
            }
            switch (seen) {
                case 3: {
                    this.convertJumpToZeroOneState = 1;
                    break;
                }
                case 167: {
                    if (this.convertJumpToZeroOneState == 1 && dbc.getBranchOffset() == 4) {
                        this.convertJumpToZeroOneState = 2;
                        break;
                    }
                    this.convertJumpToZeroOneState = 0;
                    break;
                }
                case 4: {
                    if (this.convertJumpToZeroOneState == 2) {
                        this.convertJumpToZeroOneState = 3;
                        break;
                    }
                    this.convertJumpToZeroOneState = 0;
                    break;
                }
                default: {
                    this.convertJumpToZeroOneState = 0;
                }
            }
            switch (seen) {
                case 25: {
                    this.pushByLocalObjectLoad(dbc, dbc.getRegisterOperand());
                    return;
                }
                case 42: 
                case 43: 
                case 44: 
                case 45: {
                    this.pushByLocalObjectLoad(dbc, seen - 42);
                    return;
                }
                case 24: {
                    this.pushByLocalLoad("D", dbc.getRegisterOperand());
                    return;
                }
                case 38: 
                case 39: 
                case 40: 
                case 41: {
                    this.pushByLocalLoad("D", seen - 38);
                    return;
                }
                case 23: {
                    this.pushByLocalLoad("F", dbc.getRegisterOperand());
                    return;
                }
                case 34: 
                case 35: 
                case 36: 
                case 37: {
                    this.pushByLocalLoad("F", seen - 34);
                    return;
                }
                case 21: {
                    this.pushByLocalLoad("I", dbc.getRegisterOperand());
                    return;
                }
                case 26: 
                case 27: 
                case 28: 
                case 29: {
                    this.pushByLocalLoad("I", seen - 26);
                    return;
                }
                case 22: {
                    this.pushByLocalLoad("J", dbc.getRegisterOperand());
                    return;
                }
                case 30: 
                case 31: 
                case 32: 
                case 33: {
                    this.pushByLocalLoad("J", seen - 30);
                    return;
                }
                case 178: {
                    Item item;
                    FieldSummary fieldSummary = AnalysisContext.currentAnalysisContext().getFieldSummary();
                    XField fieldOperand = dbc.getXFieldOperand();
                    if (fieldOperand != null && fieldSummary.isComplete() && !fieldOperand.isPublic() && (item = fieldSummary.getSummary(fieldOperand)) != null) {
                        Item itm = new Item(item);
                        itm.setLoadedFromField(fieldOperand, Integer.MAX_VALUE);
                        this.push(itm);
                        return;
                    } else {
                        FieldAnnotation field = FieldAnnotation.fromReferencedField(dbc);
                        Item i = new Item(dbc.getSigConstantOperand(), field, Integer.MAX_VALUE);
                        if (field.getFieldName().equals("separator") && field.getClassName().equals("java.io.File")) {
                            i.setSpecialKind(10);
                        }
                        this.push(i);
                        return;
                    }
                }
                case 18: 
                case 19: 
                case 20: {
                    Constant cons = dbc.getConstantRefOperand();
                    this.pushByConstant(dbc, cons);
                    return;
                }
                case 193: {
                    this.pop();
                    this.push(new Item("I"));
                    return;
                }
                case 153: 
                case 154: 
                case 155: 
                case 156: 
                case 157: 
                case 158: 
                case 198: 
                case 199: {
                    this.seenTransferOfControl = true;
                    Item topItem = this.pop();
                    if (seen == 155 || seen == 158) {
                        this.registerTestedFoundToBeNonnegative = topItem.registerNumber;
                    }
                    if (topItem.valueCouldBeNegative() && (seen == 155 || seen == 158 || seen == 157 || seen == 156)) {
                        int specialKind = topItem.getSpecialKind();
                        for (Item item : this.stack) {
                            if (item == null || item.getSpecialKind() != specialKind) continue;
                            item.setSpecialKind(0);
                        }
                        for (Item item : this.lvValues) {
                            if (item == null || item.getSpecialKind() != specialKind) continue;
                            item.setSpecialKind(0);
                        }
                    }
                    this.addJumpValue(dbc.getPC(), dbc.getBranchTarget());
                    return;
                }
                case 170: 
                case 171: {
                    this.seenTransferOfControl = true;
                    this.setReachOnlyByBranch(true);
                    this.pop();
                    this.addJumpValue(dbc.getPC(), dbc.getBranchTarget());
                    int pc = dbc.getBranchTarget() - dbc.getBranchOffset();
                    for (int offset : dbc.getSwitchOffsets()) {
                        this.addJumpValue(dbc.getPC(), offset + pc);
                    }
                    return;
                }
                case 172: 
                case 173: 
                case 174: 
                case 175: 
                case 176: {
                    this.seenTransferOfControl = true;
                    this.setReachOnlyByBranch(true);
                    this.pop();
                    return;
                }
                case 87: 
                case 179: 
                case 194: 
                case 195: {
                    this.pop();
                    return;
                }
                case 159: 
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 164: 
                case 165: 
                case 166: {
                    this.seenTransferOfControl = true;
                    Item right = this.pop();
                    Item left = this.pop();
                    if (right.hasConstantValue(Integer.MIN_VALUE) && left.checkForIntegerMinValue() || left.hasConstantValue(Integer.MIN_VALUE) && right.checkForIntegerMinValue()) {
                        for (Item i : this.stack) {
                            if (i == null || !i.checkForIntegerMinValue()) continue;
                            i.setSpecialKind(0);
                        }
                        for (Item i : this.lvValues) {
                            if (i == null || !i.checkForIntegerMinValue()) continue;
                            i.setSpecialKind(0);
                        }
                    }
                    int branchTarget = dbc.getBranchTarget();
                    this.addJumpValue(dbc.getPC(), branchTarget);
                    return;
                }
                case 88: {
                    Item it = this.pop();
                    if (it.getSize() != 1) return;
                    this.pop();
                    return;
                }
                case 181: {
                    this.pop(2);
                    return;
                }
                case 46: 
                case 53: {
                    this.pop(2);
                    this.push(new Item("I"));
                    return;
                }
                case 89: {
                    this.handleDup();
                    return;
                }
                case 92: {
                    this.handleDup2();
                    return;
                }
                case 90: {
                    this.handleDupX1();
                    return;
                }
                case 91: {
                    this.handleDupX2();
                    return;
                }
                case 93: {
                    this.handleDup2X1();
                    return;
                }
                case 94: {
                    this.handleDup2X2();
                    return;
                }
                case 132: {
                    int register = dbc.getRegisterOperand();
                    Item it = this.getLVValue(register);
                    Item it2 = new Item("I", dbc.getIntConstant());
                    this.pushByIntMath(dbc, 96, it2, it);
                    this.pushByLocalStore(register);
                    return;
                }
                case 191: {
                    this.pop();
                    this.seenTransferOfControl = true;
                    this.setReachOnlyByBranch(true);
                    this.setTop(true);
                    return;
                }
                case 192: {
                    String castTo = dbc.getClassConstantOperand();
                    if (castTo.charAt(0) != '[') {
                        castTo = "L" + castTo + ";";
                    }
                    Item it = new Item(this.pop());
                    it.signature = castTo;
                    this.push(it);
                    return;
                }
                case 0: {
                    return;
                }
                case 169: 
                case 177: {
                    this.seenTransferOfControl = true;
                    this.setReachOnlyByBranch(true);
                    return;
                }
                case 167: 
                case 200: {
                    this.seenTransferOfControl = true;
                    this.setReachOnlyByBranch(true);
                    this.addJumpValue(dbc.getPC(), dbc.getBranchTarget());
                    this.stack.clear();
                    this.setTop(true);
                    return;
                }
                case 95: {
                    this.handleSwap();
                    return;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    this.push(new Item("I", seen - 3));
                    return;
                }
                case 9: 
                case 10: {
                    this.push(new Item("J", (Object)(seen - 9)));
                    return;
                }
                case 14: 
                case 15: {
                    this.push(new Item("D", (Object)(seen - 14)));
                    return;
                }
                case 11: 
                case 12: 
                case 13: {
                    this.push(new Item("F", Float.valueOf(seen - 11)));
                    return;
                }
                case 1: {
                    this.push(new Item());
                    return;
                }
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: {
                    this.pushByLocalStore(dbc.getRegisterOperand());
                    return;
                }
                case 75: 
                case 76: 
                case 77: 
                case 78: {
                    this.pushByLocalStore(seen - 75);
                    return;
                }
                case 71: 
                case 72: 
                case 73: 
                case 74: {
                    this.pushByLocalStore(seen - 71);
                    return;
                }
                case 67: 
                case 68: 
                case 69: 
                case 70: {
                    this.pushByLocalStore(seen - 67);
                    return;
                }
                case 59: 
                case 60: 
                case 61: 
                case 62: {
                    this.pushByLocalStore(seen - 59);
                    return;
                }
                case 63: 
                case 64: 
                case 65: 
                case 66: {
                    this.pushByLocalStore(seen - 63);
                    return;
                }
                case 180: {
                    Item item;
                    FieldSummary fieldSummary = AnalysisContext.currentAnalysisContext().getFieldSummary();
                    XField fieldOperand = dbc.getXFieldOperand();
                    if (fieldOperand != null && fieldSummary.isComplete() && !fieldOperand.isPublic() && (item = fieldSummary.getSummary(fieldOperand)) != null) {
                        Item addr = this.pop();
                        Item itm = new Item(item);
                        itm.setLoadedFromField(fieldOperand, addr.getRegisterNumber());
                        this.push(itm);
                        return;
                    } else {
                        item = this.pop();
                        int reg = item.getRegisterNumber();
                        this.push(new Item(dbc.getSigConstantOperand(), FieldAnnotation.fromReferencedField(dbc), reg));
                        return;
                    }
                }
                case 190: {
                    this.pop();
                    Item newItem = new Item("I");
                    newItem.setSpecialKind(12);
                    this.push(newItem);
                    return;
                }
                case 51: {
                    this.pop(2);
                    Item newItem = new Item("I");
                    newItem.setSpecialKind(1);
                    this.push(newItem);
                    return;
                }
                case 52: {
                    this.pop(2);
                    this.push(new Item("I"));
                    return;
                }
                case 49: {
                    this.pop(2);
                    this.push(new Item("D"));
                    return;
                }
                case 48: {
                    this.pop(2);
                    this.push(new Item("F"));
                    return;
                }
                case 47: {
                    this.pop(2);
                    this.push(new Item("J"));
                    return;
                }
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: {
                    this.pop(3);
                    return;
                }
                case 16: 
                case 17: {
                    this.push(new Item("I", (Object)dbc.getIntConstant()));
                    return;
                }
                case 96: 
                case 100: 
                case 104: 
                case 108: 
                case 112: 
                case 120: 
                case 122: 
                case 124: 
                case 126: 
                case 128: 
                case 130: {
                    Item it = this.pop();
                    Item it2 = this.pop();
                    this.pushByIntMath(dbc, seen, it2, it);
                    return;
                }
                case 116: {
                    Item it = this.pop();
                    if (it.getConstant() instanceof Integer) {
                        this.push(new Item("I", (Object)(-this.constantToInt(it))));
                        return;
                    } else {
                        this.push(new Item("I"));
                        return;
                    }
                }
                case 117: {
                    Item it = this.pop();
                    if (it.getConstant() instanceof Long) {
                        this.push(new Item("J", -this.constantToLong(it)));
                        return;
                    } else {
                        this.push(new Item("J"));
                        return;
                    }
                }
                case 118: {
                    Item it = this.pop();
                    if (it.getConstant() instanceof Float) {
                        this.push(new Item("F", Float.valueOf(-this.constantToFloat(it))));
                        return;
                    } else {
                        this.push(new Item("F"));
                        return;
                    }
                }
                case 119: {
                    Item it = this.pop();
                    if (it.getConstant() instanceof Double) {
                        this.push(new Item("D", -this.constantToDouble(it)));
                        return;
                    } else {
                        this.push(new Item("D"));
                        return;
                    }
                }
                case 97: 
                case 101: 
                case 105: 
                case 109: 
                case 113: 
                case 121: 
                case 123: 
                case 125: 
                case 127: 
                case 129: 
                case 131: {
                    Item it = this.pop();
                    Item it2 = this.pop();
                    this.pushByLongMath(seen, it2, it);
                    return;
                }
                case 148: {
                    this.handleLcmp();
                    return;
                }
                case 149: 
                case 150: {
                    this.handleFcmp(seen);
                    return;
                }
                case 151: 
                case 152: {
                    this.handleDcmp(seen);
                    return;
                }
                case 98: 
                case 102: 
                case 106: 
                case 110: 
                case 114: {
                    Item it = this.pop();
                    Item it2 = this.pop();
                    this.pushByFloatMath(seen, it, it2);
                    return;
                }
                case 99: 
                case 103: 
                case 107: 
                case 111: 
                case 115: {
                    Item it = this.pop();
                    Item it2 = this.pop();
                    this.pushByDoubleMath(seen, it, it2);
                    return;
                }
                case 145: {
                    Item it = this.pop();
                    it = it.getConstant() != null ? new Item("I", (int)((byte)this.constantToInt(it))) : new Item("I");
                    it.setSpecialKind(1);
                    this.push(it);
                    return;
                }
                case 146: {
                    Item it = this.pop();
                    it = it.getConstant() != null ? new Item("I", (int)((char)this.constantToInt(it))) : new Item("I");
                    it.setSpecialKind(12);
                    this.push(it);
                    return;
                }
                case 133: 
                case 140: 
                case 143: {
                    Item it = this.pop();
                    Item newValue = it.getConstant() != null ? new Item("J", this.constantToLong(it)) : new Item("J");
                    newValue.setSpecialKind(it.getSpecialKind());
                    this.push(newValue);
                    return;
                }
                case 147: {
                    Item it = this.pop();
                    if (it.getConstant() != null) {
                        this.push(new Item("I", (int)((short)this.constantToInt(it))));
                        return;
                    } else {
                        this.push(new Item("I"));
                        return;
                    }
                }
                case 136: 
                case 139: 
                case 142: {
                    Item it = this.pop();
                    if (it.getConstant() != null) {
                        this.push(new Item("I", this.constantToInt(it)));
                        return;
                    } else {
                        this.push(new Item("I"));
                        return;
                    }
                }
                case 134: 
                case 137: 
                case 144: {
                    Item it = this.pop();
                    if (it.getConstant() != null) {
                        this.push(new Item("F", Float.valueOf(this.constantToFloat(it))));
                        return;
                    } else {
                        this.push(new Item("F"));
                        return;
                    }
                }
                case 135: 
                case 138: 
                case 141: {
                    Item it = this.pop();
                    if (it.getConstant() != null) {
                        this.push(new Item("D", this.constantToDouble(it)));
                        return;
                    } else {
                        this.push(new Item("D"));
                        return;
                    }
                }
                case 187: {
                    Item item = new Item("L" + dbc.getClassConstantOperand() + ";", (Object)null);
                    item.setSpecialKind(16);
                    this.push(item);
                    return;
                }
                case 188: {
                    this.pop();
                    String signature = "[" + BasicType.getType((byte)((byte)dbc.getIntConstant())).getSignature();
                    this.pushBySignature(signature, dbc);
                    return;
                }
                case 189: {
                    this.pop();
                    String signature = dbc.getClassConstantOperand();
                    signature = signature.charAt(0) == '[' ? "[" + signature : "[L" + signature + ";";
                    this.pushBySignature(signature, dbc);
                    return;
                }
                case 197: {
                    int dims = dbc.getIntConstant();
                    for (int i = 0; i < dims; ++i) {
                        this.pop();
                    }
                    String signature = dbc.getClassConstantOperand();
                    this.pushBySignature(signature, dbc);
                    return;
                }
                case 50: {
                    this.pop();
                    Item it = this.pop();
                    String arraySig = it.getSignature();
                    if (arraySig.charAt(0) == '[') {
                        this.pushBySignature(arraySig.substring(1), dbc);
                        return;
                    } else {
                        this.push(new Item());
                        return;
                    }
                }
                case 168: {
                    this.seenTransferOfControl = true;
                    this.setReachOnlyByBranch(false);
                    this.push(new Item(""));
                    this.addJumpValue(dbc.getPC(), dbc.getBranchTarget());
                    this.pop();
                    if (dbc.getBranchOffset() < 0) {
                        int stackSize = this.stack.size();
                        this.stack.clear();
                        for (int i = 0; i < stackSize; ++i) {
                            this.stack.add(new Item());
                        }
                    }
                    this.setTop(false);
                    return;
                }
                case 182: 
                case 183: 
                case 184: 
                case 185: {
                    this.processMethodCall(dbc, seen);
                    return;
                }
                default: {
                    throw new UnsupportedOperationException("OpCode " + OPCODE_NAMES[seen] + " not supported ");
                }
            }
        }
        catch (RuntimeException e) {
            String msg = "Error processing opcode " + OPCODE_NAMES[seen] + " @ " + dbc.getPC() + " in " + dbc.getFullyQualifiedMethodName();
            AnalysisContext.logError(msg, e);
            if (DEBUG) {
                e.printStackTrace();
            }
            this.clear();
            return;
        }
        finally {
            if (DEBUG) {
                System.out.println(dbc.getNextPC() + "pc : " + OPCODE_NAMES[seen] + "  stack depth: " + this.getStackDepth());
                System.out.println(this);
            }
        }
    }

    public void precomputation(DismantleBytecode dbc) {
        if (this.registerTestedFoundToBeNonnegative >= 0) {
            Item item;
            int i;
            for (i = 0; i < this.stack.size(); ++i) {
                item = this.stack.get(i);
                if (item == null || item.registerNumber != this.registerTestedFoundToBeNonnegative) continue;
                this.stack.set(i, item.cloneAndSetSpecialKind(12));
            }
            for (i = 0; i < this.lvValues.size(); ++i) {
                item = this.lvValues.get(i);
                if (item == null || item.registerNumber != this.registerTestedFoundToBeNonnegative) continue;
                this.lvValues.set(i, item.cloneAndSetSpecialKind(12));
            }
        }
        this.registerTestedFoundToBeNonnegative = -1;
        this.mergeJumps(dbc);
    }

    private int constantToInt(Item it) {
        return ((Number)it.getConstant()).intValue();
    }

    private float constantToFloat(Item it) {
        return ((Number)it.getConstant()).floatValue();
    }

    private double constantToDouble(Item it) {
        return ((Number)it.getConstant()).doubleValue();
    }

    private long constantToLong(Item it) {
        return ((Number)it.getConstant()).longValue();
    }

    private void handleDcmp(int opcode) {
        Item it = this.pop();
        Item it2 = this.pop();
        if (it.getConstant() != null && it2.getConstant() != null) {
            double d = this.constantToDouble(it);
            double d2 = this.constantToDouble(it2);
            if (Double.isNaN(d) || Double.isNaN(d2)) {
                if (opcode == 152) {
                    this.push(new Item("I", (Object)1));
                } else {
                    this.push(new Item("I", (Object)-1));
                }
            }
            if (d2 < d) {
                this.push(new Item("I", (Object)-1));
            } else if (d2 > d) {
                this.push(new Item("I", (Object)1));
            } else {
                this.push(new Item("I", (Object)0));
            }
        } else {
            this.push(new Item("I"));
        }
    }

    private void handleFcmp(int opcode) {
        Item it = this.pop();
        Item it2 = this.pop();
        if (it.getConstant() != null && it2.getConstant() != null) {
            float f = this.constantToFloat(it);
            float f2 = this.constantToFloat(it2);
            if (Float.isNaN(f) || Float.isNaN(f2)) {
                if (opcode == 150) {
                    this.push(new Item("I", (Object)1));
                } else {
                    this.push(new Item("I", (Object)-1));
                }
            }
            if (f2 < f) {
                this.push(new Item("I", (Object)-1));
            } else if (f2 > f) {
                this.push(new Item("I", (Object)1));
            } else {
                this.push(new Item("I", (Object)0));
            }
        } else {
            this.push(new Item("I"));
        }
    }

    private void handleLcmp() {
        Item it = this.pop();
        Item it2 = this.pop();
        if (it.getConstant() != null && it2.getConstant() != null) {
            long l = this.constantToLong(it);
            long l2 = this.constantToLong(it2);
            if (l2 < l) {
                this.push(new Item("I", (Object)-1));
            } else if (l2 > l) {
                this.push(new Item("I", (Object)1));
            } else {
                this.push(new Item("I", (Object)0));
            }
        } else {
            this.push(new Item("I"));
        }
    }

    private void handleSwap() {
        Item i1 = this.pop();
        Item i2 = this.pop();
        this.push(i1);
        this.push(i2);
    }

    private void handleDup() {
        Item it = this.pop();
        this.push(it);
        this.push(it);
    }

    private void handleDupX1() {
        Item it = this.pop();
        Item it2 = this.pop();
        this.push(it);
        this.push(it2);
        this.push(it);
    }

    private void handleDup2() {
        Item it = this.pop();
        if (it.getSize() == 2) {
            this.push(it);
            this.push(it);
        } else {
            Item it2 = this.pop();
            this.push(it2);
            this.push(it);
            this.push(it2);
            this.push(it);
        }
    }

    private void handleDup2X1() {
        Item it = this.pop();
        Item it2 = this.pop();
        String signature = it.getSignature();
        if (signature.equals("J") || signature.equals("D")) {
            this.push(it);
            this.push(it2);
            this.push(it);
        } else {
            Item it3 = this.pop();
            this.push(it2);
            this.push(it);
            this.push(it3);
            this.push(it2);
            this.push(it);
        }
    }

    private void handleDup2X2() {
        Item it = this.pop();
        Item it2 = this.pop();
        if (it.isWide()) {
            if (it2.isWide()) {
                this.push(it);
                this.push(it2);
                this.push(it);
            } else {
                Item it3 = this.pop();
                this.push(it);
                this.push(it3);
                this.push(it2);
                this.push(it);
            }
        } else {
            Item it3 = this.pop();
            if (it3.isWide()) {
                this.push(it2);
                this.push(it);
                this.push(it3);
                this.push(it2);
                this.push(it);
            } else {
                Item it4 = this.pop();
                this.push(it2);
                this.push(it);
                this.push(it4);
                this.push(it3);
                this.push(it2);
                this.push(it);
            }
        }
    }

    private void handleDupX2() {
        Item it = this.pop();
        Item it2 = this.pop();
        String signature = it2.getSignature();
        if (signature.equals("J") || signature.equals("D")) {
            this.push(it);
            this.push(it2);
            this.push(it);
        } else {
            Item it3 = this.pop();
            this.push(it);
            this.push(it3);
            this.push(it2);
            this.push(it);
        }
    }

    private void processMethodCall(DismantleBytecode dbc, int seen) {
        Item item;
        Item i;
        String clsName = dbc.getClassConstantOperand();
        String methodName = dbc.getNameConstantOperand();
        String signature = dbc.getSigConstantOperand();
        String appenderValue = null;
        boolean servletRequestParameterTainted = false;
        boolean sawUnknownAppend = false;
        Item sbItem = null;
        Item topItem = null;
        if (this.getStackDepth() > 0) {
            topItem = this.getStackItem(0);
        }
        boolean topIsTainted = topItem != null && topItem.isServletParameterTainted();
        HttpParameterInjection injection = null;
        if (topIsTainted) {
            injection = topItem.injection;
        }
        if ("java/lang/StringBuffer".equals(clsName) || "java/lang/StringBuilder".equals(clsName)) {
            if ("<init>".equals(methodName)) {
                if ("(Ljava/lang/String;)V".equals(signature)) {
                    i = this.getStackItem(0);
                    appenderValue = (String)i.getConstant();
                    if (i.isServletParameterTainted()) {
                        servletRequestParameterTainted = true;
                    }
                } else if ("()V".equals(signature)) {
                    appenderValue = "";
                }
            } else if ("toString".equals(methodName) && this.getStackDepth() >= 1) {
                i = this.getStackItem(0);
                appenderValue = (String)i.getConstant();
                if (i.isServletParameterTainted()) {
                    servletRequestParameterTainted = true;
                }
            } else if ("append".equals(methodName)) {
                if (signature.indexOf("II)") == -1 && this.getStackDepth() >= 2) {
                    Item item2;
                    sbItem = this.getStackItem(1);
                    i = this.getStackItem(0);
                    if (i.isServletParameterTainted() || sbItem.isServletParameterTainted()) {
                        servletRequestParameterTainted = true;
                    }
                    Object sbVal = sbItem.getConstant();
                    Object sVal = i.getConstant();
                    if (sbVal != null && sVal != null) {
                        appenderValue = sbVal + sVal.toString();
                    } else if (sbItem.registerNumber >= 0 && (item2 = this.getLVValue(sbItem.registerNumber)) != null) {
                        item2.constValue = null;
                    }
                } else if (signature.startsWith("([CII)")) {
                    sawUnknownAppend = true;
                    sbItem = this.getStackItem(3);
                    if (sbItem.registerNumber >= 0 && (item = this.getLVValue(sbItem.registerNumber)) != null) {
                        item.constValue = null;
                    }
                } else {
                    sawUnknownAppend = true;
                }
            }
        } else if (seen == 183 && clsName.equals("java/io/FileOutputStream") && methodName.equals("<init>") && (signature.equals("(Ljava/io/File;Z)V") || signature.equals("(Ljava/lang/String;Z)V"))) {
            item = this.getStackItem(0);
            Object value = item.getConstant();
            if (value instanceof Integer && (Integer)value == 1) {
                this.pop(3);
                Item newTop = this.getStackItem(0);
                if (newTop.signature.equals("Ljava/io/FileOutputStream;")) {
                    newTop.setSpecialKind(14);
                    newTop.source = XFactory.createReferencedXMethod(dbc);
                    newTop.setPC(dbc.getPC());
                }
                return;
            }
        } else if (seen == 183 && clsName.equals("java/io/BufferedOutputStream") && methodName.equals("<init>") && signature.equals("(Ljava/io/OutputStream;)V")) {
            if (this.getStackItem(0).getSpecialKind() == 14 && this.getStackItem(2).signature.equals("Ljava/io/BufferedOutputStream;")) {
                this.pop(2);
                Item newTop = this.getStackItem(0);
                newTop.setSpecialKind(14);
                newTop.source = XFactory.createReferencedXMethod(dbc);
                newTop.setPC(dbc.getPC());
                return;
            }
        } else {
            if (seen == 185 && methodName.equals("getParameter") && clsName.equals("javax/servlet/http/HttpServletRequest") || clsName.equals("javax/servlet/http/ServletRequest")) {
                Item requestParameter = this.pop();
                this.pop();
                Item result = new Item("Ljava/lang/String;");
                result.setServletParameterTainted();
                result.source = XFactory.createReferencedXMethod(dbc);
                String parameterName = null;
                if (requestParameter.getConstant() instanceof String) {
                    parameterName = (String)requestParameter.getConstant();
                }
                result.injection = new HttpParameterInjection(parameterName, dbc.getPC());
                result.setPC(dbc.getPC());
                this.push(result);
                return;
            }
            if (seen == 185 && methodName.equals("getQueryString") && clsName.equals("javax/servlet/http/HttpServletRequest") || clsName.equals("javax/servlet/http/ServletRequest")) {
                this.pop();
                Item result = new Item("Ljava/lang/String;");
                result.setServletParameterTainted();
                result.source = XFactory.createReferencedXMethod(dbc);
                result.setPC(dbc.getPC());
                this.push(result);
                return;
            }
            if (seen == 185 && methodName.equals("getHeader") && clsName.equals("javax/servlet/http/HttpServletRequest") || clsName.equals("javax/servlet/http/ServletRequest")) {
                this.pop();
                this.pop();
                Item result = new Item("Ljava/lang/String;");
                result.setServletParameterTainted();
                result.source = XFactory.createReferencedXMethod(dbc);
                result.setPC(dbc.getPC());
                this.push(result);
                return;
            }
            if (seen == 184 && methodName.equals("asList") && clsName.equals("java/util/Arrays")) {
                this.pop();
                Item result = new Item(JAVA_UTIL_ARRAYS_ARRAY_LIST);
                this.push(result);
                return;
            }
            if (seen == 184 && signature.equals("(Ljava/util/List;)Ljava/util/List;") && clsName.equals("java/util/Collections")) {
                Item requestParameter = this.pop();
                if (requestParameter.getSignature().equals(JAVA_UTIL_ARRAYS_ARRAY_LIST)) {
                    Item result = new Item(JAVA_UTIL_ARRAYS_ARRAY_LIST);
                    this.push(result);
                    return;
                }
                this.push(requestParameter);
            }
        }
        this.pushByInvoke(dbc, seen != 184);
        if ((sawUnknownAppend || appenderValue != null || servletRequestParameterTainted) && this.getStackDepth() > 0) {
            i = this.getStackItem(0);
            i.constValue = appenderValue;
            if (!sawUnknownAppend && servletRequestParameterTainted) {
                i.injection = topItem.injection;
                i.setServletParameterTainted();
            }
            if (sbItem != null) {
                i.registerNumber = sbItem.registerNumber;
                i.source = sbItem.source;
                if (i.injection == null) {
                    i.injection = sbItem.injection;
                }
                if (sbItem.registerNumber >= 0) {
                    this.setLVValue(sbItem.registerNumber, i);
                }
            }
            return;
        }
        if ((clsName.equals("java/util/Random") || clsName.equals("java/security/SecureRandom")) && methodName.equals("nextInt") && signature.equals("()I")) {
            i = this.pop();
            i.setSpecialKind(2);
            this.push(i);
        } else if (clsName.equals("java/lang/Math") && methodName.equals("abs")) {
            i = this.pop();
            i.setSpecialKind(11);
            this.push(i);
        } else if (seen == 182 && methodName.equals("hashCode") && signature.equals("()I") || seen == 184 && clsName.equals("java/lang/System") && methodName.equals("identityHashCode") && signature.equals("(Ljava/lang/Object;)I")) {
            i = this.pop();
            i.setSpecialKind(4);
            this.push(i);
        } else if (topIsTainted && (methodName.startsWith("encode") && clsName.equals("javax/servlet/http/HttpServletResponse") || methodName.equals("trim") && clsName.equals("java/lang/String"))) {
            i = this.pop();
            i.setSpecialKind(15);
            i.injection = injection;
            this.push(i);
        }
        if (!signature.endsWith(")V")) {
            i = this.pop();
            i.source = XFactory.createReferencedXMethod(dbc);
            this.push(i);
        }
    }

    private void mergeLists(List<Item> mergeInto, List<Item> mergeFrom, boolean errorIfSizesDoNotMatch) {
        int intoSize = mergeInto.size();
        int fromSize = mergeFrom.size();
        if (errorIfSizesDoNotMatch && intoSize != fromSize) {
            if (DEBUG2) {
                System.out.println("Bad merging items");
                System.out.println("current items: " + mergeInto);
                System.out.println("jump items: " + mergeFrom);
            }
        } else {
            if (DEBUG2) {
                if (intoSize == fromSize) {
                    System.out.println("Merging items");
                } else {
                    System.out.println("Bad merging items");
                }
                System.out.println("current items: " + mergeInto);
                System.out.println("jump items: " + mergeFrom);
            }
            for (int i = 0; i < Math.min(intoSize, fromSize); ++i) {
                mergeInto.set(i, Item.merge(mergeInto.get(i), mergeFrom.get(i)));
            }
            if (DEBUG2) {
                System.out.println("merged items: " + mergeInto);
            }
        }
    }

    public void clear() {
        this.stack.clear();
        this.lvValues.clear();
    }

    public boolean isJumpTarget(int pc) {
        return this.jumpEntryLocations.get(pc);
    }

    private void addJumpValue(int from, int target) {
        List<Item> atTarget;
        if (DEBUG) {
            System.out.println("Set jump entry at " + this.methodName + ":" + target + "pc to " + this.stack + " : " + this.lvValues);
        }
        if (from >= target) {
            this.backwardsBranch = true;
        }
        if ((atTarget = this.jumpEntries.get(target)) == null) {
            if (DEBUG) {
                System.out.println("Was null");
            }
            this.jumpEntries.put(target, new ArrayList<Item>(this.lvValues));
            this.jumpEntryLocations.set(target);
            if (this.stack.size() > 0) {
                this.jumpStackEntries.put(target, new ArrayList<Item>(this.stack));
            }
            return;
        }
        this.mergeLists(atTarget, this.lvValues, false);
        List<Item> stackAtTarget = this.jumpStackEntries.get(target);
        if (this.stack.size() > 0 && stackAtTarget != null) {
            this.mergeLists(stackAtTarget, this.stack, false);
        }
        if (DEBUG) {
            System.out.println("merge target for " + this.methodName + ":" + target + "pc is " + atTarget);
        }
    }

    public void learnFrom(JumpInfo info) {
        this.jumpEntries = new HashMap<Integer, List<Item>>(info.jumpEntries);
        this.jumpStackEntries = new HashMap<Integer, List<Item>>(info.jumpStackEntries);
        this.jumpEntryLocations = (BitSet)info.jumpEntryLocations.clone();
    }

    public void initialize() {
        this.setTop(false);
        this.jumpEntries.clear();
        this.jumpStackEntries.clear();
        this.jumpEntryLocations.clear();
        this.encountedTop = false;
        this.backwardsBranch = false;
        this.lastUpdate.clear();
        this.convertJumpToZeroOneState = 0;
        this.convertJumpToOneZeroState = 0;
        this.zeroOneComing = -1;
        this.registerTestedFoundToBeNonnegative = -1;
        this.setReachOnlyByBranch(false);
    }

    public int resetForMethodEntry(DismantleBytecode visitor) {
        this.v = visitor;
        this.initialize();
        int result = this.resetForMethodEntry0(this.v);
        Code code = this.v.getMethod().getCode();
        if (code == null) {
            return result;
        }
        if (this.useIterativeAnalysis) {
            IAnalysisCache analysisCache = Global.getAnalysisCache();
            XMethod xMethod = XFactory.createXMethod(this.v.getThisClass(), this.v.getMethod());
            try {
                JumpInfo jump = analysisCache.getMethodAnalysis(JumpInfo.class, xMethod.getMethodDescriptor());
                if (jump != null) {
                    this.learnFrom(jump);
                }
            }
            catch (CheckedAnalysisException e) {
                AnalysisContext.logError("Error getting jump information", e);
            }
        }
        return result;
    }

    private int resetForMethodEntry0(PreorderVisitor visitor) {
        return this.resetForMethodEntry0(visitor.getClassName(), visitor.getMethod());
    }

    private int resetForMethodEntry0(@SlashedClassName String className, Method m) {
        CodeException[] exceptionTable;
        this.methodName = m.getName();
        if (DEBUG) {
            System.out.println(" --- ");
        }
        String signature = m.getSignature();
        this.stack.clear();
        this.lvValues.clear();
        this.top = false;
        this.encountedTop = false;
        this.backwardsBranch = false;
        this.setReachOnlyByBranch(false);
        this.seenTransferOfControl = false;
        this.exceptionHandlers.clear();
        Code code = m.getCode();
        if (code != null && (exceptionTable = code.getExceptionTable()) != null) {
            for (CodeException ex : exceptionTable) {
                this.exceptionHandlers.set(ex.getHandlerPC());
            }
        }
        if (DEBUG) {
            System.out.println(" --- " + className + " " + m.getName() + " " + signature);
        }
        Type[] argTypes = Type.getArgumentTypes((String)signature);
        int reg = 0;
        if (!m.isStatic()) {
            Item it = new Item("L" + className + ";");
            it.setInitialParameter(true);
            it.registerNumber = reg;
            this.setLVValue(reg, it);
            reg += it.getSize();
        }
        for (Type argType : argTypes) {
            Item it = new Item(argType.getSignature());
            it.registerNumber = reg;
            it.setInitialParameter(true);
            this.setLVValue(reg, it);
            reg += it.getSize();
        }
        return reg;
    }

    public int getStackDepth() {
        return this.stack.size();
    }

    public Item getStackItem(int stackOffset) {
        if (stackOffset < 0 || stackOffset >= this.stack.size()) {
            AnalysisContext.logError("Can't get stack offset " + stackOffset + " from " + this.stack.toString() + " @ " + this.v.getPC() + " in " + this.v.getFullyQualifiedMethodName(), new IllegalArgumentException(stackOffset + " is not a value stack offset"));
            return new Item("Lfindbugs/OpcodeStackError;");
        }
        int tos = this.stack.size() - 1;
        int pos = tos - stackOffset;
        try {
            return this.stack.get(pos);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ArrayIndexOutOfBoundsException("Requested item at offset " + stackOffset + " in a stack of size " + this.stack.size() + ", made request for position " + pos);
        }
    }

    private Item pop() {
        return this.stack.remove(this.stack.size() - 1);
    }

    public void replaceTop(Item newTop) {
        this.pop();
        this.push(newTop);
    }

    private void pop(int count) {
        while (count-- > 0) {
            this.pop();
        }
    }

    private void push(Item i) {
        this.stack.add(i);
    }

    private void pushByConstant(DismantleBytecode dbc, Constant c) {
        if (c instanceof ConstantClass) {
            this.push(new Item("Ljava/lang/Class;", ((ConstantClass)c).getConstantValue(dbc.getConstantPool())));
        } else if (c instanceof ConstantInteger) {
            this.push(new Item("I", (Object)((ConstantInteger)c).getBytes()));
        } else if (c instanceof ConstantString) {
            int s = ((ConstantString)c).getStringIndex();
            this.push(new Item("Ljava/lang/String;", this.getStringFromIndex(dbc, s)));
        } else if (c instanceof ConstantFloat) {
            this.push(new Item("F", Float.valueOf(((ConstantFloat)c).getBytes())));
        } else if (c instanceof ConstantDouble) {
            this.push(new Item("D", ((ConstantDouble)c).getBytes()));
        } else if (c instanceof ConstantLong) {
            this.push(new Item("J", ((ConstantLong)c).getBytes()));
        } else {
            throw new UnsupportedOperationException("Constant type not expected");
        }
    }

    private void pushByLocalObjectLoad(DismantleBytecode dbc, int register) {
        LocalVariable lv;
        Method m = dbc.getMethod();
        LocalVariableTable lvt = m.getLocalVariableTable();
        if (lvt != null && (lv = LVTHelper.getLocalVariableAtPC(lvt, register, dbc.getPC())) != null) {
            String signature = lv.getSignature();
            this.pushByLocalLoad(signature, register);
            return;
        }
        this.pushByLocalLoad("Ljava/lang/Object;", register);
    }

    private void pushByIntMath(DismantleBytecode dbc, int seen, Item lhs, Item rhs) {
        Item newValue = new Item("I");
        if (lhs == null || rhs == null) {
            this.push(newValue);
            return;
        }
        try {
            int value;
            if (DEBUG) {
                System.out.println("pushByIntMath: " + rhs.getConstant() + " " + lhs.getConstant());
            }
            if (rhs.getConstant() != null && lhs.getConstant() != null) {
                int lhsValue = this.constantToInt(lhs);
                int rhsValue = this.constantToInt(rhs);
                if (seen == 96) {
                    newValue = new Item("I", lhsValue + rhsValue);
                } else if (seen == 100) {
                    newValue = new Item("I", lhsValue - rhsValue);
                } else if (seen == 104) {
                    newValue = new Item("I", lhsValue * rhsValue);
                } else if (seen == 108) {
                    newValue = new Item("I", lhsValue / rhsValue);
                } else if (seen == 126) {
                    newValue = new Item("I", lhsValue & rhsValue);
                    if ((rhsValue & 0xFF) == 0 && rhsValue != 0 || (lhsValue & 0xFF) == 0 && lhsValue != 0) {
                        newValue.setSpecialKind(3);
                    }
                } else if (seen == 128) {
                    newValue = new Item("I", lhsValue | rhsValue);
                } else if (seen == 130) {
                    newValue = new Item("I", lhsValue ^ rhsValue);
                } else if (seen == 120) {
                    newValue = new Item("I", lhsValue << rhsValue);
                    if (rhsValue >= 8) {
                        newValue.setSpecialKind(3);
                    }
                } else if (seen == 122) {
                    newValue = new Item("I", lhsValue >> rhsValue);
                } else if (seen == 112) {
                    newValue = new Item("I", lhsValue % rhsValue);
                } else if (seen == 124) {
                    newValue = new Item("I", lhsValue >>> rhsValue);
                }
            } else if (seen == 120 || seen == 122 || seen == 124) {
                int constant;
                if (rhs.getConstant() != null) {
                    constant = this.constantToInt(rhs);
                    if ((constant & 0x1F) == 0) {
                        newValue = new Item(lhs);
                    } else if (seen == 120 && (constant & 0x1F) >= 8) {
                        newValue.setSpecialKind(3);
                    }
                } else if (lhs.getConstant() != null && (constant = this.constantToInt(lhs)) == 0) {
                    newValue = new Item("I", 0);
                }
            } else if (lhs.getConstant() != null && seen == 126) {
                value = this.constantToInt(lhs);
                if (value == 0) {
                    newValue = new Item("I", 0);
                } else if ((value & 0xFF) == 0) {
                    newValue.setSpecialKind(3);
                } else if (value >= 0) {
                    newValue.setSpecialKind(12);
                }
            } else if (rhs.getConstant() != null && seen == 126) {
                value = this.constantToInt(rhs);
                if (value == 0) {
                    newValue = new Item("I", 0);
                } else if ((value & 0xFF) == 0) {
                    newValue.setSpecialKind(3);
                } else if (value >= 0) {
                    newValue.setSpecialKind(12);
                }
            } else if (seen == 126 && lhs.getSpecialKind() == 17) {
                newValue.setSpecialKind(17);
                newValue.setPC(lhs.getPC());
            } else if (seen == 126 && rhs.getSpecialKind() == 17) {
                newValue.setSpecialKind(17);
                newValue.setPC(rhs.getPC());
            } else if (seen == 128 && lhs.getSpecialKind() == 18) {
                newValue.setSpecialKind(18);
                newValue.setPC(lhs.getPC());
            } else if (seen == 128 && rhs.getSpecialKind() == 18) {
                newValue.setSpecialKind(18);
                newValue.setPC(rhs.getPC());
            }
        }
        catch (ArithmeticException e) {
        }
        catch (RuntimeException e) {
            String msg = "Error processing2 " + lhs + OPCODE_NAMES[seen] + rhs + " @ " + dbc.getPC() + " in " + dbc.getFullyQualifiedMethodName();
            AnalysisContext.logError(msg, e);
        }
        if (lhs.getSpecialKind() == 5 && rhs.getConstant() != null) {
            int rhsValue = this.constantToInt(rhs);
            if (seen == 108 && rhsValue == 2 || seen == 122 && rhsValue == 1) {
                newValue.setSpecialKind(6);
            }
        }
        if (seen == 96 && newValue.getSpecialKind() == 0 && lhs.getConstant() == null && rhs.getConstant() == null) {
            newValue.setSpecialKind(5);
        }
        if (seen == 112 && lhs.getSpecialKind() == 4) {
            newValue.setSpecialKind(9);
        }
        if (seen == 112 && lhs.getSpecialKind() == 2) {
            newValue.setSpecialKind(8);
        }
        if (DEBUG) {
            System.out.println("push: " + newValue);
        }
        newValue.setPC(dbc.getPC());
        this.push(newValue);
    }

    private void pushByLongMath(int seen, Item lhs, Item rhs) {
        Item newValue = new Item("J");
        try {
            if (rhs.getConstant() != null && lhs.getConstant() != null) {
                long lhsValue = this.constantToLong(lhs);
                if (seen == 121) {
                    newValue = new Item("J", lhsValue << this.constantToInt(rhs));
                    if (this.constantToInt(rhs) >= 8) {
                        newValue.setSpecialKind(3);
                    }
                } else if (seen == 123) {
                    newValue = new Item("J", lhsValue >> this.constantToInt(rhs));
                } else if (seen == 125) {
                    newValue = new Item("J", lhsValue >>> this.constantToInt(rhs));
                } else {
                    long rhsValue = this.constantToLong(rhs);
                    if (seen == 97) {
                        newValue = new Item("J", lhsValue + rhsValue);
                    } else if (seen == 101) {
                        newValue = new Item("J", lhsValue - rhsValue);
                    } else if (seen == 105) {
                        newValue = new Item("J", lhsValue * rhsValue);
                    } else if (seen == 109) {
                        newValue = new Item("J", lhsValue / rhsValue);
                    } else if (seen == 127) {
                        newValue = new Item("J", lhsValue & rhsValue);
                        if ((rhsValue & 0xFFL) == 0L && rhsValue != 0L || (lhsValue & 0xFFL) == 0L && lhsValue != 0L) {
                            newValue.setSpecialKind(3);
                        }
                    } else if (seen == 129) {
                        newValue = new Item("J", lhsValue | rhsValue);
                    } else if (seen == 131) {
                        newValue = new Item("J", lhsValue ^ rhsValue);
                    } else if (seen == 113) {
                        newValue = new Item("J", lhsValue % rhsValue);
                    }
                }
            } else if (rhs.getConstant() != null && seen == 121 && this.constantToInt(rhs) >= 8) {
                newValue.setSpecialKind(3);
            } else if (lhs.getConstant() != null && seen == 127 && (this.constantToLong(lhs) & 0xFFL) == 0L) {
                newValue.setSpecialKind(3);
            } else if (rhs.getConstant() != null && seen == 127 && (this.constantToLong(rhs) & 0xFFL) == 0L) {
                newValue.setSpecialKind(3);
            }
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        this.push(newValue);
    }

    private void pushByFloatMath(int seen, Item it, Item it2) {
        Item result;
        int specialKind = 7;
        if (it.getConstant() instanceof Float && it2.getConstant() instanceof Float) {
            result = seen == 98 ? new Item("F", Float.valueOf(this.constantToFloat(it2) + this.constantToFloat(it))) : (seen == 102 ? new Item("F", Float.valueOf(this.constantToFloat(it2) - this.constantToFloat(it))) : (seen == 106 ? new Item("F", Float.valueOf(this.constantToFloat(it2) * this.constantToFloat(it))) : (seen == 110 ? new Item("F", Float.valueOf(this.constantToFloat(it2) / this.constantToFloat(it))) : (seen == 114 ? new Item("F", Float.valueOf(this.constantToFloat(it2) % this.constantToFloat(it))) : new Item("F")))));
        } else {
            result = new Item("F");
            if (seen == 111) {
                specialKind = 13;
            }
        }
        result.setSpecialKind(specialKind);
        this.push(result);
    }

    private void pushByDoubleMath(int seen, Item it, Item it2) {
        Item result;
        int specialKind = 7;
        if (it.getConstant() instanceof Double && it2.getConstant() instanceof Double) {
            result = seen == 99 ? new Item("D", this.constantToDouble(it2) + this.constantToDouble(it)) : (seen == 103 ? new Item("D", this.constantToDouble(it2) - this.constantToDouble(it)) : (seen == 107 ? new Item("D", this.constantToDouble(it2) * this.constantToDouble(it)) : (seen == 111 ? new Item("D", this.constantToDouble(it2) / this.constantToDouble(it)) : (seen == 115 ? new Item("D", this.constantToDouble(it2) % this.constantToDouble(it)) : new Item("D")))));
        } else {
            result = new Item("D");
            if (seen == 111) {
                specialKind = 13;
            }
        }
        result.setSpecialKind(specialKind);
        this.push(result);
    }

    private void pushByInvoke(DismantleBytecode dbc, boolean popThis) {
        String signature = dbc.getSigConstantOperand();
        if (dbc.getNameConstantOperand().equals("<init>") && signature.endsWith(")V") && popThis) {
            Item next;
            this.pop(PreorderVisitor.getNumberArguments(signature));
            Item constructed = this.pop();
            if (this.getStackDepth() > 0 && constructed.equals(next = this.getStackItem(0))) {
                next.source = XFactory.createReferencedXMethod(dbc);
            }
            return;
        }
        this.pop(PreorderVisitor.getNumberArguments(signature) + (popThis ? 1 : 0));
        this.pushBySignature(Type.getReturnType((String)signature).getSignature(), dbc);
    }

    private String getStringFromIndex(DismantleBytecode dbc, int i) {
        ConstantUtf8 name = (ConstantUtf8)dbc.getConstantPool().getConstant(i);
        return name.getBytes();
    }

    private void pushBySignature(String s, DismantleBytecode dbc) {
        if ("V".equals(s)) {
            return;
        }
        Item item = new Item(s, (Object)null);
        if (dbc != null) {
            item.setPC(dbc.getPC());
        }
        this.push(item);
    }

    private void pushByLocalStore(int register) {
        Item it = this.pop();
        if (it.getRegisterNumber() != register) {
            for (Item i : this.lvValues) {
                if (i == null) continue;
                if (i.registerNumber == register) {
                    i.registerNumber = -1;
                }
                if (i.fieldLoadedFromRegister != register) continue;
                i.fieldLoadedFromRegister = -1;
            }
            for (Item i : this.stack) {
                if (i == null) continue;
                if (i.registerNumber == register) {
                    i.registerNumber = -1;
                }
                if (i.fieldLoadedFromRegister != register) continue;
                i.fieldLoadedFromRegister = -1;
            }
        }
        this.setLVValue(register, it);
    }

    private void pushByLocalLoad(String signature, int register) {
        Item newItem;
        Item oldItem = this.getLVValue(register);
        if (oldItem == null) {
            newItem = new Item(signature);
            newItem.registerNumber = register;
        } else {
            newItem = oldItem;
            if (newItem.signature.equals("Ljava/lang/Object;") && !signature.equals("Ljava/lang/Object;")) {
                newItem = new Item(oldItem);
                newItem.signature = signature;
            }
            if (newItem.getRegisterNumber() < 0) {
                if (newItem == oldItem) {
                    newItem = new Item(oldItem);
                }
                newItem.registerNumber = register;
            }
        }
        this.push(newItem);
    }

    private void setLVValue(int index, Item value) {
        int addCount = index - this.lvValues.size() + 1;
        while (addCount-- > 0) {
            this.lvValues.add(null);
        }
        if (!this.useIterativeAnalysis && this.seenTransferOfControl) {
            value = Item.merge(value, this.lvValues.get(index));
        }
        this.lvValues.set(index, value);
    }

    private Item getLVValue(int index) {
        if (index >= this.lvValues.size()) {
            return new Item();
        }
        return this.lvValues.get(index);
    }

    private void setTop(boolean top) {
        if (top) {
            if (!this.top) {
                this.top = true;
            }
        } else if (this.top) {
            this.top = false;
        }
    }

    public boolean isTop() {
        return this.top;
    }

    void setReachOnlyByBranch(boolean reachOnlyByBranch) {
        if (reachOnlyByBranch) {
            this.setTop(true);
        }
        this.reachOnlyByBranch = reachOnlyByBranch;
    }

    boolean isReachOnlyByBranch() {
        return this.reachOnlyByBranch;
    }

    static {
        DEBUG2 = DEBUG = SystemProperties.getBoolean("ocstack.debug");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class JumpInfoFactory
    extends AnalysisFactory<JumpInfo> {
        public JumpInfoFactory() {
            super("Jump info for opcode stack", JumpInfo.class);
        }

        @Override
        public JumpInfo analyze(IAnalysisCache analysisCache, MethodDescriptor descriptor) throws CheckedAnalysisException {
            Method method = analysisCache.getMethodAnalysis(Method.class, descriptor);
            JavaClass jclass = this.getJavaClass(analysisCache, descriptor.getClassDescriptor());
            Code code = method.getCode();
            final OpcodeStack stack = new OpcodeStack();
            if (code == null) {
                return null;
            }
            DismantleBytecode branchAnalysis = new DismantleBytecode(){

                public void sawOpcode(int seen) {
                    stack.sawOpcode(this, seen);
                }
            };
            branchAnalysis.setupVisitorForClass(jclass);
            int oldCount = 0;
            while (true) {
                stack.resetForMethodEntry0(ClassName.toSlashedClassName(jclass.getClassName()), method);
                branchAnalysis.doVisitMethod(method);
                int newCount = stack.jumpEntries.size();
                if (newCount == oldCount || !stack.encountedTop || !stack.backwardsBranch) break;
                oldCount = newCount;
            }
            return new JumpInfo(stack.jumpEntries, stack.jumpStackEntries, stack.jumpEntryLocations);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class JumpInfo {
        final Map<Integer, List<Item>> jumpEntries;
        final Map<Integer, List<Item>> jumpStackEntries;
        final BitSet jumpEntryLocations;

        JumpInfo(Map<Integer, List<Item>> jumpEntries, Map<Integer, List<Item>> jumpStackEntries, BitSet jumpEntryLocations) {
            this.jumpEntries = jumpEntries;
            this.jumpStackEntries = jumpStackEntries;
            this.jumpEntryLocations = jumpEntryLocations;
        }
    }

    public static class Item {
        @SpecialKind
        public static final int NOT_SPECIAL = 0;
        @SpecialKind
        public static final int SIGNED_BYTE = 1;
        @SpecialKind
        public static final int RANDOM_INT = 2;
        @SpecialKind
        public static final int LOW_8_BITS_CLEAR = 3;
        @SpecialKind
        public static final int HASHCODE_INT = 4;
        @SpecialKind
        public static final int INTEGER_SUM = 5;
        @SpecialKind
        public static final int AVERAGE_COMPUTED_USING_DIVISION = 6;
        @SpecialKind
        public static final int FLOAT_MATH = 7;
        @SpecialKind
        public static final int RANDOM_INT_REMAINDER = 8;
        @SpecialKind
        public static final int HASHCODE_INT_REMAINDER = 9;
        @SpecialKind
        public static final int FILE_SEPARATOR_STRING = 10;
        @SpecialKind
        public static final int MATH_ABS = 11;
        @SpecialKind
        public static final int NON_NEGATIVE = 12;
        @SpecialKind
        public static final int NASTY_FLOAT_MATH = 13;
        @SpecialKind
        public static final int FILE_OPENED_IN_APPEND_MODE = 14;
        @SpecialKind
        public static final int SERVLET_REQUEST_TAINTED = 15;
        @SpecialKind
        public static final int NEWLY_ALLOCATED = 16;
        @SpecialKind
        public static final int ZERO_MEANS_NULL = 17;
        @SpecialKind
        public static final int NONZERO_MEANS_NULL = 18;
        private static final int IS_INITIAL_PARAMETER_FLAG = 1;
        private static final int COULD_BE_ZERO_FLAG = 2;
        private static final int IS_NULL_FLAG = 4;
        public static final Object UNKNOWN = null;
        @SpecialKind
        private int specialKind = 0;
        private String signature;
        private Object constValue = UNKNOWN;
        @CheckForNull
        private ClassMember source;
        private int pc = -1;
        private int flags;
        private int registerNumber = -1;
        private Object userValue = null;
        private HttpParameterInjection injection = null;
        private int fieldLoadedFromRegister = -1;

        public void makeCrossMethod() {
            this.pc = -1;
            this.registerNumber = -1;
            this.fieldLoadedFromRegister = -1;
        }

        public int getSize() {
            if (this.signature.equals("J") || this.signature.equals("D")) {
                return 2;
            }
            return 1;
        }

        public int getPC() {
            return this.pc;
        }

        public void setPC(int pc) {
            this.pc = pc;
        }

        public boolean isWide() {
            return this.getSize() == 2;
        }

        public int hashCode() {
            int r = 42 + this.specialKind;
            if (this.signature != null) {
                r += this.signature.hashCode();
            }
            r *= 31;
            if (this.constValue != null) {
                r += this.constValue.hashCode();
            }
            r *= 31;
            if (this.source != null) {
                r += this.source.hashCode();
            }
            r *= 31;
            r += this.flags;
            r *= 31;
            return r += this.registerNumber;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Item)) {
                return false;
            }
            Item that = (Item)o;
            return Util.nullSafeEquals(this.signature, that.signature) && Util.nullSafeEquals(this.constValue, that.constValue) && Util.nullSafeEquals(this.source, that.source) && Util.nullSafeEquals(this.userValue, that.userValue) && Util.nullSafeEquals(this.injection, that.injection) && this.specialKind == that.specialKind && this.registerNumber == that.registerNumber && this.flags == that.flags && this.fieldLoadedFromRegister == that.fieldLoadedFromRegister;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder("< ");
            buf.append(this.signature);
            switch (this.specialKind) {
                case 1: {
                    buf.append(", byte_array_load");
                    break;
                }
                case 2: {
                    buf.append(", random_int");
                    break;
                }
                case 3: {
                    buf.append(", low8clear");
                    break;
                }
                case 4: {
                    buf.append(", hashcode_int");
                    break;
                }
                case 5: {
                    buf.append(", int_sum");
                    break;
                }
                case 6: {
                    buf.append(", averageComputingUsingDivision");
                    break;
                }
                case 7: {
                    buf.append(", floatMath");
                    break;
                }
                case 13: {
                    buf.append(", nastyFloatMath");
                    break;
                }
                case 9: {
                    buf.append(", hashcode_int_rem");
                    break;
                }
                case 8: {
                    buf.append(", random_int_rem");
                    break;
                }
                case 10: {
                    buf.append(", file_separator_string");
                    break;
                }
                case 11: {
                    buf.append(", Math.abs");
                    break;
                }
                case 12: {
                    buf.append(", non_negative");
                    break;
                }
                case 14: {
                    buf.append(", file opened in append mode");
                    break;
                }
                case 15: {
                    buf.append(", servlet request tainted");
                    break;
                }
                case 16: {
                    buf.append(", new");
                    break;
                }
                case 17: {
                    buf.append(", zero means null");
                    break;
                }
                case 18: {
                    buf.append(", nonzero means null");
                    break;
                }
                case 0: {
                    break;
                }
                default: {
                    buf.append(", #" + this.specialKind);
                }
            }
            if (this.constValue != UNKNOWN) {
                if (this.constValue instanceof String) {
                    buf.append(", \"");
                    buf.append(this.constValue);
                    buf.append("\"");
                } else {
                    buf.append(", ");
                    buf.append(this.constValue);
                }
            }
            if (this.source instanceof XField) {
                buf.append(", ");
                if (this.fieldLoadedFromRegister != -1) {
                    buf.append(this.fieldLoadedFromRegister).append(':');
                }
                buf.append(this.source);
            }
            if (this.source instanceof XMethod) {
                buf.append(", return value from ");
                buf.append(this.source);
            }
            if (this.isInitialParameter()) {
                buf.append(", IP");
            }
            if (this.isNull()) {
                buf.append(", isNull");
            }
            if (this.registerNumber != -1) {
                buf.append(", r");
                buf.append(this.registerNumber);
            }
            if (this.isCouldBeZero()) {
                buf.append(", cbz");
            }
            buf.append(" >");
            return buf.toString();
        }

        public static Item merge(Item i1, Item i2) {
            if (i1 == null) {
                return i2;
            }
            if (i2 == null) {
                return i1;
            }
            if (i1.equals(i2)) {
                return i1;
            }
            Item m = new Item();
            m.flags = i1.flags & i2.flags;
            m.setCouldBeZero(i1.isCouldBeZero() || i2.isCouldBeZero());
            if (i1.pc == i2.pc) {
                m.pc = i1.pc;
            }
            if (Util.nullSafeEquals(i1.signature, i2.signature)) {
                m.signature = i1.signature;
            } else if (i1.isNull()) {
                m.signature = i2.signature;
            } else if (i2.isNull()) {
                m.signature = i1.signature;
            }
            if (Util.nullSafeEquals(i1.constValue, i2.constValue)) {
                m.constValue = i1.constValue;
            }
            if (Util.nullSafeEquals(i1.source, i2.source)) {
                m.source = i1.source;
            } else if ("".equals(i1.constValue)) {
                m.source = i2.source;
            } else if ("".equals(i2.constValue)) {
                m.source = i1.source;
            }
            if (Util.nullSafeEquals(i1.userValue, i2.userValue)) {
                m.userValue = i1.userValue;
            }
            if (i1.registerNumber == i2.registerNumber) {
                m.registerNumber = i1.registerNumber;
            }
            if (i1.fieldLoadedFromRegister == i2.fieldLoadedFromRegister) {
                m.fieldLoadedFromRegister = i1.fieldLoadedFromRegister;
            }
            if (i1.specialKind == 15) {
                m.specialKind = 15;
                m.injection = i1.injection;
            } else if (i2.specialKind == 15) {
                m.specialKind = 15;
                m.injection = i2.injection;
            } else if (i1.specialKind == i2.specialKind) {
                m.specialKind = i1.specialKind;
            } else if (i1.specialKind == 13 || i2.specialKind == 13) {
                m.specialKind = 13;
            } else if (i1.specialKind == 7 || i2.specialKind == 7) {
                m.specialKind = 7;
            }
            if (DEBUG) {
                System.out.println("Merge " + i1 + " and " + i2 + " gives " + m);
            }
            return m;
        }

        public Item(String signature, int constValue) {
            this(signature, (Object)constValue);
        }

        public Item(String signature) {
            this(signature, UNKNOWN);
        }

        public Item(Item it) {
            this.signature = it.signature;
            this.constValue = it.constValue;
            this.source = it.source;
            this.registerNumber = it.registerNumber;
            this.userValue = it.userValue;
            this.injection = it.injection;
            this.flags = it.flags;
            this.specialKind = it.specialKind;
            this.pc = it.pc;
        }

        public Item(Item it, int reg) {
            this(it);
            this.registerNumber = reg;
        }

        public Item(String signature, FieldAnnotation f) {
            this.signature = signature;
            if (f != null) {
                this.source = XFactory.createXField(f);
            }
            this.fieldLoadedFromRegister = -1;
        }

        public Item(String signature, FieldAnnotation f, int fieldLoadedFromRegister) {
            this.signature = signature;
            if (f != null) {
                this.source = XFactory.createXField(f);
            }
            this.fieldLoadedFromRegister = fieldLoadedFromRegister;
        }

        public int getFieldLoadedFromRegister() {
            return this.fieldLoadedFromRegister;
        }

        public void setLoadedFromField(XField f, int fieldLoadedFromRegister) {
            this.source = f;
            this.fieldLoadedFromRegister = fieldLoadedFromRegister;
            this.registerNumber = -1;
        }

        @CheckForNull
        public String getHttpParameterName() {
            if (!this.isServletParameterTainted()) {
                throw new IllegalStateException();
            }
            if (this.injection == null) {
                return null;
            }
            return this.injection.parameterName;
        }

        public int getInjectionPC() {
            if (!this.isServletParameterTainted()) {
                throw new IllegalStateException();
            }
            if (this.injection == null) {
                return -1;
            }
            return this.injection.pc;
        }

        public Item(String signature, Object constantValue) {
            this.signature = signature;
            this.constValue = constantValue;
            if (constantValue instanceof Integer) {
                int value = (Integer)constantValue;
                if (value != 0 && (value & 0xFF) == 0) {
                    this.specialKind = 3;
                }
                if (value == 0) {
                    this.setCouldBeZero(true);
                }
            } else if (constantValue instanceof Long) {
                long value = (Long)constantValue;
                if (value != 0L && (value & 0xFFL) == 0L) {
                    this.specialKind = 3;
                }
                if (value == 0L) {
                    this.setCouldBeZero(true);
                }
            }
        }

        public Item() {
            this.signature = "Ljava/lang/Object;";
            this.constValue = null;
            this.setNull(true);
        }

        public static Item nullItem(String signature) {
            Item item = new Item(signature);
            item.constValue = null;
            item.setNull(true);
            return item;
        }

        @CheckForNull
        public JavaClass getJavaClass() throws ClassNotFoundException {
            if (this.isPrimitive() || this.isArray()) {
                return null;
            }
            String baseSig = this.signature;
            if (baseSig.length() == 0) {
                return null;
            }
            baseSig = baseSig.substring(1, baseSig.length() - 1);
            baseSig = baseSig.replace('/', '.');
            return Repository.lookupClass((String)baseSig);
        }

        public boolean isArray() {
            return this.signature.startsWith("[");
        }

        @Deprecated
        public String getElementSignature() {
            int pos;
            if (!this.isArray()) {
                return this.signature;
            }
            int len = this.signature.length();
            for (pos = 0; pos < len && this.signature.charAt(pos) == '['; ++pos) {
            }
            return this.signature.substring(pos);
        }

        public boolean isNonNegative() {
            if (this.specialKind == 12) {
                return true;
            }
            if (this.constValue instanceof Number) {
                double value = ((Number)this.constValue).doubleValue();
                return value >= 0.0;
            }
            return false;
        }

        public boolean isPrimitive() {
            return !this.signature.startsWith("L") && !this.signature.startsWith("[");
        }

        public int getRegisterNumber() {
            return this.registerNumber;
        }

        public String getSignature() {
            return this.signature;
        }

        public Object getConstant() {
            return this.constValue;
        }

        @Deprecated
        public FieldAnnotation getFieldAnnotation() {
            return FieldAnnotation.fromXField(this.getXField());
        }

        public XField getXField() {
            if (this.source instanceof XField) {
                return (XField)this.source;
            }
            return null;
        }

        public void setSpecialKind(@SpecialKind int specialKind) {
            this.specialKind = specialKind;
        }

        public Item cloneAndSetSpecialKind(@SpecialKind int specialKind) {
            Item that = new Item(this);
            that.specialKind = specialKind;
            return that;
        }

        @SpecialKind
        public int getSpecialKind() {
            return this.specialKind;
        }

        public boolean isBooleanNullnessValue() {
            return this.specialKind == 17 || this.specialKind == 18;
        }

        public void setUserValue(Object value) {
            this.userValue = value;
        }

        @CheckForNull
        public XMethod getReturnValueOf() {
            if (this.source instanceof XMethod) {
                return (XMethod)this.source;
            }
            return null;
        }

        public boolean couldBeZero() {
            return this.isCouldBeZero();
        }

        public boolean mustBeZero() {
            Object value = this.getConstant();
            return value instanceof Number && ((Number)value).intValue() == 0;
        }

        public Object getUserValue() {
            return this.userValue;
        }

        public boolean isServletParameterTainted() {
            return this.getSpecialKind() == 15;
        }

        public void setServletParameterTainted() {
            this.setSpecialKind(15);
        }

        public boolean valueCouldBeNegative() {
            return !this.isNonNegative() && (this.getSpecialKind() == 2 || this.getSpecialKind() == 1 || this.getSpecialKind() == 4 || this.getSpecialKind() == 8 || this.getSpecialKind() == 9);
        }

        public boolean checkForIntegerMinValue() {
            return !this.isNonNegative() && (this.getSpecialKind() == 2 || this.getSpecialKind() == 4);
        }

        private void setInitialParameter(boolean isInitialParameter) {
            this.setFlag(isInitialParameter, 1);
        }

        public boolean isInitialParameter() {
            return (this.flags & 1) != 0;
        }

        private void setCouldBeZero(boolean couldBeZero) {
            this.setFlag(couldBeZero, 2);
        }

        private boolean isCouldBeZero() {
            return (this.flags & 2) != 0;
        }

        private void setNull(boolean isNull) {
            this.setFlag(isNull, 4);
        }

        private void setFlag(boolean value, int flagBit) {
            this.flags = value ? (this.flags |= flagBit) : (this.flags &= ~flagBit);
        }

        public boolean isNull() {
            return (this.flags & 4) != 0;
        }

        public void clearNewlyAllocated() {
            if (this.specialKind == 16) {
                if (this.signature.startsWith("Ljava/lang/StringB")) {
                    this.constValue = null;
                }
                this.specialKind = 0;
            }
        }

        public boolean isNewlyAllocated() {
            return this.specialKind == 16;
        }

        public boolean hasConstantValue(int value) {
            if (this.constValue instanceof Number) {
                return ((Number)this.constValue).intValue() == value;
            }
            return false;
        }

        public boolean hasConstantValue(long value) {
            if (this.constValue instanceof Number) {
                return ((Number)this.constValue).longValue() == value;
            }
            return false;
        }

        @Documented
        @TypeQualifier(applicableTo=Integer.class)
        @Retention(value=RetentionPolicy.RUNTIME)
        public static @interface SpecialKind {
        }
    }

    static class HttpParameterInjection {
        String parameterName;
        int pc;

        HttpParameterInjection(String parameterName, int pc) {
            this.parameterName = parameterName;
            this.pc = pc;
        }
    }
}

