/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.BugCollection;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.DetectorFactoryCollection;
import edu.umd.cs.findbugs.HTMLBugReporter;
import edu.umd.cs.findbugs.Project;
import edu.umd.cs.findbugs.SortedBugCollection;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.TextUIBugReporter;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.config.CommandLine;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashSet;

public class PrintingBugReporter
extends TextUIBugReporter {
    private String stylesheet = null;
    private boolean annotationUploadFormat = false;
    private HashSet<BugInstance> seenAlready = new HashSet();

    public void observeClass(ClassDescriptor classDescriptor) {
    }

    protected void doReportBug(BugInstance bugInstance) {
        if (this.seenAlready.add(bugInstance)) {
            this.printBug(bugInstance);
            this.notifyObservers(bugInstance);
        }
    }

    public void finish() {
        this.outputStream.close();
    }

    public static void main(String[] args) throws Exception {
        PrintingBugReporter reporter = new PrintingBugReporter();
        PrintingCommandLine commandLine = reporter.new PrintingCommandLine();
        int argCount = commandLine.parse(args, 0, 2, "Usage: " + PrintingCommandLine.class.getName() + " [options] [<xml results> [<test results]] ");
        DetectorFactoryCollection.instance();
        if (reporter.stylesheet != null) {
            PrintingBugReporter.xslt(reporter.stylesheet, reporter.isApplySuppressions(), args, argCount);
            return;
        }
        Project proj = new Project();
        SortedBugCollection bugCollection = new SortedBugCollection();
        if (argCount < args.length) {
            bugCollection.readXML(args[argCount++], proj);
        } else {
            bugCollection.readXML(System.in, proj);
        }
        if (argCount < args.length) {
            reporter.setOutputStream(new PrintStream(new FileOutputStream(args[argCount++]), true));
        }
        RuntimeException storedException = null;
        if (reporter.annotationUploadFormat) {
            bugCollection.computeBugHashes();
            for (BugInstance warning : bugCollection) {
                try {
                    String fHash = "fb-" + warning.getInstanceHash() + "-" + warning.getInstanceOccurrenceNum() + "-" + warning.getInstanceOccurrenceMax();
                    System.out.print("#" + fHash);
                    String key = warning.getUserDesignationKey();
                    if (key.equals("UNCLASSIFIED") || key.equals("NEEDS_FURTHER_STUDY")) {
                        System.out.print("#-1#" + key);
                    } else if (key.equals("MUST_FIX") || key.equals("SHOULD_FIX")) {
                        System.out.print("#7#" + key);
                    } else {
                        System.out.print("#0#" + key);
                    }
                    SourceLineAnnotation sourceLine = warning.getPrimarySourceLineAnnotation();
                    if (sourceLine != null) {
                        System.out.println("#" + sourceLine.getSourceFile() + "#" + sourceLine.getStartLine());
                    } else {
                        System.out.println("##");
                    }
                    System.out.println(warning.getAnnotationText());
                }
                catch (RuntimeException e) {
                    if (storedException != null) continue;
                    storedException = e;
                }
            }
        } else {
            for (BugInstance warning : bugCollection.getCollection()) {
                if (reporter.isApplySuppressions() && proj.getSuppressionFilter().match(warning)) continue;
                try {
                    reporter.printBug(warning);
                }
                catch (RuntimeException e) {
                    if (storedException != null) continue;
                    storedException = e;
                }
            }
        }
        if (storedException != null) {
            throw storedException;
        }
    }

    public static void xslt(String stylesheet, boolean applySuppression, String[] args, int argCount) throws Exception {
        Project proj = new Project();
        HTMLBugReporter reporter = new HTMLBugReporter(proj, stylesheet);
        BugCollection bugCollection = reporter.getBugCollection();
        bugCollection.setApplySuppressions(applySuppression);
        if (argCount < args.length) {
            proj.setProjectFileName(args[argCount]);
            bugCollection.readXML(args[argCount++], proj);
        } else {
            bugCollection.readXML(System.in, proj);
        }
        if (argCount < args.length) {
            reporter.setOutputStream(new PrintStream(new FileOutputStream(args[argCount++]), true));
        }
        reporter.finish();
        Exception e = reporter.getFatalException();
        if (e != null) {
            throw e;
        }
    }

    class PrintingCommandLine
    extends CommandLine {
        public PrintingCommandLine() {
            this.addSwitch("-longBugCodes", "use long bug codes when generating text");
            this.addSwitch("-designations", "report user designations for each bug");
            this.addSwitch("-history", "report first and last versions for each bug");
            this.addSwitch("-applySuppression", "exclude any bugs that match suppression filters");
            this.addSwitch("-annotationUpload", "generate annotations in upload format");
            this.addSwitchWithOptionalExtraPart("-html", "stylesheet", "Generate HTML output (default stylesheet is default.xsl)");
        }

        protected void handleOption(String option, String optionExtraPart) throws IOException {
            if (option.equals("-longBugCodes")) {
                PrintingBugReporter.this.setUseLongBugCodes(true);
            } else if (option.equals("-designations")) {
                PrintingBugReporter.this.setReportUserDesignations(true);
            } else if (option.equals("-applySuppression")) {
                PrintingBugReporter.this.setApplySuppressions(true);
            } else if (option.equals("-history")) {
                PrintingBugReporter.this.setReportHistory(true);
            } else if (option.equals("-annotationUpload")) {
                PrintingBugReporter.this.annotationUploadFormat = true;
            } else if (option.equals("-html")) {
                if (!optionExtraPart.equals("")) {
                    PrintingBugReporter.this.stylesheet = optionExtraPart;
                } else {
                    PrintingBugReporter.this.stylesheet = "default.xsl";
                }
            } else {
                throw new IllegalArgumentException("Unknown option '" + option + "'");
            }
        }

        protected void handleOptionWithArgument(String option, String argument) throws IOException {
        }
    }
}

