/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.BugAnnotation;
import edu.umd.cs.findbugs.BugAnnotationUtil;
import edu.umd.cs.findbugs.BugAnnotationVisitor;
import edu.umd.cs.findbugs.ClassAnnotation;
import edu.umd.cs.findbugs.FindBugsMessageFormat;
import edu.umd.cs.findbugs.I18N;
import edu.umd.cs.findbugs.util.Strings;
import edu.umd.cs.findbugs.xml.XMLAttributeList;
import edu.umd.cs.findbugs.xml.XMLOutput;
import java.io.IOException;

public class StringAnnotation
implements BugAnnotation {
    private static final long serialVersionUID = 1L;
    public static final String DEFAULT_ROLE = "STRING_DEFAULT";
    public static final String STRING_CONSTANT_ROLE = "STRING_CONSTANT";
    public static final String PARAMETER_NAME_ROLE = "STRING_PARAMETER_NAME";
    public static final String TYPE_QUALIFIER_ROLE = "STRING_TYPE_QUALIFIER";
    public static final String REMAINING_OBLIGATIONS_ROLE = "STRING_REMAINING_OBLIGATIONS";
    public static final String FORMAT_STRING_ROLE = "STRING_FORMAT_STRING";
    public static final String FORMAT_SPECIFIER_ROLE = "STRING_FORMAT_SPECIFIER";
    private final String value;
    private String description;
    private static final String ELEMENT_NAME = "String";

    public StringAnnotation(String value) {
        this.value = value;
        this.description = DEFAULT_ROLE;
    }

    public static StringAnnotation fromXMLEscapedString(String value) {
        return new StringAnnotation(Strings.unescapeXml(value));
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public String getValue() {
        return this.value;
    }

    public void accept(BugAnnotationVisitor visitor) {
        visitor.visitStringAnnotation(this);
    }

    public String format(String key, ClassAnnotation primaryClass) {
        return this.value;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof StringAnnotation)) {
            return false;
        }
        return this.value.equals(((StringAnnotation)o).value);
    }

    public int compareTo(BugAnnotation o) {
        if (!(o instanceof StringAnnotation)) {
            return this.getClass().getName().compareTo(o.getClass().getName());
        }
        return this.value.compareTo(((StringAnnotation)o).value);
    }

    public String toString() {
        String pattern = I18N.instance().getAnnotationDescription(this.description);
        FindBugsMessageFormat format = new FindBugsMessageFormat(pattern);
        return format.format(new BugAnnotation[]{this}, null);
    }

    public void writeXML(XMLOutput xmlOutput) throws IOException {
        this.writeXML(xmlOutput, false, false);
    }

    public void writeXML(XMLOutput xmlOutput, boolean addMessages, boolean isPrimary) throws IOException {
        XMLAttributeList attributeList = new XMLAttributeList().addAttribute("value", this.value);
        String role = this.getDescription();
        if (!role.equals(DEFAULT_ROLE)) {
            attributeList.addAttribute("role", role);
        }
        BugAnnotationUtil.writeXML(xmlOutput, ELEMENT_NAME, this, attributeList, addMessages);
    }

    public boolean isSignificant() {
        return true;
    }

    static class QuotedStringMarker {
        QuotedStringMarker() {
        }
    }
}

