/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import java.net.URLDecoder;

public class SystemProperties {
    public static final boolean ASSERTIONS_ENABLED;

    public static boolean getBoolean(String arg0) {
        try {
            return Boolean.getBoolean(arg0);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean getBoolean(String name, boolean defaultValue) {
        boolean result = defaultValue;
        try {
            String value = System.getProperty(name);
            if (value == null) {
                return defaultValue;
            }
            result = SystemProperties.toBoolean(value);
        }
        catch (IllegalArgumentException e) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return result;
    }

    private static boolean toBoolean(String name) {
        return name != null && name.equalsIgnoreCase("true");
    }

    public static Integer getInteger(String arg0, int arg1) {
        try {
            return Integer.getInteger(arg0, arg1);
        }
        catch (Exception e) {
            return arg1;
        }
    }

    public static String getProperty(String arg0) {
        String value = null;
        try {
            value = System.getProperty(arg0);
            String urlEncoded = "URLENCODED:";
            if (value.startsWith(urlEncoded)) {
                value = URLDecoder.decode(value.substring(urlEncoded.length()), "UTF-8");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value;
    }

    public static String getProperty(String arg0, String arg1) {
        try {
            return System.getProperty(arg0, arg1);
        }
        catch (Exception e) {
            return arg1;
        }
    }

    static {
        boolean tmp = false;
        if (!$assertionsDisabled) {
            tmp = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        ASSERTIONS_ENABLED = tmp;
    }
}

