/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba;

import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.ba.FileSourceFileDataSource;
import edu.umd.cs.findbugs.ba.SourceFile;
import edu.umd.cs.findbugs.ba.SourceFileDataSource;
import edu.umd.cs.findbugs.ba.ZipSourceFileDataSource;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceFinder {
    private static final boolean DEBUG = SystemProperties.getBoolean("srcfinder.debug");
    private static final int CACHE_SIZE = 50;
    private List<SourceRepository> repositoryList;
    private Cache cache;

    public SourceFinder() {
        if (DEBUG) {
            System.out.println("Debugging SourceFinder");
        }
        this.repositoryList = new LinkedList<SourceRepository>();
        this.cache = new Cache();
    }

    public void setSourceBaseList(List<String> sourceBaseList) {
        for (String repos : sourceBaseList) {
            if (repos.endsWith(".zip") || repos.endsWith(".jar")) {
                try {
                    if (repos.startsWith("http:") || repos.startsWith("https:") || repos.startsWith("file:")) {
                        this.repositoryList.add(new JarURLConnectionSourceRepository(repos));
                        continue;
                    }
                    this.repositoryList.add(new ZipSourceRepository(new ZipFile(repos)));
                }
                catch (IOException e) {}
                continue;
            }
            this.repositoryList.add(new DirectorySourceRepository(repos));
        }
    }

    public InputStream openSource(String packageName, String fileName) throws IOException {
        SourceFile sourceFile = this.findSourceFile(packageName, fileName);
        return sourceFile.getInputStream();
    }

    public InputStream openSource(SourceLineAnnotation source) throws IOException {
        SourceFile sourceFile = this.findSourceFile(source);
        return sourceFile.getInputStream();
    }

    public SourceFile findSourceFile(SourceLineAnnotation source) throws IOException {
        if (source.isSourceFileKnown()) {
            return this.findSourceFile(source.getPackageName(), source.getSourceFile());
        }
        String packageName = source.getPackageName();
        String baseClassName = source.getClassName();
        int i = baseClassName.lastIndexOf(46);
        int j = (baseClassName = baseClassName.substring(i + 1)).indexOf("$");
        if (j >= 0) {
            baseClassName = baseClassName.substring(0, j);
        }
        return this.findSourceFile(packageName, baseClassName + ".java");
    }

    public SourceFile findSourceFile(String packageName, String fileName) throws IOException {
        String platformName = packageName.replace('.', File.separatorChar) + (packageName.length() > 0 ? File.separator : "") + fileName;
        String canonicalName = packageName.replace('.', '/') + (packageName.length() > 0 ? "/" : "") + fileName;
        SourceFile sourceFile = (SourceFile)this.cache.get(canonicalName);
        if (sourceFile != null) {
            return sourceFile;
        }
        if (DEBUG) {
            System.out.println("Trying " + fileName + " in package " + packageName + "...");
        }
        for (SourceRepository repos : this.repositoryList) {
            String string = fileName = repos.isPlatformDependent() ? platformName : canonicalName;
            if (DEBUG) {
                System.out.println("Looking in " + repos + " for " + fileName);
            }
            if (!repos.contains(fileName)) continue;
            sourceFile = new SourceFile(repos.getDataSource(fileName));
            this.cache.put(canonicalName, sourceFile);
            return sourceFile;
        }
        throw new FileNotFoundException("Can't find source file " + fileName);
    }

    static class ZipSourceRepository
    implements SourceRepository {
        ZipFile zipFile;

        public ZipSourceRepository(ZipFile zipFile) {
            this.zipFile = zipFile;
        }

        public boolean contains(String fileName) {
            return this.zipFile.getEntry(fileName) != null;
        }

        public boolean isPlatformDependent() {
            return false;
        }

        public SourceFileDataSource getDataSource(String fileName) {
            return new ZipSourceFileDataSource(this.zipFile, fileName);
        }
    }

    static class JarURLConnectionSourceRepository
    extends ZipSourceRepository {
        public JarURLConnectionSourceRepository(String url) throws MalformedURLException, IOException {
            super(((JarURLConnection)new URL("jar:" + url + "!/").openConnection()).getJarFile());
            if (DEBUG) {
                System.out.println("JarURLConnectionSourceRepository entries");
                Enumeration<? extends ZipEntry> e = this.zipFile.entries();
                while (e.hasMoreElements()) {
                    ZipEntry ze = e.nextElement();
                    System.out.println(ze.getName());
                }
            }
        }
    }

    private static class DirectorySourceRepository
    implements SourceRepository {
        private String baseDir;

        public DirectorySourceRepository(String baseDir) {
            this.baseDir = baseDir;
        }

        public String toString() {
            return "DirectorySourceRepository:" + this.baseDir;
        }

        public boolean contains(String fileName) {
            File file = new File(this.getFullFileName(fileName));
            boolean exists = file.exists();
            if (DEBUG) {
                System.out.println("Exists " + exists + " for " + file);
            }
            return exists;
        }

        public boolean isPlatformDependent() {
            return true;
        }

        public SourceFileDataSource getDataSource(String fileName) {
            return new FileSourceFileDataSource(this.getFullFileName(fileName));
        }

        private String getFullFileName(String fileName) {
            return this.baseDir + File.separator + fileName;
        }
    }

    private static interface SourceRepository {
        public boolean contains(String var1);

        public boolean isPlatformDependent();

        public SourceFileDataSource getDataSource(String var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Cache
    extends LinkedHashMap<String, SourceFile> {
        private static final long serialVersionUID = 1L;

        private Cache() {
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, SourceFile> eldest) {
            return this.size() >= 50;
        }
    }
}

