/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.obl;

import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.ba.obl.Obligation;
import edu.umd.cs.findbugs.ba.obl.ObligationPolicyDatabase;
import edu.umd.cs.findbugs.ba.obl.ObligationPolicyDatabaseAction;
import edu.umd.cs.findbugs.ba.obl.ObligationPolicyDatabaseActionType;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.ReferenceType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstructionActionCache {
    private static final boolean DEBUG_LOOKUP = SystemProperties.getBoolean("oa.debug.lookup");
    private ObligationPolicyDatabase database;
    private Map<InstructionHandle, Collection<ObligationPolicyDatabaseAction>> actionCache;

    public InstructionActionCache(ObligationPolicyDatabase database) {
        this.database = database;
        this.actionCache = new HashMap<InstructionHandle, Collection<ObligationPolicyDatabaseAction>>();
    }

    public Collection<ObligationPolicyDatabaseAction> getActions(InstructionHandle handle, ConstantPoolGen cpg) {
        Collection<ObligationPolicyDatabaseAction> actionList = this.actionCache.get(handle);
        if (actionList == null) {
            InvokeInstruction inv;
            String signature;
            Instruction ins = handle.getInstruction();
            actionList = Collections.emptyList();
            if (ins instanceof InvokeInstruction && (signature = (inv = (InvokeInstruction)ins).getSignature(cpg)).indexOf(59) >= -1) {
                actionList = new LinkedList<ObligationPolicyDatabaseAction>();
                if (signature.substring(0, signature.indexOf(41)).indexOf("Ljava/io/Closeable;") >= 0) {
                    actionList.add(ObligationPolicyDatabaseAction.CLEAR);
                } else {
                    ReferenceType receiverType = inv.getReferenceType(cpg);
                    String methodName = inv.getName(cpg);
                    boolean isStatic = inv.getOpcode() == 184;
                    this.database.getActions(receiverType, methodName, signature, isStatic, actionList);
                    if (actionList.isEmpty()) {
                        actionList = Collections.emptyList();
                    }
                }
                if (DEBUG_LOOKUP && !actionList.isEmpty()) {
                    System.out.println("  At " + handle + ": " + actionList);
                }
            }
            this.actionCache.put(handle, actionList);
        }
        return actionList;
    }

    public boolean addsObligation(InstructionHandle handle, ConstantPoolGen cpg, Obligation obligation) {
        return this.hasAction(handle, cpg, obligation, ObligationPolicyDatabaseActionType.ADD);
    }

    public boolean deletesObligation(InstructionHandle handle, ConstantPoolGen cpg, Obligation obligation) {
        return this.hasAction(handle, cpg, obligation, ObligationPolicyDatabaseActionType.DEL);
    }

    private boolean hasAction(InstructionHandle handle, ConstantPoolGen cpg, Obligation obligation, ObligationPolicyDatabaseActionType actionType) {
        Collection<ObligationPolicyDatabaseAction> actionList = this.getActions(handle, cpg);
        for (ObligationPolicyDatabaseAction action : actionList) {
            if (action.getActionType() != actionType || !action.getObligation().equals(obligation)) continue;
            return true;
        }
        return false;
    }
}

