/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.vna;

import edu.umd.cs.findbugs.ba.vna.ValueNumber;
import edu.umd.cs.findbugs.internalAnnotations.DottedClassName;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.CheckForNull;

public class ValueNumberFactory {
    private ArrayList<ValueNumber> allocatedValueList = new ArrayList();
    private HashMap<String, ValueNumber> classObjectValueMap = new HashMap();

    public ValueNumber createFreshValue() {
        ValueNumber result = ValueNumber.createValueNumber(this.getNumValuesAllocated());
        this.allocatedValueList.add(result);
        return result;
    }

    public ValueNumber createFreshValue(int flags) {
        ValueNumber result = ValueNumber.createValueNumber(this.getNumValuesAllocated(), flags);
        this.allocatedValueList.add(result);
        return result;
    }

    public ValueNumber forNumber(int number) {
        if (number >= this.getNumValuesAllocated()) {
            throw new IllegalArgumentException("Value " + number + " has not been allocated");
        }
        return this.allocatedValueList.get(number);
    }

    public int getNumValuesAllocated() {
        return this.allocatedValueList.size();
    }

    @Deprecated
    public void compact(int[] map, int numValuesAllocated) {
        throw new UnsupportedOperationException();
    }

    public ValueNumber getClassObjectValue(@DottedClassName String className) {
        ValueNumber value = this.classObjectValueMap.get(className = className.replace('/', '.'));
        if (value == null) {
            value = this.createFreshValue(4);
            this.classObjectValueMap.put(className, value);
        }
        return value;
    }

    @CheckForNull
    @DottedClassName
    public String getClassName(ValueNumber v) {
        if (!v.hasFlag(4)) {
            throw new IllegalArgumentException("Not a value number for a constant class");
        }
        for (Map.Entry<String, ValueNumber> e : this.classObjectValueMap.entrySet()) {
            if (!e.getValue().equals(v)) continue;
            return e.getKey();
        }
        return null;
    }
}

