/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugCollection;
import edu.umd.cs.findbugs.BugCollectionBugReporter;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugPattern;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector2;
import edu.umd.cs.findbugs.DetectorFactory;
import edu.umd.cs.findbugs.MethodAnnotation;
import edu.umd.cs.findbugs.NonReportingDetector;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.annotations.ExpectWarning;
import edu.umd.cs.findbugs.annotations.NoWarning;
import edu.umd.cs.findbugs.ba.XClass;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.DescriptorFactory;
import edu.umd.cs.findbugs.classfile.Global;
import edu.umd.cs.findbugs.classfile.MethodDescriptor;
import edu.umd.cs.findbugs.classfile.analysis.AnnotationValue;
import edu.umd.cs.findbugs.plan.AnalysisPass;
import edu.umd.cs.findbugs.plan.ExecutionPlan;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class CheckExpectedWarnings
implements Detector2,
NonReportingDetector {
    private static final boolean DEBUG = SystemProperties.getBoolean("cew.debug");
    private BugCollectionBugReporter reporter;
    private Set<String> possibleBugCodes;
    private Map<MethodDescriptor, Collection<BugInstance>> warningsByMethod;
    private ClassDescriptor expectWarning;
    private ClassDescriptor noWarning;
    private boolean warned;

    public CheckExpectedWarnings(BugReporter bugReporter) {
        BugReporter realBugReporter = bugReporter.getRealBugReporter();
        if (realBugReporter instanceof BugCollectionBugReporter) {
            this.reporter = (BugCollectionBugReporter)realBugReporter;
            this.expectWarning = DescriptorFactory.createClassDescriptor(ExpectWarning.class);
            this.noWarning = DescriptorFactory.createClassDescriptor(NoWarning.class);
        }
    }

    public void visitClass(ClassDescriptor classDescriptor) throws CheckedAnalysisException {
        if (this.reporter == null) {
            if (!this.warned) {
                System.err.println("*** NOTE ***: CheckExpectedWarnings disabled because bug reporter doesn't use a BugCollection");
                this.warned = true;
            }
            return;
        }
        if (this.warningsByMethod == null) {
            this.warningsByMethod = new HashMap<MethodDescriptor, Collection<BugInstance>>();
            BugCollection bugCollection = this.reporter.getBugCollection();
            for (BugInstance warning : bugCollection) {
                MethodAnnotation methodAnnotation = warning.getPrimaryMethod();
                if (methodAnnotation == null) continue;
                MethodDescriptor methodDesc = methodAnnotation.toXMethod().getMethodDescriptor();
                Collection<BugInstance> warnings = this.warningsByMethod.get(methodDesc);
                if (warnings == null) {
                    warnings = new LinkedList<BugInstance>();
                    this.warningsByMethod.put(methodDesc, warnings);
                }
                warnings.add(warning);
            }
            this.possibleBugCodes = new HashSet<String>();
            ExecutionPlan executionPlan = Global.getAnalysisCache().getDatabase(ExecutionPlan.class);
            Iterator<AnalysisPass> i = executionPlan.passIterator();
            while (i.hasNext()) {
                AnalysisPass analysisPass = i.next();
                Iterator<DetectorFactory> j = analysisPass.iterator();
                while (j.hasNext()) {
                    DetectorFactory factory = j.next();
                    Set<BugPattern> reportedPatterns = factory.getReportedBugPatterns();
                    for (BugPattern pattern : reportedPatterns) {
                        this.possibleBugCodes.add(pattern.getAbbrev());
                    }
                }
            }
            if (DEBUG) {
                System.out.println("CEW: possible warnings are " + this.possibleBugCodes);
            }
        }
        XClass xclass = Global.getAnalysisCache().getClassAnalysis(XClass.class, classDescriptor);
        List<? extends XMethod> methods = xclass.getXMethods();
        for (XMethod xMethod : methods) {
            if (DEBUG) {
                System.out.println("CEW: checking " + xMethod.toString());
            }
            this.check(xMethod, this.expectWarning, true);
            this.check(xMethod, this.noWarning, false);
        }
    }

    private void check(XMethod xmethod, ClassDescriptor annotation, boolean expectWarnings) {
        AnnotationValue expect = xmethod.getAnnotation(annotation);
        if (expect != null) {
            if (DEBUG) {
                System.out.println("*** Found " + annotation + " annotation");
            }
            String expectedBugCodes = (String)expect.getValue("value");
            StringTokenizer tok = new StringTokenizer(expectedBugCodes, ",");
            while (tok.hasMoreTokens()) {
                String bugCode = tok.nextToken();
                int count = this.countWarnings(xmethod.getMethodDescriptor(), bugCode);
                if (DEBUG) {
                    System.out.println("  *** Found " + count + " " + bugCode + " warnings");
                }
                if (expectWarnings && count == 0 && this.possibleBugCodes.contains(bugCode)) {
                    this.reporter.reportBug(new BugInstance(this, "FB_MISSING_EXPECTED_WARNING", 2).addClassAndMethod(xmethod.getMethodDescriptor()).addString(bugCode));
                    continue;
                }
                if (expectWarnings || count <= 0) continue;
                this.reporter.reportBug(new BugInstance(this, "FB_UNEXPECTED_WARNING", 2).addClassAndMethod(xmethod.getMethodDescriptor()).addString(bugCode));
            }
        }
    }

    private int countWarnings(MethodDescriptor methodDescriptor, String bugCode) {
        int count = 0;
        Collection<BugInstance> warnings = this.warningsByMethod.get(methodDescriptor);
        if (warnings != null) {
            for (BugInstance warning : warnings) {
                BugPattern pattern = warning.getBugPattern();
                if (!pattern.getAbbrev().equals(bugCode)) continue;
                ++count;
            }
        }
        return count;
    }

    public void finishPass() {
    }

    public String getDetectorClassName() {
        return CheckExpectedWarnings.class.getName();
    }
}

